/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.util.Enumeration;
import javax.swing.tree.DefaultTreeModel;
import oracle.dbtools.migration.workbench.core.navigator.CaptureRepositoryDatabaseManager;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedRepositoryDatabaseManager;
import oracle.dbtools.migration.workbench.core.navigator.MigrationNavWindow;
import oracle.dbtools.migration.workbench.core.navigator.MigrationOverlayClient;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.migration.workbench.core.repository.DeleteCapturedConnection;
import oracle.dbtools.migration.workbench.core.repository.DeleteConvertedConnection;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.navigator.NavActionListener;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;

public class MigrationNavigatorController
extends DatabaseNavigatorController {
    private int cmdDebugId = Ide.findOrCreateCmdID((String)"DebugSelectionCommand");
    private int cmdRunId = Ide.findOrCreateCmdID((String)"RunSelectionCommand");
    public static final int COLLAPSEALL_CONNECTIONS_ID = Ide.findOrCreateCmdID((String)"MigrationNavigator.COLLAPSEALL_CONNECTIONS");

    public MigrationNavigatorController(Controller controller) {
        super(controller);
        IdeAction ideAction;
        IdeAction ideAction2;
        ObjectActionController.addListener((IObjectActionListener)new NavActionListener(CaptureRepositoryDatabaseManager.getInstance()));
        ObjectActionController.addListener((IObjectActionListener)new NavActionListener(ConvertedRepositoryDatabaseManager.getInstance()));
        L l = new L();
        Node.addNodeListenerForType(CapturedNode.class, (NodeListener)l);
        IdeAction ideAction3 = IdeAction.find((int)20);
        if (ideAction3 != null) {
            ideAction3.addController((Controller)this);
        }
        if ((ideAction2 = IdeAction.find((int)this.cmdDebugId)) != null) {
            ideAction2.addController((Controller)this);
        }
        if ((ideAction = IdeAction.find((int)this.cmdRunId)) != null) {
            ideAction.addController((Controller)this);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        TreeExplorer treeExplorer;
        Element element = context.getElement();
        int n = ideAction.getCommandId();
        if (n == 20) {
            if (element instanceof DatabaseConnection) {
                return super.handleEvent(ideAction, context);
            }
            if (element instanceof CapturedConnectionNode || element instanceof ConvertedConnectionNode) {
                this.deleteSelectedNodes(context);
                return true;
            }
        } else if (n == COLLAPSEALL_CONNECTIONS_ID && (treeExplorer = ((MigrationNavWindow)context.getView()).getTreeExplorer()) != null) {
            TNode tNode = treeExplorer.getRoot();
            DefaultTreeModel defaultTreeModel = treeExplorer.getTreeModel();
            if (tNode != null && defaultTreeModel.getChildCount(tNode) > 0) {
                Enumeration enumeration = tNode.getChildTNodes();
                while (enumeration.hasMoreElements()) {
                    TNode tNode2 = (TNode)enumeration.nextElement();
                    if (tNode2 == null) continue;
                    treeExplorer.collapse(tNode2, false);
                }
            }
        }
        return false;
    }

    private void deleteSelectedNodes(Context context) {
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 0) {
            AbstractMenuAction abstractMenuAction = null;
            if (elementArray[0] instanceof CapturedConnectionNode) {
                abstractMenuAction = new DeleteCapturedConnection();
            } else if (elementArray[0] instanceof ConvertedConnectionNode) {
                abstractMenuAction = new DeleteConvertedConnection();
            }
            abstractMenuAction.setContext(context);
            abstractMenuAction.setDBObject(new DBObject(elementArray[0]));
            abstractMenuAction.launch();
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        Element element = context.getElement();
        if (n == 20) {
            if (element instanceof DatabaseConnection) {
                bl = super.update(ideAction, context);
            } else if (element instanceof CapturedConnectionNode || element instanceof ConvertedConnectionNode) {
                ideAction.setEnabled(true);
                bl = true;
            }
        }
        if (element instanceof CapturedNode && (n == this.cmdDebugId || n == this.cmdRunId)) {
            ideAction.setEnabled(false);
            bl = true;
        }
        return bl;
    }

    private static final class L
    extends NodeListener {
        private L() {
        }

        public void nodeOpened(NodeEvent nodeEvent) {
            this.updateNodeState(nodeEvent);
        }

        private void updateNodeState(NodeEvent nodeEvent) {
            IconOverlayTracker iconOverlayTracker = MigrationOverlayClient.getTracker();
            if (iconOverlayTracker != null) {
                iconOverlayTracker.validateOverlay((Element)nodeEvent.getNode());
                iconOverlayTracker.repaintOverlays();
            }
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            this.updateNodeState(nodeEvent);
        }
    }
}

