/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.ModelValue;
import oracle.dbtools.migration.workbench.core.navigator.SourceChooserToolbarManagedConn;
import oracle.dbtools.migration.workbench.core.navigator.TargetChooserToolbarManagedConn;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.display.IModifyToolbar;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.Toolbar;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class DataQualityToolbar
implements IModifyToolbar {
    static String _defaultConn = null;
    static String _capturedId = null;
    static String _convertedId = null;
    static final String CAPCONNID = "&SQLDEVPREF_SOURCECONNID";
    static final String CONCONNID = "&SQLDEVPREF_TARGETCONNID";
    static final String GATHERROWSTATSSQL = "TRUNCATE TABLE md_numrow$source; \nTRUNCATE TABLE md_numrow$target;\nBRIDGE md_numrow$source AS  &SQLDEVPREF_SOURCECONN(select count(*) as numrows, ':SQLDEVTABLENAME' as name, :SQLDEVOBJID as objid from {select qualifiedname SQLDEVTABLENAME,objid SQLDEVOBJID from mgv_all_tables_details where capturedorconverted='CAPTURED' and connid=&SQLDEVPREF_SOURCECONNID})APPEND,       md_numrow$target AS  &SQLDEVPREF_TARGETCONN(select count(*) as numrows, ':SQLDEVTABLENAME' as name, :SQLDEVOBJID as objid from {select qualifiedname SQLDEVTABLENAME,objid SQLDEVOBJID from mgv_all_tables_details where capturedorconverted='CONVERTED' and connid=&SQLDEVPREF_TARGETCONNID})APPEND;";
    static final String CONNECTIONSSQL = "select p.project_name projectName,c.name connName,c.id srcid, (select derived_id from md_derivatives where src_id = c.id AND derivative_reason IS NULL) targetid from md_connections c,md_projects  p where  c.project_id_fk = p.id and c.type IS NULL";

    public void modifyToolbar(Toolbar toolbar) {
        JLabel jLabel = new JLabel("Model:");
        toolbar.add(Box.createHorizontalGlue());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        toolbar.add((Component)jPanel);
        jPanel.setVisible(false);
        toolbar.add((Component)jLabel);
        toolbar.add(Box.createHorizontalStrut(10));
        toolbar.add((Component)this.getDataQualityModelChooser());
        SourceChooserToolbarManagedConn sourceChooserToolbarManagedConn = new SourceChooserToolbarManagedConn();
        TargetChooserToolbarManagedConn targetChooserToolbarManagedConn = new TargetChooserToolbarManagedConn();
        sourceChooserToolbarManagedConn.addConnectionCombo(toolbar, false);
        targetChooserToolbarManagedConn.addConnectionCombo(toolbar, false);
        AbstractAction abstractAction = new AbstractAction("Analyse", OracleIcons.getIcon((String)"add.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = MessageDialog.optionalConfirmOrCancel((String)"DataQualityAnalysis", (Component)Ide.getMainWindow(), (String)"This will perform a full table scan on all the source and target tables.\n Do you want to proceed?", (String)"Confirm Full Table Scan", null);
                if (n == 1) {
                    RaptorTask<Void> raptorTask = new RaptorTask<Void>("DataQualityAnalysis"){
                        ScriptExecutor _sr;
                        {
                            this._sr = null;
                        }

                        protected Void doWork() throws TaskException {
                            Connection connection = null;
                            try {
                                connection = Connections.getInstance().getConnection(MigrationAddin.getRepositoryConnectionName());
                            }
                            catch (DBException dBException) {
                                dBException.printStackTrace();
                            }
                            this._sr = new ScriptExecutor(DataQualityToolbar.GATHERROWSTATSSQL, connection);
                            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
                            scriptRunnerContext.setSqlError(4);
                            this._sr.setScriptRunnerContext(scriptRunnerContext);
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                            this._sr.setOut(bufferedOutputStream);
                            this._sr.run();
                            if (scriptRunnerContext.getProperty("sqldev.error").equals(Boolean.TRUE)) {
                                // empty if block
                            }
                            return null;
                        }

                        public boolean cancel() {
                            this._sr.getScriptRunnerContext().setExited(true);
                            this._sr.interrupt();
                            return true;
                        }
                    };
                    raptorTask.setCancellable(true);
                    RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
                }
            }
        };
        JButton jButton = new JButton(abstractAction);
        toolbar.add((Component)jButton);
    }

    private JComboBox getDataQualityModelChooser() {
        Vector<ModelValue> vector = DataQualityToolbar.getModelList();
        JComboBox jComboBox = DataQualityToolbar.getModelChooser(vector);
        jComboBox.addItemListener(new ComboListener(jComboBox));
        for (ModelValue modelValue : vector) {
            String string = this.getCapturedId();
            if (modelValue == null || !modelValue.getCapturedId().equals(string)) continue;
            jComboBox.setSelectedItem(modelValue);
        }
        return jComboBox;
    }

    private String getCapturedId() {
        Preferences preferences = Preferences.getPreferences();
        MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
        HashMap<String, String> hashMap = migrationConfig.getBridgeReplace();
        return hashMap.get(CAPCONNID);
    }

    public static JComboBox getModelChooser(Vector<ModelValue> vector) {
        JComboBox<ModelValue> jComboBox = new JComboBox<ModelValue>(vector);
        jComboBox.setSize(new Dimension(150, 20));
        jComboBox.setPreferredSize(new Dimension(150, 20));
        jComboBox.setMaximumSize(jComboBox.getPreferredSize());
        return jComboBox;
    }

    public static Vector<ModelValue> getModelList() {
        Vector<ModelValue> vector = new Vector<ModelValue>();
        vector.add(null);
        try {
            PreparedStatement preparedStatement = MigrationAddin.getPersistenceManager().getPreparedStatement(CONNECTIONSSQL);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                vector.add(new ModelValue(string + " : " + string2, string3, string4));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return vector;
    }

    public void modifyToolbar(Toolbar toolbar, Map<String, Object> map) {
        this.modifyToolbar(toolbar);
    }

    public class ComboListener
    implements ItemListener {
        private JComboBox _combo;

        public ComboListener(JComboBox jComboBox) {
            this._combo = jComboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                _capturedId = ((ModelValue)itemEvent.getItem()).getCapturedId();
                _convertedId = ((ModelValue)itemEvent.getItem()).getConvertedId();
                Preferences preferences = Preferences.getPreferences();
                MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
                migrationConfig.setBridgeReplace(DataQualityToolbar.CAPCONNID, _capturedId);
                migrationConfig.setBridgeReplace(DataQualityToolbar.CONCONNID, _convertedId);
            }
        }
    }
}

