/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.convert.NoCopyFoundException;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.ConvertInitiator;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.ConvertDailogTaskUI;
import oracle.dbtools.migration.workbench.core.ui.ConvertRunnerTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;

public class ReConvertInitiator
extends ConvertInitiator {
    @Override
    public void launch() {
        Object object;
        Context context = this.getContext();
        DBObject dBObject = this.getDBObject();
        if (null == dBObject) {
            object = context.getSelection();
            assert (object != null && ((Element[])object).length > 0);
            dBObject = new DBObject(object[0]);
        }
        Object object2 = object = MigrationUtils.getConnforDBObject(dBObject);
        try {
            object = ConvertUtils.findOriginalConnection((MdConnection)object, MigrationAddin.getPersistenceManager(), ((PersistableObject)object).getKey());
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, noSuchObjectException.getStackTrace()[0].toString(), noSuchObjectException);
        }
        catch (NoCopyFoundException noCopyFoundException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, noCopyFoundException.getStackTrace()[0].toString(), noCopyFoundException);
        }
        try {
            MigrationObjectFilterList migrationObjectFilterList = MigrationFilterUtil.generateFilters(context);
            String string = "";
            if (object != null) {
                string = MigrationUtils.getPluginIdForConnection((MdConnection)object);
            }
            if (string.equals("")) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MSG_CANNOT_CONVERT"), (String)MigrationAddinArb.getString("TITLE_CANNOT_CONVERT"), (String)"help_migr_no_plugin_saved");
                return;
            }
            MigrationPlugin migrationPlugin = MigrationAddin.findPlugin(string);
            if (migrationPlugin == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MSG_PLUGIN_NO_LONGER_AVAILABLE"), (String)MigrationAddinArb.getString("TITLE_CANNOT_CONVERT"), (String)"help_migr_plugin_unavailable");
                return;
            }
            Converter converter = migrationPlugin.getConverter();
            SupportedDataTypesMap supportedDataTypesMap = migrationPlugin.getSupportedDataTypesMap();
            DBObjectId dBObjectId = this.getMapId(MigrationAddin.getPersistenceManager(), ((PersistableObject)object).getKey(), ((MdConnection)object).getProjectId(), supportedDataTypesMap);
            if (dBObjectId == null) {
                return;
            }
            ConverterWorker converterWorker = new ConverterWorker(MigrationAddin.getPersistenceManager(), ((PersistableObject)object).getKey(), converter, dBObjectId, migrationObjectFilterList, (MdConnection)object2);
            ConvertRunnerTask convertRunnerTask = new ConvertRunnerTask(converterWorker, migrationPlugin.getPlatformMask(), ((MdConnection)object).getName());
            final ConvertDailogTaskUI convertDailogTaskUI = new ConvertDailogTaskUI(convertRunnerTask.getDescriptor());
            converterWorker.addEventListener(convertDailogTaskUI);
            this.attachPostProcessCallback(convertRunnerTask, dBObject);
            RaptorTaskManager.getInstance().addTask((RaptorTask)convertRunnerTask, Collections.singletonList(new ITaskViewer(){

                public void addTaskUI(ITaskUI iTaskUI) {
                }

                public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                    return convertDailogTaskUI;
                }

                public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                    return this.getTaskUI(raptorTaskDescriptor);
                }

                public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                }

                public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                }
            }));
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string == null) {
                string = "MigrationLog.UNKNOWN_ERROR";
            }
            MigrationLogUtil.logThrowable(string, Messages.getString("ConvertInitiator.5"), (Throwable)exception);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public boolean isEnabled(Context context) {
        Element[] elementArray = context.getSelection();
        MdConnection mdConnection = MigrationUtils.getConnforElement(elementArray[0]);
        return mdConnection.getComments().indexOf("/*CONVERTED COMPLETE*/") == -1;
    }
}

