/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.migration.capture.DatabaseProviderRegistry;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.FullMigrateTask;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.ConnectionPanelUI;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;

public class MigrationEstimationLauncher
extends AbstractMenuAction {
    private final String ESTIMATION_PROJECT_BASE = "Estimation_";
    private final String PROJECT_EXIST = "SELECT ID FROM MD_PROJECTS WHERE PROJECT_NAME='X'";
    private String _projectId;

    public void launch() {
        block12: {
            Properties properties = new Properties();
            int n = 136;
            Context context = this.getContext();
            TNode[] tNodeArray = (TNode[])context.getProperty("ExplorerContext.TNODES");
            int n2 = tNodeArray != null ? tNodeArray.length : 0;
            ArrayList<String> arrayList = new ArrayList<String>();
            DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
            String string = dBObject != null ? dBObject.getConnectionType() : null;
            Element element = null;
            for (int i = 0; i < n2; ++i) {
                element = tNodeArray[i].getData();
                if (!(element instanceof CatalogFolder) && (!(element instanceof SchemaFolder) || string == null || !string.equals("MySQL"))) continue;
                arrayList.add(element.getLongLabel());
            }
            Connection connection = dBObject.getConnection();
            String string2 = dBObject.getConnectionName();
            MigrationPlugin migrationPlugin = MigrationAddin.getPluginForConnection(connection);
            String string3 = migrationPlugin.getPlatformName();
            String string4 = "Estimation_" + string3;
            String string5 = MigrationAddin.getDefaultMigrationRepository();
            EstimationPanel estimationPanel = new EstimationPanel();
            if (string5 != null) {
                estimationPanel.setRepo(string5);
            }
            estimationPanel.initGUI();
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)estimationPanel, null, (String)MigrationAddinArb.getString("EstimationTitle"));
            jEWTDialog.setResizable(true);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            boolean bl = jEWTDialog.runDialog();
            try {
                Object object;
                if (!bl) break block12;
                String string6 = estimationPanel.getRepoConnection();
                Connection connection2 = null;
                connection2 = Connections.getInstance().getConnection(string6);
                boolean bl2 = RepositoryManager.doesRepositoryExist(connection2);
                if (string6 != null && !bl2) {
                    properties.put("REPO_TRUNC", (Object)false);
                    n |= 2;
                    properties.put("PROJ_NAME", string4);
                    properties.put("PROJ_DESC", "Migration Analysis Report");
                    properties.put("PROJ_OUTDIR", estimationPanel.getEstimationFile());
                    n |= 4;
                } else {
                    if (string6 == null || string6.trim().length() == 0) {
                        throw new Exception(MigrationAddinArb.getString("EstimationInvalidRepo"));
                    }
                    if (!MigrationAddin.isRepositoryOpen()) {
                        MigrationAddin.openRepository(string6);
                    }
                    MigrationAddin.getMigrationConfig().setDefaultRepository(string6);
                    try {
                        Preferences.getPreferences().save();
                    }
                    catch (IOException iOException) {
                        throw new Exception(MigrationAddinArb.getString("EstimationRepoError"));
                    }
                    this._projectId = this.doesProjectExist(connection2, string4);
                    if (this._projectId == null) {
                        properties.put("PROJ_NAME", string4);
                        properties.put("PROJ_DESC", "Migration Analysis Report");
                        properties.put("PROJ_OUTDIR", estimationPanel.getEstimationFile().getParent());
                        n |= 4;
                    } else {
                        long l = Long.parseLong(this._projectId);
                        object = MigrationAddin.getPersistenceManager();
                        MdProject mdProject = MdProject.retrieveExistingInstance(object, new DBObjectId(l));
                        properties.put("PARAM_PROJ", mdProject);
                    }
                }
                properties.put("REPO_CONN", string6);
                Collection<String> collection = null;
                collection = arrayList != null && arrayList.size() > 0 ? arrayList : DatabaseProviderRegistry.getAvailableDBListOnline(string3, string2);
                properties.put("CAPT_MODE", "Online");
                properties.put("CAPT_SRCCONN", string2);
                properties.put("CAPT_DBLIST", collection);
                File file = estimationPanel.getEstimationFile();
                properties.put("PARAM_ESTIMATION_XLSNAME", file);
                object = new FullMigrateTask(n, properties, MigrationAddinArb.getString("EstimationTitle"));
                object.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                    public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                        String string = MigrationAddinArb.getString("EstimationCancelled");
                        MigrationEstimationLauncher.this.showCompletionMessage(string);
                    }

                    public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                        String string = MigrationAddinArb.getString("EstimationFailed") + " : " + raptorTaskEvent.getThrowable().getMessage();
                        MigrationEstimationLauncher.this.showCompletionMessage(string);
                    }

                    public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                        String string = MigrationAddinArb.getString("EstimationSuccessful");
                        MigrationEstimationLauncher.this.showCompletionMessage(string);
                    }
                });
                RaptorTaskManager.getInstance().addTask((RaptorTask)object);
            }
            catch (Exception exception) {
                String string7 = exception.getMessage();
                this.showCompletionMessage(string7);
                if (string7 == null || string7.equals(MigrationAddinArb.getString("EstimationIoError"))) break block12;
                exception.printStackTrace();
            }
        }
    }

    public void setArgs(String string) {
    }

    private String doesProjectExist(Connection connection, String string) {
        String string2 = "SELECT ID FROM MD_PROJECTS WHERE PROJECT_NAME='X'".replace("X", string);
        String string3 = DBUtil.getInstance((Connection)connection).executeReturnOneCol(string2);
        return string3;
    }

    private void showCompletionMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string);
            }
        });
    }

    private class EstimationPanel
    extends JPanel {
        private JLabel _lblEstimationFile;
        private JTextField _txtEstimationFile;
        private JButton _btnBrowse;
        private ConnectionPanelUI _connPanel = null;
        private String _repo = null;
        private long serialVersionUID = -1L;

        EstimationPanel() {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_estimateeffort");
        }

        void setRepo(String string) {
            this._repo = string;
        }

        void initGUI() {
            this.setLayout(new BorderLayout());
            this._lblEstimationFile = new JLabel();
            this._txtEstimationFile = new JTextField("", 20);
            ResourceUtils.resLabel((JLabel)this._lblEstimationFile, (Component)this._txtEstimationFile, (String)MigrationAddinArb.getString("EstimationFileLabel"));
            this._btnBrowse = new JButton();
            ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)MigrationAddinArb.getString("Browse"));
            this._btnBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    URL uRL;
                    URLFileChooser uRLFileChooser = new URLFileChooser();
                    uRLFileChooser.clearChooseableURLFilters();
                    uRLFileChooser.addChooseableURLFilter((URLFilter)new WildcardURLFilter("*.xls", URLFileSystem.isLocalFileSystemCaseSensitive(), MigrationAddinArb.getString("XLSExtension")));
                    uRLFileChooser.setSelectionMode(0);
                    int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), MigrationAddinArb.getString("ChooseDir"));
                    if (n == 0 && (uRL = uRLFileChooser.getSelectedURL()) != null && uRL.toString().length() > 0) {
                        File file = new File(uRL.getPath());
                        String string = file.getAbsolutePath();
                        if (string.toLowerCase().endsWith(".xls")) {
                            EstimationPanel.this._txtEstimationFile.setText(string);
                        } else {
                            EstimationPanel.this._txtEstimationFile.setText(string + ".xls");
                        }
                    }
                }
            });
            this._connPanel = new ConnectionPanelUI(true, false);
            this._connPanel.setConnectionPrompt("");
            this._connPanel.setConnectionLabel(MigrationAddinArb.getString("EstimationConnectionRepository"));
            this._connPanel.setConnectionName(this._repo);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)this._lblEstimationFile, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(10, 0, 0, 5), 0, 0));
            jPanel.add((Component)this._txtEstimationFile, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(10, 5, 0, 0), 0, 0));
            jPanel.add((Component)this._btnBrowse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(10, 5, 0, 5), 0, 0));
            jPanel.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._connPanel, "North");
            this.add((Component)jPanel, "Center");
            this.add((Component)Box.createVerticalBox(), "South");
        }

        File getEstimationFile() throws Exception {
            String string = this._txtEstimationFile.getText();
            if (string == null || string.trim().length() <= 0) {
                throw new Exception(MigrationAddinArb.getString("EstimationIoError"));
            }
            File file = new File(string);
            File file2 = file.getParentFile();
            if (file2 == null || !file2.exists()) {
                throw new Exception(MigrationAddinArb.getString("EstimationIoError"));
            }
            return file;
        }

        String getRepoConnection() {
            return this._connPanel.getConnectionName();
        }
    }
}

