/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.estimation;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.estimation.RSTableMigrationEstimateXLS;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.util.Resource;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.ConnectionException;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MigrationEstimationAction
extends AbstractMenuAction {
    String newConnectionName = null;
    static File _lastUrl = null;
    private static HashMap<String, String> _reportSQLs = null;

    public void launch() {
        this.saveReport(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReport(File file, long l, long l2) {
        try {
            this.createTemporaryConnection();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("IDPROJECT", l);
            hashMap.put("IDCAPCONNECTION", l2);
            RSTableMigrationEstimateXLS rSTableMigrationEstimateXLS = RSTableMigrationEstimateXLS.getInstance();
            rSTableMigrationEstimateXLS.createEstimationPlan((Component)Ide.getMainWindow(), this.newConnectionName, file, hashMap);
        }
        finally {
            this.closeAndDeleteTemporaryConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReport(File file) {
        Object object;
        try {
            this.createTemporaryConnection();
            object = this.getDBObject();
            MdConnection mdConnection = MigrationUtils.getConnforDBObject((DBObject)object);
            RSTableMigrationEstimateXLS rSTableMigrationEstimateXLS = RSTableMigrationEstimateXLS.getInstance();
            long l = 0L;
            long l2 = 0L;
            file = rSTableMigrationEstimateXLS.createEstimationPlan((Component)Ide.getMainWindow(), this.newConnectionName, file, this.getDBObject().getDictionary());
        }
        finally {
            this.closeAndDeleteTemporaryConnection();
            if (Desktop.isDesktopSupported() && file != null) {
                object = Desktop.getDesktop();
                try {
                    ((Desktop)object).open(file);
                }
                catch (IOException iOException) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)(MigrationAddinArb.getString("MIGRATION_COMPLETE") + "\n" + file.getAbsolutePath()), (String)MigrationAddinArb.getString("MIGRATION_COMPLETE"), null);
                }
            }
        }
    }

    private void createTemporaryConnection() {
        String string = MigrationAddin.getRepositoryConnectionName();
        try {
            this.newConnectionName = Connections.getInstance().createPrivateConnection(string);
            Connections.getInstance().getConnection(this.newConnectionName);
        }
        catch (ConnectionException connectionException) {
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    private void closeAndDeleteTemporaryConnection() {
        Connections.getInstance().closeConnection(this.newConnectionName);
        try {
            Connections.getInstance().getTemporaryConnectionStore().removeConnection(this.newConnectionName);
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    static String getChildQuery(Document document, String string) {
        if (_reportSQLs == null) {
            _reportSQLs = new HashMap();
            NodeList nodeList = document.getChildNodes();
            NodeList nodeList2 = nodeList.item(0).getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                DisplayModel displayModel = DisplayModel.getDisplayModel((Node)node);
                String string2 = displayModel.getName();
                String string3 = ((Query)displayModel.getQueries().get(0)).getSql();
                _reportSQLs.put(string2, string3);
                if (displayModel.getChildren() == null) continue;
                MigrationEstimationAction.populateReportSQL(displayModel.getChildren());
            }
        }
        return _reportSQLs.get(string);
    }

    private static void populateReportSQL(List<DisplayModel> list) {
        for (DisplayModel displayModel : list) {
            String string = displayModel.getName();
            String string2 = ((Query)displayModel.getQueries().get(0)).getSql();
            _reportSQLs.put(string, string2);
        }
    }

    static Document getXMLDoc() {
        Document document = null;
        try {
            document = MigrationEstimationAction.getDocument();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return document;
    }

    private static Document getDocument() throws IOException {
        URL[] uRLArray = Resource.getPath((String)"oracle/dbtools/migration/estimation");
        URL uRL = uRLArray[0];
        String string = "jar:" + uRL.getPath() + "EstimationReports.xml";
        URL uRL2 = new URL(string);
        InputStream inputStream = URLFileSystem.openInputStream((URL)uRL2);
        String string2 = "UTF-8";
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string2);
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        try {
            dOMParser.parse((Reader)inputStreamReader);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dOMParser.getDocument();
    }

    public void setArgs(String string) {
    }
}

