/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MgvAllTablesRec;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.DataMoveException;
import oracle.dbtools.migration.datamove.DataMoveMarshal;
import oracle.dbtools.migration.datamove.DataMoveUtils;
import oracle.dbtools.migration.datamove.online.ConstraintHandler;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.datamove.online.DataMoveDrone;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.datamove.online.DroneState;
import oracle.dbtools.migration.datamove.online.IdentityHandler;
import oracle.dbtools.migration.datamove.online.Messages;
import oracle.dbtools.migration.datamove.online.TriggerHandler;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.db.ConnectionException;

public class DataMoveWorker
implements DataMoveMarshal,
Cancelable {
    public static final String MY_ID = "DataMoveWorker";
    private PersistenceManager m_persistenceManager;
    private PersistenceUtility m_persistenceUtility;
    private String m_sourceConnectionName;
    private String m_targetConnectionName;
    private DBObjectId m_targetConnectionId;
    private DataMoveDrone[] m_drones;
    private CloseableIterator<MgvAllTablesRec> m_tables;
    private boolean m_cancelled = false;
    private boolean _truncTable;
    private DataMoveAudience m_audience;
    private boolean m_getCounts;
    private ConstraintHandler m_constraintHandler;
    private TriggerHandler m_triggerHandler;
    private IdentityHandler m_identityHandler;
    private boolean m_qualifyNames;
    private Connection m_targetMaster = null;

    public DataMoveWorker(PersistenceManager persistenceManager, String string, String string2, DBObjectId dBObjectId, int n, boolean bl, int n2, boolean bl2, boolean bl3) throws DataMoveException {
        if (n2 < 1) {
            throw new IllegalArgumentException("Commit interval must be at least 1");
        }
        if (n == 0) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.FINE, "DataMove.WONG_NUMBER_OF_THREADS");
            n = 1;
        }
        this.m_qualifyNames = bl2;
        this.setPersistenceManager(persistenceManager);
        this.setPersistenceUtility(PersistenceUtility.getInstance(persistenceManager));
        this.setSourceConnectionName(string);
        this.setTargetConnectionName(string2);
        this.setTargetConnectionId(dBObjectId);
        this.m_audience = new DataMoveAudience();
        this.m_getCounts = bl;
        this._truncTable = bl3;
        try {
            this.createDrones(n, n2, bl2);
        }
        catch (CMException cMException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, "DataMove.CLONE_CONNECTION_FAILED", cMException.getLocalizedMessage());
            throw new DataMoveException((Exception)((Object)cMException));
        }
    }

    public boolean isTruncateTable() {
        return this._truncTable;
    }

    public DataMoveWorker(PersistenceManager persistenceManager, String string, String string2, DBObjectId dBObjectId, int n, int n2, boolean bl, boolean bl2) throws DataMoveException {
        this(persistenceManager, string, string2, dBObjectId, n, true, n2, bl, bl2);
    }

    public void addListener(DataMoveListener dataMoveListener) {
        this.m_audience.addListener(dataMoveListener);
    }

    protected void createDrones(int n, int n2, boolean bl) throws CMException, DataMoveException {
        MigrationPlugin migrationPlugin = DataMoveUtils.findPluginUsed(this.m_targetConnectionId, this.m_persistenceManager);
        if (migrationPlugin == null) {
            throw new DataMoveException(new IllegalStateException(MigrationAddinArb.getString("DataMove_PLUGIN_NOT_FOUND")));
        }
        Connections connections = Connections.getInstance();
        Connection connection = null;
        try {
            connection = connections.getConnection(this.m_sourceConnectionName);
            this.m_targetMaster = connections.getConnection(this.m_targetConnectionName);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        this.m_constraintHandler = new ConstraintHandler(this.m_targetConnectionId, this.getPersistenceManager());
        this.m_triggerHandler = new TriggerHandler(this.m_targetConnectionId, this.getPersistenceManager());
        this.m_identityHandler = new IdentityHandler(this.m_targetConnectionId, this.getPersistenceManager());
        this.m_drones = new DataMoveDrone[n];
        Connection connection2 = null;
        Connection connection3 = null;
        for (int i = 0; i < n; ++i) {
            try {
                connection2 = connections.cloneConnection(connection);
                connection3 = connections.cloneConnection(this.m_targetMaster);
            }
            catch (ConnectionException connectionException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, connectionException.getStackTrace()[0].toString(), connectionException);
            }
            DataMoveDrone dataMoveDrone = migrationPlugin.getDataMoveDrone(MessageFormat.format(Messages.getString("DataMoveWorker.4"), i), this, connection2, connection3, migrationPlugin.getQuoter(), migrationPlugin.getStatementProviderForDataMove(), this.m_getCounts, n2, this.m_audience, bl);
            dataMoveDrone.setTruncTable(this._truncTable);
            this.m_drones[i] = dataMoveDrone;
        }
    }

    public void doWork() throws PersistenceException {
        boolean bl = false;
        try {
            this.m_constraintHandler.disableConstraints(this.m_targetMaster, this.m_qualifyNames);
        }
        catch (SQLException sQLException) {
            this.m_constraintHandler.reenableConstraints(this.m_targetMaster, this.m_qualifyNames);
            return;
        }
        this.m_triggerHandler.disableTriggers(this.m_targetMaster, this.m_qualifyNames);
        this.m_tables = this.getPersistenceUtility().getTablesForConnectionId(this.m_targetConnectionId);
        for (DataMoveDrone dataMoveDrone : this.m_drones) {
            Thread thread = new Thread((Runnable)dataMoveDrone, dataMoveDrone.getId());
            thread.start();
        }
        while (!bl) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_cancelled) break;
            bl = this.reportState(1);
        }
        this.reportState(2);
        this.m_drones = null;
        this.m_constraintHandler.reenableConstraints(this.m_targetMaster, this.m_qualifyNames);
        this.m_triggerHandler.enableTriggers(this.m_targetMaster, this.m_qualifyNames);
        this.m_identityHandler.enableIdentity(this.m_targetMaster, this.m_qualifyNames);
    }

    private boolean reportState(int n) {
        boolean bl = true;
        if (this.m_drones != null) {
            DroneState[] droneStateArray = new DroneState[this.m_drones.length];
            for (int i = 0; i < this.m_drones.length; ++i) {
                droneStateArray[i] = this.m_drones[i].getState();
                if (droneStateArray[i].getProcessState().equals(DataMoveDrone.STATE_FINISHED)) continue;
                bl = false;
            }
            DataMoveEvent dataMoveEvent = new DataMoveEvent(n, MY_ID, droneStateArray);
            this.m_audience.fireListeners(dataMoveEvent);
        }
        return bl;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    protected void setSourceConnectionName(String string) {
        this.m_sourceConnectionName = string;
    }

    protected void setTargetConnectionName(String string) {
        this.m_targetConnectionName = string;
    }

    protected void setTargetConnectionId(DBObjectId dBObjectId) {
        this.m_targetConnectionId = dBObjectId;
    }

    @Override
    public synchronized DataMoveDescriptor getDescriptor() {
        if (!this.m_tables.hasNext()) {
            return null;
        }
        MgvAllTablesRec mgvAllTablesRec = (MgvAllTablesRec)this.m_tables.next();
        try {
            DataMoveDescriptor dataMoveDescriptor = DataMoveUtils.loadDescriptor(this.m_persistenceManager, mgvAllTablesRec.getTableId(), this.m_targetConnectionId);
            return dataMoveDescriptor;
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, "DataMove.RETRIEVE_DESCRIPTOR_FAILED", persistenceException.getLocalizedMessage());
            return null;
        }
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected PersistenceUtility getPersistenceUtility() {
        return this.m_persistenceUtility;
    }

    protected void setPersistenceUtility(PersistenceUtility persistenceUtility) {
        this.m_persistenceUtility = persistenceUtility;
    }

    @Override
    public void signalCancel() {
        this.m_cancelled = true;
        if (this.m_drones != null) {
            for (DataMoveDrone dataMoveDrone : this.m_drones) {
                dataMoveDrone.signalCancel();
            }
        }
        DataMoveEvent dataMoveEvent = new DataMoveEvent(-1, MY_ID, null);
        this.m_audience.fireListeners(dataMoveEvent);
    }

    public DataMoveAudience getAudience() {
        return this.m_audience;
    }
}

