/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.online;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.DataMoveMarshal;
import oracle.dbtools.migration.datamove.DataMoveUtils;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveLogWrapper;
import oracle.dbtools.migration.datamove.online.DroneState;
import oracle.dbtools.migration.datamove.online.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.StatementProvider;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;

public class DataMoveDrone
implements Runnable,
Cancelable {
    protected static Logger s_log = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle", "oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    public static final int ROWCOUNT_UNKNOWN = -1;
    public static final String STATE_INITIALISING = Messages.getString("DataMoveDrone.0");
    public static final String STATE_DISABLING = Messages.getString("DataMoveDrone.1");
    public static final String STATE_BUILDING = Messages.getString("DataMoveDrone.2");
    public static final String STATE_MOVING = Messages.getString("DataMoveDrone.3");
    public static final String STATE_DONE = Messages.getString("DataMoveDrone.4");
    public static final String STATE_FINISHED = Messages.getString("DataMoveDrone.5");
    protected volatile DataMoveMarshal m_marshal;
    protected volatile boolean m_cancelled = false;
    protected volatile DroneStateVector m_stateVector;
    protected volatile Connection m_sourceConnection;
    protected volatile Connection m_targetConnection;
    protected volatile DataMoveDescriptor m_descriptor;
    protected volatile Quoter m_quoter;
    protected volatile boolean m_getCounts = false;
    protected volatile int m_commitInterval;
    protected volatile boolean _truncTable;
    protected volatile boolean m_pessimistic = false;
    protected volatile Vector<DataMoveLogWrapper> m_messages;
    protected ResourceBundle m_resourceBundle;
    protected volatile DataMoveAudience m_audience;
    protected volatile boolean m_qualifyNames;
    protected volatile StatementProvider m_statementProvider;

    public void setTruncTable(boolean bl) {
        this._truncTable = bl;
    }

    public DataMoveDrone(String string, DataMoveMarshal dataMoveMarshal, Connection connection, Connection connection2, Quoter quoter, StatementProvider statementProvider, boolean bl, int n, DataMoveAudience dataMoveAudience, boolean bl2) {
        this.m_marshal = dataMoveMarshal;
        this.m_stateVector = new DroneStateVector(string);
        this.setSourceConnection(connection);
        this.setTargetConnection(connection2);
        this.m_quoter = quoter;
        this.m_statementProvider = statementProvider;
        this.m_audience = dataMoveAudience;
        this.m_getCounts = bl;
        if (n < 1) {
            throw new IllegalArgumentException(Messages.getString("DataMoveDrone.6"));
        }
        this.m_commitInterval = n;
        this.m_resourceBundle = ResourceBundle.getBundle("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
        this.m_qualifyNames = bl2;
    }

    public DataMoveDrone(String string, DataMoveMarshal dataMoveMarshal, Connection connection, Connection connection2, Quoter quoter, StatementProvider statementProvider, int n, DataMoveAudience dataMoveAudience, boolean bl) {
        this(string, dataMoveMarshal, connection, connection2, quoter, statementProvider, true, n, dataMoveAudience, bl);
    }

    protected void createLogMessage(String string, Level level, String string2, MdTable mdTable, MdSchema mdSchema) {
        boolean bl = false;
        for (DataMoveLogWrapper dataMoveLogWrapper : this.m_messages) {
            if (!dataMoveLogWrapper.getMessage().equals(string2)) continue;
            bl = true;
            dataMoveLogWrapper.setCounter(dataMoveLogWrapper.getCounter() + 1);
            break;
        }
        if (!bl) {
            DataMoveLogWrapper dataMoveLogWrapper = new DataMoveLogWrapper();
            dataMoveLogWrapper.setTable(mdTable);
            dataMoveLogWrapper.setSchema(mdSchema);
            dataMoveLogWrapper.setLevel(level);
            dataMoveLogWrapper.setMessage(string2);
            this.m_messages.add(dataMoveLogWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        MdTable mdTable;
        String string;
        String string2;
        try {
            this.m_descriptor = this.m_marshal.getDescriptor();
            while (this.m_descriptor != null) {
                this.doDataMove();
                ++this.m_stateVector.m_totalTablesMoved;
                if (!this.m_cancelled) {
                    this.m_descriptor = this.m_marshal.getDescriptor();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            MdTable mdTable2;
            String string3;
            String string4;
            try {
                if (this.getSourceConnection() != null) {
                    this.getSourceConnection().close();
                }
            }
            catch (SQLException sQLException) {
                string4 = this.m_descriptor.getSourceTableName();
                string3 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.CLOSE_SOURCE_FAILED"), sQLException.getLocalizedMessage());
                mdTable2 = this.m_descriptor.getTargetTable();
                if (mdTable2 == null) {
                    mdTable2 = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(string4, Level.WARNING, string3, mdTable2, this.m_descriptor.getSourceSchema());
            }
            this.m_sourceConnection = null;
            try {
                if (this.getTargetConnection() != null) {
                    this.getTargetConnection().close();
                }
            }
            catch (SQLException sQLException) {
                string4 = this.m_stateVector.getCurrentTable();
                string3 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.CLOSE_TARGET_FAILED"), sQLException.getLocalizedMessage());
                mdTable2 = this.m_descriptor.getTargetTable();
                if (mdTable2 == null) {
                    mdTable2 = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(string4, Level.WARNING, string3, mdTable2, this.m_descriptor.getSourceSchema());
            }
            this.m_targetConnection = null;
            this.m_stateVector.setCurrentProcessState(STATE_FINISHED);
            throw throwable;
        }
        try {
            if (this.getSourceConnection() != null) {
                this.getSourceConnection().close();
            }
        }
        catch (SQLException sQLException) {
            string2 = this.m_descriptor.getSourceTableName();
            string = MessageFormat.format(this.m_resourceBundle.getString("DataMove.CLOSE_SOURCE_FAILED"), sQLException.getLocalizedMessage());
            mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string2, Level.WARNING, string, mdTable, this.m_descriptor.getSourceSchema());
        }
        this.m_sourceConnection = null;
        try {
            if (this.getTargetConnection() != null) {
                this.getTargetConnection().close();
            }
        }
        catch (SQLException sQLException) {
            string2 = this.m_stateVector.getCurrentTable();
            string = MessageFormat.format(this.m_resourceBundle.getString("DataMove.CLOSE_TARGET_FAILED"), sQLException.getLocalizedMessage());
            mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string2, Level.WARNING, string, mdTable, this.m_descriptor.getSourceSchema());
        }
        this.m_targetConnection = null;
        this.m_stateVector.setCurrentProcessState(STATE_FINISHED);
    }

    protected void logMessages() {
        LogInfo logInfo = new LogInfo(Messages.getString("DataMoveDrone.9"));
        if (this.m_messages.size() == 0) {
            return;
        }
        if (this.m_messages.size() > 1) {
            for (DataMoveLogWrapper dataMoveLogWrapper : this.m_messages) {
                LogRecord logRecord = this.createLogRecord(dataMoveLogWrapper, dataMoveLogWrapper.getMessage(), true);
                if (dataMoveLogWrapper.getCounter() > 1) {
                    String string = MessageFormat.format(this.m_resourceBundle.getString("DataMove.MULTIPLE_OCCURANCES_OF_MESSAGE"), dataMoveLogWrapper.getCounter());
                    LogRecord logRecord2 = this.createLogRecord(dataMoveLogWrapper, string, false);
                    logRecord.setParameters(new Object[]{logRecord2});
                }
                logInfo.addChild(logRecord);
            }
            LogRecord logRecord = new LogRecord(Level.WARNING, this.m_descriptor.getSourceTableName());
            logRecord.setLoggerName(s_log.getName());
            logRecord.setParameters(new Object[]{logInfo});
            s_log.log(logRecord);
        } else {
            DataMoveLogWrapper dataMoveLogWrapper = this.m_messages.get(0);
            String string = dataMoveLogWrapper.getSchema().getName() + "." + dataMoveLogWrapper.getTable().getTableName() + ": " + dataMoveLogWrapper.getMessage();
            LogRecord logRecord = this.createLogRecord(dataMoveLogWrapper, string, true);
            s_log.log(logRecord);
        }
    }

    protected LogRecord createLogRecord(DataMoveLogWrapper dataMoveLogWrapper, String string, boolean bl) {
        LogRecord logRecord = new LogRecord(dataMoveLogWrapper.getLevel(), string);
        logRecord.setLoggerName(s_log.getName());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
        logRecord.setResourceBundle(resourceBundle);
        if (bl) {
            ClickableLogInfo clickableLogInfo = new ClickableLogInfo(dataMoveLogWrapper.getTable(), Messages.getString("DataMoveDrone.13"));
            logRecord.setParameters(new Object[]{clickableLogInfo});
        }
        return logRecord;
    }

    @Override
    public void signalCancel() {
        this.m_cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDataMove() {
        Hashtable<String, Integer> hashtable = null;
        this.m_messages = new Vector();
        this.m_stateVector.newTable(this.m_descriptor.getSourceTableName());
        try {
            hashtable = DataMoveUtils.getColumnTypes(this.m_descriptor.getTargetTableName(this.m_qualifyNames), this.m_targetConnection);
        }
        catch (SQLException sQLException) {
            String string = this.m_descriptor.getTargetTableName(this.m_qualifyNames);
            String string2 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.FAILED_TO_FIND_TARGET"), string);
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.SEVERE, string2, mdTable, this.m_descriptor.getSourceSchema());
            this.incrementErrorCount();
            return;
        }
        ResultSet resultSet = null;
        String[] stringArray = this.m_descriptor.getTargetColumnNames();
        this.m_stateVector.setCurrentProcessState(STATE_BUILDING);
        if (this.m_getCounts) {
            this.m_stateVector.setTableRowCount(this.getSourceRowCount());
        }
        String string = this.createSelectQuery();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        try {
            preparedStatement = this.createInsertPreparedStatement(stringArray);
            statement = this.m_statementProvider.getStatementForDataMove(this.m_sourceConnection);
            if (this._truncTable) {
                this.truncateTargetTable();
            }
            resultSet = statement.executeQuery(string);
            this.moveRows(resultSet, preparedStatement, stringArray, hashtable);
            this.commitInserts();
            this.m_stateVector.setCurrentProcessState(STATE_DONE);
            String string3 = this.m_descriptor.getSourceTableName();
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string3, Level.INFO, this.m_stateVector.toLogString(), mdTable, this.m_descriptor.getSourceSchema());
            DataMoveEvent dataMoveEvent = new DataMoveEvent(3, this.m_descriptor.getSourceTable().getTableName(), this);
            this.m_audience.fireListeners(dataMoveEvent);
        }
        catch (SQLException sQLException) {
            String string4 = this.m_descriptor.getSourceTableName();
            String string5 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.MOVE_FAILED"), sQLException.getLocalizedMessage());
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string4, Level.SEVERE, string5, mdTable, this.m_descriptor.getSourceSchema());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            this.logMessages();
        }
    }

    protected void commitInserts() {
        try {
            this.m_targetConnection.commit();
        }
        catch (SQLException sQLException) {
            String string = this.m_descriptor.getSourceTableName();
            String string2 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.COMMIT_FAILED"), sQLException.getLocalizedMessage());
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.SEVERE, string2, mdTable, this.m_descriptor.getSourceSchema());
            this.incrementErrorCount();
        }
    }

    protected void moveRows(ResultSet resultSet, PreparedStatement preparedStatement, String[] stringArray, Hashtable<String, Integer> hashtable) {
        Object object;
        int n;
        MdColumn[] mdColumnArray = this.m_descriptor.getTargetColumns();
        ArrayList<CLOB> arrayList = null;
        ArrayList<BLOB> arrayList2 = null;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        this.m_stateVector.setCurrentProcessState(STATE_MOVING);
        try {
            for (n = 0; n < mdColumnArray.length; ++n) {
                if (!mdColumnArray[n].getColumnType().toLowerCase().equals("nvarchar2") && !mdColumnArray[n].getColumnType().toLowerCase().equals("nchar") && !mdColumnArray[n].getColumnType().toLowerCase().equals("nclob")) continue;
                object = (OraclePreparedStatement)preparedStatement;
                object.setFormOfUse(n + 1, (short)2);
            }
            bl = resultSet.next();
            ++n2;
        }
        catch (SQLException sQLException) {
            String string3 = this.m_descriptor.getSourceTableName();
            String string4 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.RETRIEVE_FAILED"), this.m_descriptor.getSourceTableName());
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string3, Level.SEVERE, string4, mdTable, this.m_descriptor.getSourceSchema());
            this.incrementErrorCount();
            return;
        }
        while (bl) {
            Object object2;
            Object object3;
            block24: {
                if (this.m_cancelled) {
                    return;
                }
                try {
                    arrayList2 = new ArrayList<BLOB>();
                    arrayList = new ArrayList<CLOB>();
                    for (n = 0; n < stringArray.length; ++n) {
                        string = stringArray[n];
                        String string5 = this.m_descriptor.getOriginalColumnName(string);
                        Object object4 = this.m_statementProvider.getColumnValue(resultSet, string5);
                        if (resultSet.wasNull()) {
                            this.handleNullValue(hashtable, string5, string, preparedStatement, n + 1, arrayList2, arrayList);
                            continue;
                        }
                        object = this.checkEmptyObject(object4);
                        if (object != null) {
                            preparedStatement.setObject(n + 1, object);
                            if (bl2) continue;
                            object3 = this.m_descriptor.getTargetTableName(this.m_qualifyNames);
                            object2 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.REPLACED_EMPTY_WARNING"), (String)object3 + "." + string, n2);
                            MdTable mdTable = this.m_descriptor.getTargetTable();
                            if (mdTable == null) {
                                mdTable = this.m_descriptor.getSourceTable();
                            }
                            this.createLogMessage((String)object3, Level.WARNING, (String)object2, mdTable, this.m_descriptor.getSourceSchema());
                            bl2 = true;
                            continue;
                        }
                        if (object4 instanceof BigInteger) {
                            object3 = new NUMBER((BigInteger)object4);
                            ((OraclePreparedStatement)preparedStatement).setNUMBER(n + 1, (NUMBER)object3);
                            continue;
                        }
                        if (object4 instanceof Blob) {
                            object3 = this.handleBlob(preparedStatement, n + 1, (Blob)object4);
                            if (object3 == null) continue;
                            arrayList2.add((BLOB)object3);
                            continue;
                        }
                        if (object4 instanceof Clob && mdColumnArray[n].getColumnType().toLowerCase().equals("nclob")) {
                            object3 = this.handleNClob(preparedStatement, n + 1, (Clob)object4);
                            if (object3 == null) continue;
                            arrayList.add((CLOB)object3);
                            continue;
                        }
                        if (object4 instanceof Clob) {
                            object3 = this.handleClob(preparedStatement, n + 1, (Clob)object4);
                            if (object3 == null) continue;
                            arrayList.add((CLOB)object3);
                            continue;
                        }
                        preparedStatement.setObject(n + 1, object4);
                    }
                    int n3 = preparedStatement.executeUpdate();
                    this.releaseLobs(arrayList2, arrayList);
                    arrayList2 = null;
                    arrayList = null;
                    if (n3 != 1) {
                        String string6 = this.m_descriptor.getTargetTableName(this.m_qualifyNames);
                        object = MessageFormat.format(this.m_resourceBundle.getString("DataMove.INSERT_ERROR"), this.m_descriptor.getSourceDatabaseName());
                        object3 = this.m_descriptor.getTargetTable();
                        if (object3 == null) {
                            object3 = this.m_descriptor.getSourceTable();
                        }
                        this.createLogMessage(string6, Level.SEVERE, (String)object, (MdTable)object3, this.m_descriptor.getSourceSchema());
                        this.incrementErrorCount();
                    } else {
                        ++this.m_stateVector.m_rowsMoved;
                        if (this.m_stateVector.m_rowsMoved % (long)this.m_commitInterval == 0L) {
                            this.commitInserts();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    this.releaseLobs(arrayList2, arrayList);
                    arrayList2 = null;
                    arrayList = null;
                    this.incrementErrorCount();
                    string2 = this.m_descriptor.getSourceTableName() + " " + sQLException.getLocalizedMessage();
                    object = this.m_descriptor.getSourceTableName();
                    object3 = this.m_descriptor.getTargetTable();
                    if (object3 == null) {
                        object3 = this.m_descriptor.getSourceTable();
                    }
                    this.createLogMessage((String)object, Level.SEVERE, string2, (MdTable)object3, this.m_descriptor.getSourceSchema());
                    if (!this.m_pessimistic) break block24;
                    return;
                }
            }
            try {
                bl = resultSet.next();
                ++n2;
            }
            catch (SQLException sQLException) {
                object = this.m_descriptor.getSourceTableName();
                object3 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.RETRIEVE_FAILED"), this.m_descriptor.getSourceTableName());
                object2 = this.m_descriptor.getTargetTable();
                if (object2 == null) {
                    object2 = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage((String)object, Level.SEVERE, (String)object3, (MdTable)object2, this.m_descriptor.getSourceSchema());
                this.incrementErrorCount();
                return;
            }
        }
    }

    protected void handleNullValue(Hashtable<String, Integer> hashtable, String string, String string2, PreparedStatement preparedStatement, int n, ArrayList<BLOB> arrayList, ArrayList<CLOB> arrayList2) throws SQLException {
        MdTable mdTable;
        String string3;
        String string4;
        Integer n2 = hashtable.get(string2.toUpperCase());
        MdColumn mdColumn = this.m_descriptor.getSourceColumnByName(string);
        if (mdColumn == null) {
            string4 = this.m_descriptor.getSourceTableName();
            string3 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.FAILEDTOFINDMDCOL"), string);
            mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string4, Level.FINE, string3, mdTable, this.m_descriptor.getSourceSchema());
        } else if (!PersistenceUtility.isColumnNullable(mdColumn)) {
            Object object = this.getDummyValueForType(n2);
            if (object instanceof CLOB) {
                arrayList2.add((CLOB)object);
            } else if (object instanceof BLOB) {
                arrayList.add((BLOB)object);
            }
            if (object != null) {
                String string5 = this.m_descriptor.getSourceTableName();
                String string6 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.DEFAULTINGNULLVALUE"), string, object.toString());
                MdTable mdTable2 = this.m_descriptor.getTargetTable();
                if (mdTable2 == null) {
                    mdTable2 = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(string5, Level.WARNING, string6, mdTable2, this.m_descriptor.getSourceSchema());
                preparedStatement.setObject(n, object);
            } else {
                String string7 = this.m_descriptor.getSourceTableName();
                String string8 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.DEFAULTINGNULLVALUE"), string, Messages.getString("DataMoveDrone.30"));
                MdTable mdTable3 = this.m_descriptor.getTargetTable();
                if (mdTable3 == null) {
                    mdTable3 = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(string7, Level.WARNING, string8, mdTable3, this.m_descriptor.getSourceSchema());
                preparedStatement.setNull(n, n2);
            }
            return;
        }
        if (n2 == null) {
            string4 = this.m_descriptor.getSourceTableName();
            string3 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.FIND_TYPE_FAILED"), string2);
            mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string4, Level.FINE, string3, mdTable, this.m_descriptor.getSourceSchema());
            preparedStatement.setNull(n, 12);
        } else {
            preparedStatement.setNull(n, n2);
        }
    }

    protected Object getDummyValueForType(int n) {
        switch (n) {
            case 2003: {
                return null;
            }
            case -5: {
                return BigInteger.ZERO;
            }
            case -2: {
                return this.createDummyBlob();
            }
            case -7: {
                return 0;
            }
            case 2004: {
                return this.createDummyBlob();
            }
            case 16: {
                return 0;
            }
            case 1: {
                return new Character(' ');
            }
            case 2005: {
                return this.createDummyClob();
            }
            case 70: {
                return null;
            }
            case 91: {
                return new Date(0L);
            }
            case 3: {
                return BigDecimal.ZERO;
            }
            case 2001: {
                return null;
            }
            case 8: {
                return 0.0;
            }
            case 6: {
                return Float.valueOf(0.0f);
            }
            case 4: {
                return 0;
            }
            case 2000: {
                return null;
            }
            case -4: {
                return this.createDummyBlob();
            }
            case -1: {
                return this.createDummyClob();
            }
            case 0: {
                return null;
            }
            case 2: {
                return 0;
            }
            case 1111: {
                return null;
            }
            case 7: {
                return Float.valueOf(0.0f);
            }
            case 2006: {
                return null;
            }
            case 5: {
                return 0;
            }
            case 2002: {
                return null;
            }
            case 92: {
                return new Time(0L);
            }
            case 93: {
                return new Timestamp(0L);
            }
            case -6: {
                return 0;
            }
            case -3: {
                return this.createDummyBlob();
            }
            case 12: {
                return new String(" ");
            }
        }
        return null;
    }

    protected void releaseLobs(ArrayList<BLOB> arrayList, ArrayList<CLOB> arrayList2) {
        MdTable mdTable;
        String string;
        BLOB bLOB;
        while (arrayList.size() != 0) {
            bLOB = arrayList.remove(0);
            try {
                bLOB.freeTemporary();
            }
            catch (SQLException sQLException) {
                string = this.m_descriptor.getSourceTableName();
                mdTable = this.m_descriptor.getTargetTable();
                if (mdTable == null) {
                    mdTable = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(string, Level.WARNING, sQLException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
            }
        }
        while (arrayList2.size() != 0) {
            bLOB = arrayList2.remove(0);
            try {
                bLOB.freeTemporary();
            }
            catch (SQLException sQLException) {
                string = this.m_descriptor.getSourceTableName();
                mdTable = this.m_descriptor.getTargetTable();
                if (mdTable == null) {
                    mdTable = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(string, Level.WARNING, sQLException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
            }
        }
    }

    protected CLOB handleNClob(PreparedStatement preparedStatement, int n, Clob clob) {
        try {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_targetConnection, (boolean)true, (int)10, (short)2);
            cLOB.open(1);
            Reader reader = clob.getCharacterStream();
            Writer writer = cLOB.setCharacterStream(1L);
            int n2 = cLOB.getChunkSize();
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n3 = reader.read(cArray, 0, n2)) != -1) {
                writer.write(cArray, 0, n3);
            }
            reader.close();
            writer.flush();
            writer.close();
            preparedStatement.setClob(n, (Clob)cLOB);
            return cLOB;
        }
        catch (SQLException sQLException) {
            String string = this.m_descriptor.getSourceTableName();
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.FINE, sQLException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
        }
        catch (IOException iOException) {
            String string = this.m_descriptor.getSourceTableName();
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.FINE, iOException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
        }
        return null;
    }

    protected CLOB handleClob(PreparedStatement preparedStatement, int n, Clob clob) {
        try {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_targetConnection, (boolean)true, (int)10);
            cLOB.open(1);
            Reader reader = clob.getCharacterStream();
            Writer writer = cLOB.setCharacterStream(1L);
            int n2 = cLOB.getChunkSize();
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n3 = reader.read(cArray, 0, n2)) != -1) {
                writer.write(cArray, 0, n3);
            }
            reader.close();
            writer.flush();
            writer.close();
            cLOB.close();
            preparedStatement.setClob(n, (Clob)cLOB);
            return cLOB;
        }
        catch (SQLException sQLException) {
            String string = this.m_descriptor.getSourceTableName();
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.FINE, sQLException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
        }
        catch (IOException iOException) {
            String string = this.m_descriptor.getSourceTableName();
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.FINE, iOException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
        }
        return null;
    }

    protected BLOB handleBlob(PreparedStatement preparedStatement, int n, Blob blob) {
        try {
            BLOB bLOB = BLOB.createTemporary((Connection)this.m_targetConnection, (boolean)true, (int)10);
            bLOB.open(1);
            InputStream inputStream = blob.getBinaryStream();
            OutputStream outputStream = bLOB.setBinaryStream(1L);
            int n2 = bLOB.getChunkSize();
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while ((n3 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n3);
            }
            inputStream.close();
            outputStream.flush();
            outputStream.close();
            preparedStatement.setBlob(n, (Blob)bLOB);
            return bLOB;
        }
        catch (SQLException sQLException) {
            String string = this.m_descriptor.getSourceTableName();
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.FINE, sQLException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
        }
        catch (IOException iOException) {
            String string = this.m_descriptor.getSourceTableName();
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.FINE, iOException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
        }
        return null;
    }

    protected Object checkEmptyObject(Object object) {
        MdTable mdTable;
        String string;
        Object object2;
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.length() == 0 && MigrationAddin.getMigrationConfig().getEmptyStringIsSpace()) {
                return " ";
            }
            return null;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 0) {
                byte[] byArray2 = new byte[]{32};
                return byArray2;
            }
            return null;
        }
        if (object instanceof Blob) {
            object2 = (Blob)object;
            try {
                if (object2.length() == 0L) {
                    return this.createDummyBlob();
                }
            }
            catch (SQLException sQLException) {
                string = this.m_descriptor.getSourceTableName();
                mdTable = this.m_descriptor.getTargetTable();
                if (mdTable == null) {
                    mdTable = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(string, Level.FINE, sQLException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
            }
        }
        if (object instanceof Clob) {
            object2 = (Clob)object;
            try {
                if (object2.length() == 0L) {
                    return this.createDummyClob();
                }
            }
            catch (SQLException sQLException) {
                string = this.m_descriptor.getSourceTableName();
                mdTable = this.m_descriptor.getTargetTable();
                if (mdTable == null) {
                    mdTable = this.m_descriptor.getSourceTable();
                }
                this.createLogMessage(string, Level.FINE, sQLException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
            }
        }
        return null;
    }

    protected BLOB createDummyBlob() {
        try {
            BLOB bLOB = BLOB.getEmptyBLOB();
            return bLOB;
        }
        catch (SQLException sQLException) {
            String string = this.m_descriptor.getSourceTableName();
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.FINE, sQLException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
            return null;
        }
    }

    protected CLOB createDummyClob() {
        try {
            return CLOB.getEmptyCLOB();
        }
        catch (SQLException sQLException) {
            String string = this.m_descriptor.getSourceTableName();
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.WARNING, sQLException.getLocalizedMessage(), mdTable, this.m_descriptor.getSourceSchema());
            return null;
        }
    }

    protected PreparedStatement createInsertPreparedStatement(String[] stringArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.m_descriptor.getTargetTableName(this.m_qualifyNames));
        stringBuffer.append('(');
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer2.append('?');
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(", ");
            stringBuffer2.append(", ");
        }
        stringBuffer.append(") VALUES (");
        stringBuffer.append(stringBuffer2);
        stringBuffer.append(')');
        PreparedStatement preparedStatement = this.m_targetConnection.prepareStatement(stringBuffer.toString());
        return preparedStatement;
    }

    protected void truncateTargetTable() {
        String string = "TRUNCATE TABLE " + this.m_descriptor.getTargetTableName(this.m_qualifyNames);
        try {
            Statement statement = this.m_targetConnection.createStatement();
            statement.execute(string);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    protected String createSelectQuery() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        String[] stringArray = this.m_descriptor.getSourceColumnNames();
        MdColumn[] mdColumnArray = this.m_descriptor.getSourceColumns();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(this.m_statementProvider.getColumnSelectPattern(this.m_quoter.quoteIdentifier(mdColumnArray[i].getColumnName()), mdColumnArray[i]));
            if (i == stringArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.quote(this.m_descriptor.getSourceTableName()));
        return stringBuffer.toString();
    }

    protected String quote(String string) {
        String string2 = string;
        if (string != null) {
            String[] stringArray = string.split("\\.");
            String string3 = "";
            string2 = "";
            for (String string4 : stringArray) {
                string2 = string2 + string3 + this.m_quoter.quoteIdentifier(string4);
                string3 = ".";
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getSourceRowCount() {
        long l = -1L;
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT COUNT(*) FROM ");
        stringBuffer.append(this.quote(this.m_descriptor.getSourceTableName()));
        try {
            Statement statement = this.m_sourceConnection.createStatement();
            ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
            closeableResultSet = new CloseableResultSet(statement, resultSet);
            resultSet.next();
            l = resultSet.getLong(1);
        }
        catch (SQLException sQLException) {
            String string = this.m_descriptor.getSourceTableName();
            String string2 = MessageFormat.format(this.m_resourceBundle.getString("DataMove.FAILED_TO_OBTAIN_COUNT"), sQLException.getMessage());
            MdTable mdTable = this.m_descriptor.getTargetTable();
            if (mdTable == null) {
                mdTable = this.m_descriptor.getSourceTable();
            }
            this.createLogMessage(string, Level.WARNING, string2, mdTable, this.m_descriptor.getSourceSchema());
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
        return l;
    }

    protected void incrementErrorCount() {
        this.m_stateVector.incrementErrorCount();
    }

    public String getId() {
        return this.m_stateVector.getId();
    }

    public DroneState getState() {
        return this.m_stateVector.takeSnapshot();
    }

    protected Connection getSourceConnection() {
        return this.m_sourceConnection;
    }

    protected void setSourceConnection(Connection connection) {
        this.m_sourceConnection = connection;
    }

    protected Connection getTargetConnection() {
        return this.m_targetConnection;
    }

    protected void setTargetConnection(Connection connection) {
        this.m_targetConnection = connection;
    }

    protected static class DroneStateVector
    implements DroneState {
        protected String m_currentProcessState;
        protected String m_id;
        protected int m_totalTablesMoved;
        protected String m_currentTable;
        protected long m_tableRowCount;
        protected long m_rowsMoved;
        protected int m_thisErrorCount;
        protected int m_totalErrorCount;

        public DroneStateVector(String string) {
            this.setCurrentProcessState(STATE_INITIALISING);
            this.setId(string);
            this.setCurrentTable(null);
            this.setRowsMoved(0L);
            this.setTableRowCount(0L);
            this.setThisErrorCount(0);
            this.setTotalErrorCount(0);
            this.setTotalTablesMoved(0);
        }

        @Override
        public String getCurrentTable() {
            return this.m_currentTable;
        }

        @Override
        public String getId() {
            return this.m_id;
        }

        @Override
        public long getRowsMoved() {
            return this.m_rowsMoved;
        }

        @Override
        public long getTableRowCount() {
            return this.m_tableRowCount;
        }

        @Override
        public int getThisErrorCount() {
            return this.m_thisErrorCount;
        }

        @Override
        public int getTotalErrorCount() {
            return this.m_totalErrorCount;
        }

        @Override
        public int getTotalTablesMoved() {
            return this.m_totalTablesMoved;
        }

        @Override
        public String getProcessState() {
            return this.m_currentProcessState;
        }

        public DroneState takeSnapshot() {
            DroneStateVector droneStateVector = new DroneStateVector(this.getId());
            droneStateVector.setCurrentProcessState(this.getProcessState());
            droneStateVector.setCurrentTable(this.getCurrentTable());
            droneStateVector.setRowsMoved(this.getRowsMoved());
            droneStateVector.setTableRowCount(this.getTableRowCount());
            droneStateVector.setThisErrorCount(this.getThisErrorCount());
            droneStateVector.setTotalErrorCount(this.getTotalErrorCount());
            droneStateVector.setTotalTablesMoved(this.getTotalTablesMoved());
            return droneStateVector;
        }

        void setCurrentProcessState(String string) {
            this.m_currentProcessState = string;
        }

        void setCurrentTable(String string) {
            this.m_currentTable = string;
        }

        void setId(String string) {
            this.m_id = string;
        }

        void setRowsMoved(long l) {
            this.m_rowsMoved = l;
        }

        void setTableRowCount(long l) {
            this.m_tableRowCount = l;
        }

        void setThisErrorCount(int n) {
            this.m_thisErrorCount = n;
        }

        void setTotalErrorCount(int n) {
            this.m_totalErrorCount = n;
        }

        void setTotalTablesMoved(int n) {
            this.m_totalTablesMoved = n;
        }

        void incrementErrorCount() {
            ++this.m_thisErrorCount;
            ++this.m_totalErrorCount;
        }

        void newTable(String string) {
            this.setCurrentProcessState(STATE_INITIALISING);
            this.setCurrentTable(string);
            this.setRowsMoved(0L);
            this.setTableRowCount(-1L);
            this.setThisErrorCount(0);
        }

        public String toLogString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Data Move information:");
            stringBuffer.append(Messages.getString("DataMoveDrone.44"));
            stringBuffer.append(this.m_rowsMoved);
            stringBuffer.append(Messages.getString("DataMoveDrone.45"));
            stringBuffer.append(this.m_thisErrorCount);
            return stringBuffer.toString();
        }
    }
}

