/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.datamove.offline.OfflineDatamovePrintStream;
import oracle.ide.Ide;

public class OfflineSQLLoaderPrintStream
extends OfflineDatamovePrintStream {
    protected ArrayList<String> m_createdFiles = new ArrayList();
    private PrintWriter m_printer;

    public OfflineSQLLoaderPrintStream(String string, String string2, String string3) {
        super(string, string2, string3);
        this.setLoaderDir(this.writeDir);
    }

    private void setLoaderDir(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        String string2 = string;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdir();
        }
        this.writeDir = string2;
    }

    @Override
    public void endDatabase() {
        try {
            String string = Ide.getEnvironOptions().getEncoding();
            this.m_printer = string == null ? new PrintWriter(this.writeDir + File.separator + "oracle_ctl.sh") : new PrintWriter(this.writeDir + File.separator + "oracle_ctl.sh", string);
            this.m_printer.println("#!/bin/bash\n");
            if ("MSAccess".equals(this.pluginName)) {
                this.m_printer.println("mkdir log");
                this.m_printer.println("mkdir data");
                this.m_printer.println("read -p \"Copy the export dump in data directory and hit any key to continue\"");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    public void winPrintstream() {
        this.finished();
        try {
            String string = Ide.getEnvironOptions().getEncoding();
            this.m_printer = string == null ? new PrintWriter(this.writeDir + File.separator + "oracle_ctl.bat") : new PrintWriter(this.writeDir + File.separator + "oracle_ctl.bat", string);
            if ("MSAccess".equals(this.pluginName)) {
                this.m_printer.println("mkdir log");
                this.m_printer.println("mkdir data");
                this.m_printer.println("pause \"Copy the export dump in data directory and hit any key to continue\"");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    @Override
    public void startDatabase(String string, String string2) {
        try {
            String string3 = Ide.getEnvironOptions().getEncoding();
            this.m_printer = string3 == null ? new PrintWriter(this.writeDir + File.separator + "pre_load.sql") : new PrintWriter(this.writeDir + File.separator + "pre_load.sql", string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    public void openEnableSQLFile() {
        try {
            String string = Ide.getEnvironOptions().getEncoding();
            this.m_printer = string == null ? new PrintWriter(this.writeDir + File.separator + "post_load.sql") : new PrintWriter(this.writeDir + File.separator + "post_load.sql", string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    @Override
    public void println(String string) {
        this.m_printer.println(string);
    }

    @Override
    public final void endTable() {
        this.m_printer.flush();
        this.m_printer.close();
    }

    @Override
    public final void startTable(String string) {
        this.m_createdFiles.add(string);
        try {
            String string2 = Ide.getEnvironOptions().getEncoding();
            PrintWriter printWriter = null;
            printWriter = string2 == null ? new PrintWriter(this.writeDir + File.separator + "control" + File.separator + string + ".ctl") : new PrintWriter(this.writeDir + File.separator + "control" + File.separator + string + ".ctl", string2);
            this.m_printer = printWriter;
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    @Override
    public void finished() {
        this.m_printer.flush();
        this.m_printer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildCallerScript() {
        String string = this.writeDir;
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        File file = new File(string);
        File[] fileArray = null;
        try {
            if (file.isDirectory()) {
                fileArray = file.listFiles();
            }
            printWriter = new PrintWriter(string + File.separator + "oracle_ctl.bat");
            printWriter2 = new PrintWriter(string + File.separator + "oracle_ctl.sh");
            printWriter2.println("#!/bin/bash\n");
            this.checkScriptArgs(printWriter, true, 1);
            this.checkScriptArgs(printWriter2, false, 1);
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                printWriter.println("pushd " + fileArray[i].getName() + " & call oracle_ctl.bat %1 %2 & popd");
                printWriter2.println("pushd " + fileArray[i].getName() + " && sh oracle_ctl.sh $1 $2 && popd");
            }
            this.argErrorSection(printWriter, true);
            this.argErrorSection(printWriter2, false);
        }
        catch (Exception exception) {
        }
        finally {
            printWriter.flush();
            printWriter.close();
            printWriter2.flush();
            printWriter2.close();
        }
    }

    private void checkScriptArgs(PrintWriter printWriter, boolean bl, int n) {
        if (bl) {
            for (int i = 0; i < n; ++i) {
                printWriter.println("IF \"%" + (i + 1) + "\"==\"\" goto INPUT_ERROR");
            }
        } else {
            printWriter.println("if [[ $# -lt " + n + " ]]; then");
            printWriter.println("   echo \"Usage: sh oracle_ctl.sh <user> <password@dbname>\"");
            printWriter.println("   exit 1;");
            printWriter.println("fi");
        }
    }

    private void argErrorSection(PrintWriter printWriter, boolean bl) {
        if (bl) {
            printWriter.println("goto EXIT");
            printWriter.println(":INPUT_ERROR");
            printWriter.println("   echo Usage: oracle_ctl [user] [password@dbname]");
            printWriter.println(":EXIT");
        }
    }
}

