/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.datamove.offline.Messages;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveWorker;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractCommonMigrationProgressRunnable;

public class OfflineDataMoveRunner
extends AbstractCommonMigrationProgressRunnable
implements DataMoveListener {
    private OfflineDataMoveWorker m_offlineDataMoveWorker;
    private static String[] s_header = new String[]{"Object", "Type", "Count"};
    private int count = 0;
    private int sqlcount = 0;
    private int scriptcount = 0;

    public OfflineDataMoveRunner(OfflineDataMoveWorker offlineDataMoveWorker) {
        this.m_offlineDataMoveWorker = offlineDataMoveWorker;
        this.m_offlineDataMoveWorker.addListener(this);
        this.setTitle(MigrationAddinArb.getString("DATAMOVERUNNER_TITLE"));
        this.setMessage(MigrationAddinArb.getString("DATAMOVERUNNER_INITIAL_MESSAGE"));
        this._jTableModel.setColumnIdentifiers(s_header);
        this.setupTable();
    }

    private void setupTable() {
        Object[] objectArray = new Object[]{"", 1, "0"};
        Object[] objectArray2 = new Object[]{"", 2, "0"};
        Object[] objectArray3 = new Object[]{"", 3, "0"};
        this._jTableModel.addRow(objectArray);
        this._jTableModel.addRow(objectArray2);
        this._jTableModel.addRow(objectArray3);
        this._jTableModel.fireTableDataChanged();
    }

    @Override
    public String[] getColumnNames() {
        return s_header;
    }

    @Override
    public String getEventString(Object object) {
        DataMoveEvent dataMoveEvent = (DataMoveEvent)object;
        if (dataMoveEvent == null) {
            return null;
        }
        return MessageFormat.format(Messages.getString("OfflineDataMoveRunner.9"), dataMoveEvent.getSource());
    }

    @Override
    public void setTableCellRenderer() {
    }

    @Override
    protected Object doWork() throws Exception {
        try {
            this.m_offlineDataMoveWorker.doWork();
            return Boolean.TRUE;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return Boolean.FALSE;
        }
    }

    @Override
    public void raiseEvent(DataMoveEvent dataMoveEvent) {
        String string = (String)dataMoveEvent.getSupplementaryData();
        switch (dataMoveEvent.getEventId()) {
            case 1: {
                this.createOrUpdateRow(dataMoveEvent.getSource().toString(), Messages.getString("OfflineDataMoveRunner.10"), this.count++, string);
                break;
            }
            case 2: {
                this.createOrUpdateRow(dataMoveEvent.getSource().toString(), Messages.getString("OfflineDataMoveRunner.11"), this.sqlcount++, string);
                break;
            }
            case 3: {
                this.createOrUpdateRow(dataMoveEvent.getSource().toString(), Messages.getString("OfflineDataMoveRunner.12"), this.scriptcount++, string);
                break;
            }
        }
        this._jTableModel.fireTableDataChanged();
        this.updateProgress(1, null, Messages.getString("OfflineDataMoveRunner.13") + this.count);
    }

    private void createOrUpdateRow(String string, String string2, int n, String string3) {
        boolean bl = false;
        Object[] objectArray = new Object[]{string, string2, string3};
        for (int i = 0; i < this._jTableModel.getRowCount(); ++i) {
            if (this._jTableModel.getValueAt(i, 2) == null || !this._jTableModel.getValueAt(i, 2).toString().equals(string2)) continue;
            this._jTableModel.removeRow(i);
            bl = true;
        }
        if (!bl) {
            this._jTableModel.addRow(objectArray);
        }
        this._jTableModel.fireTableDataChanged();
    }

    @Override
    public void setToolTip() {
    }
}

