/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.offline.OfflineDatamoveOutputStream;
import oracle.dbtools.migration.datamove.online.ConstraintHandler;
import oracle.dbtools.migration.datamove.online.Messages;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public class OfflineConstraintHandler
extends ConstraintHandler {
    private static final String QUERY_FIND_CONSTRAINTS = "SELECT A.SCHEMA_NAME, A.TABLE_NAME, B.NAME, B.CONSTRAINT_TYPE, DECODE(B.CONSTRAINT_TYPE, 'CHECK', 1, 'FOREIGN KEY',2, 'PK', 3, 'UNIQUE', 4) CONSCODE, B.ID FROM MGV_ALL_TABLES A, MD_CONSTRAINTS B WHERE A.TABLE_ID = B.TABLE_ID_FK AND A.CONNECTION_ID = ? AND A.CATALOG_NAME = ? AND A.SCHEMA_NAME = ? ORDER BY CONSCODE";

    public OfflineConstraintHandler(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        super(dBObjectId, persistenceManager);
    }

    public void disableConstraints(OfflineDatamoveOutputStream offlineDatamoveOutputStream, String string, String string2, boolean bl) {
        try {
            this.disableConstraints(offlineDatamoveOutputStream, null, string, string2, bl);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableConstraints(OfflineDatamoveOutputStream offlineDatamoveOutputStream, Connection connection, String string, String string2, boolean bl) throws SQLException {
        if (offlineDatamoveOutputStream == null && connection == null) {
            throw new IllegalArgumentException(Messages.getString("ConstraintHandler.4"));
        }
        if (offlineDatamoveOutputStream != null && connection != null) {
            throw new IllegalArgumentException(Messages.getString("ConstraintHandler.5"));
        }
        this.m_disabledConstraints = new ArrayList();
        CloseableResultSet closeableResultSet = null;
        try {
            PreparedStatement preparedStatement = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_CONSTRAINTS);
            preparedStatement.setLong(1, this.m_connectionId.getId());
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            while (resultSet.next()) {
                ConstraintHandler.ConstraintDetail constraintDetail = new ConstraintHandler.ConstraintDetail(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3));
                try {
                    try {
                        if (MdConstraint.retrieveExistingInstance(this.m_persistenceManager, new DBObjectId(resultSet.getLong(6))).getProperty("DO_NOT_ENABLE_DISABLE") != null) continue;
                        if (connection != null) {
                            OfflineConstraintHandler.disableDetail(constraintDetail, connection, bl);
                        } else {
                            offlineDatamoveOutputStream.println(constraintDetail.toOracleDisableString(bl) + ";");
                        }
                        this.m_disabledConstraints.add(constraintDetail);
                    }
                    catch (PersistenceException persistenceException) {
                        MigrationLogUtil.logThrowable("DataMove.DISABLE_CONSTRAINTS_FAILED", new Object[]{Messages.getString("ConstraintHandler.8"), new LogInfo(Messages.getString("ConstraintHandler.9"))}, (Throwable)persistenceException);
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        MigrationLogUtil.logThrowable("DataMove.DISABLE_CONSTRAINTS_FAILED", new Object[]{Messages.getString("ConstraintHandler.8"), new LogInfo(Messages.getString("ConstraintHandler.9"))}, (Throwable)noSuchObjectException);
                    }
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 2431) continue;
                    MigrationLogUtil.logThrowable("DataMove.DISABLE_CONSTRAINTS_FAILED", new Object[]{Messages.getString("ConstraintHandler.8"), new LogInfo(Messages.getString("ConstraintHandler.9"))}, (Throwable)sQLException);
                }
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }
}

