/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.offline.Messages;
import oracle.dbtools.migration.datamove.offline.OfflineDatamoveOutputStream;

public class ClobToBlobHandler {
    protected PersistenceManager m_persistenceManager = null;
    protected DBObjectId m_connectionId = null;
    private static final String QUERY_FIND_BLOBS = "SELECT A.SCHEMA_NAME, A.TABLE_NAME, B.COLUMN_NAME, B.COLUMN_ORDER, B.NULLABLE FROM MGV_ALL_TABLES A, MD_COLUMNS B WHERE UPPER(B.COLUMN_TYPE) = 'BLOB' AND A.TABLE_ID = B.TABLE_ID_FK AND A.CONNECTION_ID = ? AND A.CATALOG_NAME = ? AND A.SCHEMA_NAME = ? ORDER BY A.SCHEMA_NAME, A.TABLE_NAME, B.COLUMN_ORDER ";

    public ClobToBlobHandler(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
        this.m_connectionId = dBObjectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAddAndModify(OfflineDatamoveOutputStream offlineDatamoveOutputStream, String string, String string2, boolean bl) {
        try {
            if (offlineDatamoveOutputStream == null) {
                throw new IllegalArgumentException("output cannot be null");
            }
            CloseableResultSet closeableResultSet = null;
            try {
                PreparedStatement preparedStatement = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_BLOBS);
                preparedStatement.setLong(1, this.m_connectionId.getId());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                closeableResultSet = new CloseableResultSet(null, resultSet);
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    String string5 = resultSet.getString(3);
                    int n = resultSet.getInt(4);
                    String string6 = resultSet.getString(5);
                    if (bl) {
                        offlineDatamoveOutputStream.println("ALTER TABLE " + string3 + "." + string4 + " add (SQLDEVELOPER_CLOB_" + n + " CLOB);");
                        if (!string6.equals("N")) continue;
                        offlineDatamoveOutputStream.println("ALTER TABLE " + string3 + "." + string4 + " MODIFY " + string5 + " NULL;");
                        continue;
                    }
                    offlineDatamoveOutputStream.println("ALTER TABLE " + string4 + " add (SQLDEVELOPER_CLOB_" + n + " CLOB);");
                    if (!string6.equals("N")) continue;
                    offlineDatamoveOutputStream.println("ALTER TABLE " + string4 + " MODIFY " + string5 + " NULL;");
                }
            }
            finally {
                if (closeableResultSet != null) {
                    closeableResultSet.close();
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, "DataMove.FAILED_TO_WRITE_TO_OFFLINE_FILE", sQLException.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeProcedureCallAndNotNull(OfflineDatamoveOutputStream offlineDatamoveOutputStream, String string, String string2, boolean bl) {
        try {
            if (offlineDatamoveOutputStream == null) {
                throw new IllegalArgumentException(Messages.getString("ClobToBlobHandler.21"));
            }
            CloseableResultSet closeableResultSet = null;
            try {
                PreparedStatement preparedStatement = this.m_persistenceManager.getPreparedStatement(QUERY_FIND_BLOBS);
                preparedStatement.setLong(1, this.m_connectionId.getId());
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                closeableResultSet = new CloseableResultSet(null, resultSet);
                while (resultSet.next()) {
                    String string3 = resultSet.getString(1);
                    String string4 = resultSet.getString(2);
                    String string5 = resultSet.getString(3);
                    int n = resultSet.getInt(4);
                    String string6 = resultSet.getString(5);
                    if (bl) {
                        offlineDatamoveOutputStream.println("BEGIN " + string3 + ".CLOBTOBLOB_sqldeveloper('" + string4 + "', 'SQLDEVELOPER_CLOB_" + n + "', '" + string5 + "'); END;");
                        offlineDatamoveOutputStream.println("/");
                        if (!string6.equals("N")) continue;
                        offlineDatamoveOutputStream.println("ALTER TABLE " + string3 + "." + string4 + " MODIFY " + string5 + " NOT NULL;");
                        continue;
                    }
                    offlineDatamoveOutputStream.println("BEGIN CLOBTOBLOB_sqldeveloper('" + string4 + "', 'SQLDEVELOPER_CLOB_" + n + "', '" + string5 + "'); END;");
                    offlineDatamoveOutputStream.println("/");
                    if (!string6.equals("N")) continue;
                    offlineDatamoveOutputStream.println("ALTER TABLE " + string4 + " MODIFY " + string5 + " NOT NULL;");
                }
            }
            finally {
                if (closeableResultSet != null) {
                    closeableResultSet.close();
                }
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, "DataMove.FAILED_TO_WRITE_TO_OFFLINE_FILE", sQLException.getLocalizedMessage());
        }
    }
}

