/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.core.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;

public class MultiLevelLogManager {
    private static Logger s_logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle", "oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    private static ResourceBundle s_bundle = ResourceBundle.getBundle("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    private Hashtable<Object, ArrayList<LogPoint>> m_currentObjects = new Hashtable();

    public void logMessage(Object object, Level level, String string, Object[] objectArray) {
        ArrayList<Object> arrayList;
        if (this.m_currentObjects.containsKey(object)) {
            arrayList = this.m_currentObjects.get(object);
        } else {
            arrayList = new ArrayList();
            this.m_currentObjects.put(object, arrayList);
        }
        arrayList.add(new LogPoint(level, string, objectArray));
    }

    public void commitLog(Level level, Object object, String string, PersistableObject persistableObject) {
        if (!this.m_currentObjects.containsKey(object)) {
            return;
        }
        ArrayList<LogPoint> arrayList = this.m_currentObjects.remove(object);
        if (arrayList.size() == 0) {
            return;
        }
        ClickableLogInfo clickableLogInfo = null;
        if (persistableObject != null) {
            clickableLogInfo = new ClickableLogInfo(persistableObject);
        }
        if (arrayList.size() == 1) {
            s_logger.log(MultiLevelLogManager.toLogRecord(arrayList.get(0), clickableLogInfo));
        } else {
            LogInfo logInfo = new LogInfo("");
            for (LogPoint logPoint : arrayList) {
                logInfo.addChild(MultiLevelLogManager.toLogRecord(logPoint, clickableLogInfo));
            }
            s_logger.log(level, string, logInfo);
        }
    }

    private static LogRecord toLogRecord(LogPoint logPoint, LogInfo logInfo) {
        String string = MessageFormat.format(s_bundle.getString(logPoint.getMessage()), logPoint.getArgs());
        LogRecord logRecord = new LogRecord(logPoint.getLevel(), string);
        logRecord.setLoggerName(s_logger.getName());
        if (logInfo != null) {
            logRecord.setParameters(new Object[]{logInfo});
        } else {
            List<LogInfo> list = MigrationLogUtil.searchParameterByType(logPoint.getArgs(), LogInfo.class);
            logRecord.setParameters(list.toArray());
        }
        return logRecord;
    }

    private static class LogPoint {
        Level m_level;
        String m_message;
        Object[] m_args;

        public LogPoint(Level level, String string, Object[] objectArray) {
            this.setLevel(level);
            this.setMessage(string);
            this.setArgs(objectArray);
        }

        public Object[] getArgs() {
            return this.m_args;
        }

        private void setArgs(Object[] objectArray) {
            this.m_args = objectArray;
        }

        public Level getLevel() {
            return this.m_level;
        }

        private void setLevel(Level level) {
            this.m_level = level;
        }

        public String getMessage() {
            return this.m_message;
        }

        private void setMessage(String string) {
            this.m_message = string;
        }
    }
}

