/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.convert;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectHierarchy;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdMigrParameter;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.ParameterIterator;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.HierarchicalTranslationNameScope;
import oracle.dbtools.migration.convert.ObjectIdentifierTranslationCache;
import oracle.dbtools.migration.convert.ObjectNameEntity;
import oracle.dbtools.migration.convert.StatementObjectNameScopeEntity;
import oracle.dbtools.migration.parser.defaults.DefaultTranslationContext;
import oracle.dbtools.migration.parser.ext.ExtStringTemplate;
import oracle.dbtools.migration.translation.api.IHierarchicalTranslationNameScope;
import oracle.dbtools.migration.translation.api.IStatementObjectNameScopeEntity;
import oracle.dbtools.migration.translation.api.ITranslationContext;
import oracle.dbtools.migration.translation.api.components.TranslationDataType;
import oracle.dbtools.migration.translation.api.components.TranslationParameter;
import oracle.dbtools.migration.translation.api.exceptions.TranslationObjectNotFoundException;
import oracle.dbtools.migration.translation.api.objects.TranslationColumn;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObject;
import oracle.dbtools.migration.translation.api.objects.TranslationDBObjectReference;
import oracle.dbtools.migration.translation.api.objects.TranslationDatabase;
import oracle.dbtools.migration.translation.api.objects.TranslationObjectType;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.preferences.ConfigurationData;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class TranslationContext
implements ITranslationContext {
    public static final int DEFAULT_MAX_ENTRIES = 500;
    private String CAPT_TO_CONV_NAME_QUERY = "select conschemaname, conmainobjname, conmainobjtype, conobjname, conobjtype from  mgv_derived_details where conconnid = ? and capschemaname= ? and capmainobjtype = ? and capmainobjname = ? and capobjtype = ? and capobjname = ?";
    private static final String QUERY_TRANSFORMED_OBJECTS = "SELECT src_type, original_identifier, new_identifier FROM md_derivatives WHERE transformed IS NOT NULL AND src_type = derived_type AND derived_connection_id_fk = ? ORDER BY src_type";
    private static final String QUERY_FIND_DERIVED_OBJECT = "SELECT new_identifier FROM md_derivatives WHERE transformed IS NOT NULL AND src_type = derived_type AND derived_connection_id_fk = ? AND src_type = ? AND original_identifier = ?";
    private static final String QUERY_REVERSE_FIND_DERIVED_OBJECT = "SELECT original_identifier FROM md_derivatives WHERE transformed IS NOT NULL AND src_type = derived_type AND derived_connection_id_fk = ? AND src_type = ? AND new_identifier = ?";
    private DBObjectId m_connectionId;
    private String m_defaultSchema;
    private PersistenceManager m_persistenceManager;
    private DataTypeConversionMap m_conversionMap;
    private HashMap<String, String> m_infoKeyValue = new HashMap();
    private HashMap<String, Integer> m_dynamicObjectsIncrement = new HashMap();
    private HashMap<String, String> m_dynamicObjectOwners = new HashMap();
    private LinkedList<Long> m_viewGenOrderList = null;
    private boolean m_useViewList = true;
    private ObjectIdentifierTranslationCache m_objectNameEntityCache;
    private String EMULATIONPACKAGENAME = null;
    private static boolean _preferencesOn = true;

    public TranslationContext(PersistenceManager persistenceManager, DBObjectId dBObjectId, int n, DBObjectId dBObjectId2) throws PersistenceException {
        this.setConnectionId(dBObjectId);
        this.setPersistenceManager(persistenceManager);
        this.m_conversionMap = ConvertUtils.getPersistedMap(this.getPersistenceManager(), this.getConnectionId());
    }

    public TranslationContext(PersistenceManager persistenceManager, DBObjectId dBObjectId, int n, DBObjectId dBObjectId2, boolean bl) throws PersistenceException {
        this(persistenceManager, dBObjectId, n, dBObjectId2);
        if (bl) {
            this.m_objectNameEntityCache = new ObjectIdentifierTranslationCache(dBObjectId);
            this.m_objectNameEntityCache.initCache();
        }
    }

    protected void setConnectionId(DBObjectId dBObjectId) {
        this.m_connectionId = dBObjectId;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    public IHierarchicalTranslationNameScope newHierarchicalTranslationNameScope() {
        return new HierarchicalTranslationNameScope();
    }

    public IStatementObjectNameScopeEntity newStatementObjectNameScopeEntity(String string, String string2, String string3, boolean bl) {
        return new StatementObjectNameScopeEntity(string, string2, string3, bl);
    }

    public ObjectNameEntity getTransformedObjectIdentifier(String string, String string2, String string3, String string4, String string5) throws Exception {
        ObjectNameEntity objectNameEntity = null;
        if (this.m_objectNameEntityCache == null) {
            throw new PersistenceException("Not Supported Exception");
        }
        objectNameEntity = this.m_objectNameEntityCache.getTransformedObjectIdentifier(string, string2, string3, string4, string5);
        return objectNameEntity;
    }

    public ObjectNameEntity getTransformedObjectIdentifierForce(String string, String string2, String string3, String string4, String string5) throws Exception {
        ObjectNameEntity objectNameEntity = this.getTransformedObjectIdentifier(string, string2, string3, string4, string5);
        if (objectNameEntity == null) {
            objectNameEntity = this.fetchTransformedObjectIdentifier(string, string2, string3, string4, string5);
        }
        return objectNameEntity;
    }

    private synchronized ObjectNameEntity fetchTransformedObjectIdentifier(String string, String string2, String string3, String string4, String string5) throws PersistenceException {
        ObjectNameEntity objectNameEntity = null;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        Connection connection = persistenceManager.getConn();
        if (connection != null) {
            try {
                preparedStatement = connection.prepareStatement(this.CAPT_TO_CONV_NAME_QUERY);
                preparedStatement.setLong(1, this.m_connectionId.getId());
                preparedStatement.setString(2, string.toUpperCase());
                preparedStatement.setString(3, string2.toUpperCase());
                preparedStatement.setString(4, string3.toUpperCase());
                preparedStatement.setString(5, string4.toUpperCase());
                preparedStatement.setString(6, string5.toUpperCase());
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string6 = resultSet.getString(1);
                    string7 = resultSet.getString(2);
                    string8 = resultSet.getString(3);
                    string9 = resultSet.getString(4);
                    string10 = resultSet.getString(5);
                    objectNameEntity = new ObjectNameEntity(string6, string7, string8, string9, string10, true);
                }
            }
            catch (SQLException sQLException) {
                throw new PersistenceException(sQLException);
            }
            finally {
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        return objectNameEntity;
    }

    public DBObjectId getConnectionId() {
        return this.m_connectionId;
    }

    public PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected String findDerivedName(String string, String string2) throws PersistenceException {
        return this.mdQuery(string, string2, QUERY_FIND_DERIVED_OBJECT);
    }

    protected String reverseLookup(String string, String string2) throws PersistenceException {
        return this.mdQuery(string, string2, QUERY_REVERSE_FIND_DERIVED_OBJECT);
    }

    protected String mdQuery(String string, String string2, String string3) throws PersistenceException {
        CloseableResultSet closeableResultSet = null;
        String string4 = null;
        try {
            PreparedStatement preparedStatement = this.getPersistenceManager().getPreparedStatement(string3);
            preparedStatement.setLong(1, this.getConnectionId().getId());
            preparedStatement.setString(2, string2);
            preparedStatement.setString(3, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            closeableResultSet = new CloseableResultSet(null, resultSet);
            if (resultSet.next()) {
                string4 = resultSet.getString(1);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
        return string4;
    }

    public void completeSourceObject(TranslationDBObjectReference translationDBObjectReference, Object object) throws TranslationObjectNotFoundException {
        DBObjectHierarchy dBObjectHierarchy = null;
        if (!(object instanceof PersistableObject)) {
            throw new TranslationObjectNotFoundException();
        }
        dBObjectHierarchy = new DBObjectHierarchy((PersistableObject)object, this.getPersistenceManager());
        PersistableObject persistableObject = null;
        this.syncObjectWithCallerHierarchy(translationDBObjectReference, dBObjectHierarchy);
        try {
            persistableObject = (translationDBObjectReference.getDatabaseName() == null || dBObjectHierarchy.getCatalog().getCatalogName().equalsIgnoreCase(translationDBObjectReference.getDatabaseName())) && (translationDBObjectReference.getOwnerName() == null || dBObjectHierarchy.getSchema().getName().equalsIgnoreCase(translationDBObjectReference.getOwnerName())) ? this.getPersistableObject(dBObjectHierarchy.getSchema(), translationDBObjectReference) : (dBObjectHierarchy.getCatalog().getCatalogName().equalsIgnoreCase(translationDBObjectReference.getDatabaseName()) ? this.getPeristableObject(dBObjectHierarchy.getCatalog(), translationDBObjectReference) : this.getPeristableObject(dBObjectHierarchy.getConnection(), translationDBObjectReference));
        }
        catch (Exception exception) {
            throw new TranslationObjectNotFoundException();
        }
        translationDBObjectReference.setOMWBObj((Object)persistableObject);
        TranslationObjectType translationObjectType = TranslationContext.getRosettaObjectType(persistableObject);
        if (translationObjectType != null) {
            translationDBObjectReference.setType(translationObjectType);
        }
    }

    private void syncObjectWithCallerHierarchy(TranslationDBObjectReference translationDBObjectReference, DBObjectHierarchy dBObjectHierarchy) {
        try {
            if (translationDBObjectReference.getServerName() == null) {
                translationDBObjectReference.setServerName(dBObjectHierarchy.getConnection().getHost());
            }
            if (translationDBObjectReference.getDatabaseName() == null) {
                translationDBObjectReference.setDatabaseName(dBObjectHierarchy.getCatalog().getCatalogName());
            }
            if (translationDBObjectReference.getOwnerName() == null) {
                translationDBObjectReference.setOwnerName(dBObjectHierarchy.getSchema().getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PersistableObject getPeristableObject(MdConnection mdConnection, TranslationDBObjectReference translationDBObjectReference) throws PersistenceException, NoSuchObjectException {
        MdCatalog mdCatalog = null;
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
        DBObjectId dBObjectId = persistenceUtility.getIdForCatalog(mdConnection.getKey(), translationDBObjectReference.getDatabaseName());
        mdCatalog = (MdCatalog)persistenceUtility.loadPersistableObject(dBObjectId, "MD_CATALOGS");
        return this.getPeristableObject(mdCatalog, translationDBObjectReference);
    }

    private PersistableObject getPeristableObject(MdCatalog mdCatalog, TranslationDBObjectReference translationDBObjectReference) throws PersistenceException, NoSuchObjectException {
        MdSchema mdSchema = null;
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
        DBObjectId dBObjectId = persistenceUtility.getIdForSchema(mdCatalog.getKey(), translationDBObjectReference.getOwnerName());
        if (dBObjectId == null) {
            return null;
        }
        mdSchema = (MdSchema)persistenceUtility.loadPersistableObject(dBObjectId, "MD_SCHEMAS");
        return this.getPersistableObject(mdSchema, translationDBObjectReference);
    }

    private PersistableObject getPersistableObject(MdSchema mdSchema, TranslationDBObjectReference translationDBObjectReference) throws PersistenceException, NoSuchObjectException {
        PersistableObject persistableObject = null;
        DBObjectId dBObjectId = null;
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
        if (translationDBObjectReference.getType() == null) {
            return null;
        }
        if (translationDBObjectReference.getType().equals(TranslationObjectType.PROCEDURE_OR_FUNCTION_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.PROCEDURE_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.FUNCTION_TYPE)) {
            dBObjectId = persistenceUtility.getIdForStoredProgram(mdSchema.getKey(), translationDBObjectReference.getObjName());
            persistableObject = persistenceUtility.loadPersistableObject(dBObjectId, "MD_STORED_PROGRAMS");
        } else if (translationDBObjectReference.getType().equals(TranslationObjectType.TABLE_OR_VIEW_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.TABLE_TYPE) || translationDBObjectReference.getType().equals(TranslationObjectType.VIEW_TYPE)) {
            try {
                dBObjectId = persistenceUtility.getIdForTable(mdSchema.getKey(), translationDBObjectReference.getObjName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dBObjectId != null) {
                dBObjectId = persistenceUtility.getIdForTable(mdSchema.getKey(), translationDBObjectReference.getObjName());
                persistableObject = persistenceUtility.loadPersistableObject(dBObjectId, "MD_TABLES");
            } else {
                dBObjectId = persistenceUtility.getIdForView(mdSchema.getKey(), translationDBObjectReference.getObjName());
                persistableObject = persistenceUtility.loadPersistableObject(dBObjectId, "MD_VIEWS");
            }
        } else if (translationDBObjectReference.getType().equals(TranslationObjectType.TRIGGER_TYPE)) {
            dBObjectId = persistenceUtility.getIdForTrigger(mdSchema.getKey(), translationDBObjectReference.getObjName());
            persistableObject = persistenceUtility.loadPersistableObject(dBObjectId, "MD_TRIGGERS");
        } else if (translationDBObjectReference.getType().equals(TranslationObjectType.COLUMN_TYPE)) {
            DBObjectId dBObjectId2 = null;
            if (translationDBObjectReference.getObjName() != null) {
                try {
                    dBObjectId2 = persistenceUtility.getIdForTable(mdSchema.getKey(), translationDBObjectReference.getObjName());
                    dBObjectId = persistenceUtility.getIdForColumn(dBObjectId2, translationDBObjectReference.getPartName());
                    persistableObject = persistenceUtility.loadPersistableObject(dBObjectId, "MD_COLUMNS");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dBObjectId2 == null) {
                    dBObjectId2 = persistenceUtility.getIdForView(mdSchema.getKey(), translationDBObjectReference.getObjName());
                    persistableObject = persistenceUtility.loadPersistableObject(dBObjectId2, "MD_VIEWS");
                    return persistableObject;
                }
            }
        } else if (translationDBObjectReference.getType().equals(TranslationObjectType.SCHEMA_TYPE)) {
            DBObjectId dBObjectId3 = persistenceUtility.getIdForSchema(mdSchema.getCatalogId(), translationDBObjectReference.getOwnerName());
            persistableObject = persistenceUtility.loadPersistableObject(dBObjectId3, "MD_SCHEMAS");
        } else {
            persistableObject = null;
        }
        return persistableObject;
    }

    public TranslationDBObjectReference getTargetDBObjectReference(TranslationDBObjectReference translationDBObjectReference, Object object) throws TranslationObjectNotFoundException {
        if (translationDBObjectReference.getType().equals(TranslationObjectType.COLUMN_TYPE) && (translationDBObjectReference.getObjName() == null || translationDBObjectReference.getObjName().equalsIgnoreCase("INSERTED") || translationDBObjectReference.getObjName().equalsIgnoreCase("DELETED"))) {
            return null;
        }
        if (translationDBObjectReference.getType().equals(TranslationObjectType.COLUMN_TYPE) && translationDBObjectReference.getPartName().equals("*")) {
            translationDBObjectReference.setType(TranslationObjectType.TABLE_OR_VIEW_TYPE);
        }
        if (translationDBObjectReference.getOMWBObj() == null) {
            this.completeSourceObject(translationDBObjectReference, object);
        }
        PersistableObject persistableObject = null;
        PersistableObject persistableObject2 = (PersistableObject)translationDBObjectReference.getOMWBObj();
        try {
            persistableObject = ConvertUtils.findPersistableCopy(this.getPersistenceManager(), persistableObject2, this.getConnectionId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (persistableObject == null) {
            return null;
        }
        DBObjectHierarchy dBObjectHierarchy = new DBObjectHierarchy(persistableObject, this.getPersistenceManager());
        TranslationDBObjectReference translationDBObjectReference2 = dBObjectHierarchy.getTranslationDBObjectReference();
        translationDBObjectReference2.setAlias(DefaultTranslationContext.createValidIdentifier((String)translationDBObjectReference.getAlias(), (String)"object"));
        translationDBObjectReference2.setObjectAlias(DefaultTranslationContext.createValidIdentifier((String)translationDBObjectReference.getObjectAlias(), (String)"object"));
        return translationDBObjectReference2;
    }

    public Object getPersistableCopy(TranslationDBObjectReference translationDBObjectReference, Object object) throws TranslationObjectNotFoundException {
        if (translationDBObjectReference.getType().equals(TranslationObjectType.COLUMN_TYPE) && translationDBObjectReference.getObjName() == null) {
            return null;
        }
        if (translationDBObjectReference.getType().equals(TranslationObjectType.COLUMN_TYPE) && translationDBObjectReference.getPartName().equals("*")) {
            translationDBObjectReference.setType(TranslationObjectType.TABLE_OR_VIEW_TYPE);
        }
        if (translationDBObjectReference.getOMWBObj() == null) {
            this.completeSourceObject(translationDBObjectReference, object);
        }
        PersistableObject persistableObject = null;
        PersistableObject persistableObject2 = (PersistableObject)translationDBObjectReference.getOMWBObj();
        try {
            persistableObject = ConvertUtils.findPersistableCopy(this.getPersistenceManager(), persistableObject2, this.getConnectionId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return persistableObject;
    }

    public static TranslationObjectType getRosettaObjectType(PersistableObject persistableObject) {
        if (persistableObject == null) {
            return null;
        }
        String string = persistableObject.getObjectType();
        TranslationObjectType translationObjectType = null;
        if (string.equalsIgnoreCase("MD_TABLES")) {
            translationObjectType = TranslationObjectType.TABLE_TYPE;
        } else if (string.equalsIgnoreCase("MD_VIEWS")) {
            translationObjectType = TranslationObjectType.VIEW_TYPE;
        } else if (string.equalsIgnoreCase("MD_TRIGGERS")) {
            translationObjectType = TranslationObjectType.TRIGGER_TYPE;
        } else if (string.equalsIgnoreCase("MD_INDEXES")) {
            translationObjectType = TranslationObjectType.INDEX_TYPE;
        } else if (string.equalsIgnoreCase("MD_SEQUENCES")) {
            translationObjectType = TranslationObjectType.SEQUENCE_TYPE;
        } else if (string.equalsIgnoreCase("MD_STORED_PROGRAMS")) {
            translationObjectType = ((MdStoredProgram)persistableObject).getProgramtype() == null ? TranslationObjectType.PROCEDURE_TYPE : (((MdStoredProgram)persistableObject).getProgramtype().equalsIgnoreCase("FN") || ((MdStoredProgram)persistableObject).getProgramtype().equalsIgnoreCase("IF") || ((MdStoredProgram)persistableObject).getProgramtype().equalsIgnoreCase("TF") ? TranslationObjectType.FUNCTION_TYPE : (((MdStoredProgram)persistableObject).getProgramtype().startsWith("P") ? TranslationObjectType.PROCEDURE_TYPE : TranslationObjectType.PROCEDURE_TYPE));
        } else if (string.equalsIgnoreCase("MD_CONSTRAINTS")) {
            translationObjectType = TranslationObjectType.CONSTRAINT_TYPE;
        } else if (string.equalsIgnoreCase("MD_COLUMNS")) {
            translationObjectType = TranslationObjectType.COLUMN_TYPE;
        } else if (string.equalsIgnoreCase("MD_SCHEMAS")) {
            translationObjectType = TranslationObjectType.SCHEMA_TYPE;
        }
        return translationObjectType;
    }

    public void completeSourceColumn(TranslationColumn translationColumn, Object object) throws TranslationObjectNotFoundException {
    }

    public TranslationDatabase getExpectedTargetDatabase(Object object) {
        return null;
    }

    public ArrayList<TranslationDBObjectReference> getObjectsDependentOnThisSource(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    public ArrayList<TranslationDBObjectReference> getObjectsDependentOnThisTarget(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    public ArrayList<TranslationColumn> getSourceColumns(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        if (translationDBObjectReference.getType().equals(TranslationObjectType.COLUMN_TYPE) && translationDBObjectReference.getObjName() == null) {
            return null;
        }
        this.completeSourceObject(translationDBObjectReference, translationDBObjectReference.getOMWBObj());
        PersistableObject persistableObject = (PersistableObject)translationDBObjectReference.getOMWBObj();
        ArrayList<TranslationColumn> arrayList = new ArrayList<TranslationColumn>();
        try {
            CloseableIterator closeableIterator = PersistenceUtility.getInstance(this.getPersistenceManager()).getColumnsForTableId(persistableObject.getKey());
            while (closeableIterator.hasNext()) {
                MdColumn mdColumn = (MdColumn)closeableIterator.next();
                arrayList.add(new TranslationColumn(new TranslationDBObjectReference(null, null, null, null, mdColumn.getColumnName(), TranslationObjectType.COLUMN_TYPE, null), new TranslationDataType(mdColumn.getColumnType())));
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
            return null;
        }
        return arrayList;
    }

    public TranslationDatabase getSourceDatabase(Object object) throws TranslationObjectNotFoundException {
        return null;
    }

    public ArrayList<TranslationDBObjectReference> getSourceObjectsThisDependsOn(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    public ArrayList<TranslationParameter> getSourceParameters(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return this.getParameters(translationDBObjectReference);
    }

    public ArrayList<TranslationParameter> getTargetParameters(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return this.getParameters(translationDBObjectReference);
    }

    public ArrayList<TranslationParameter> getParameters(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        ArrayList<TranslationParameter> arrayList = new ArrayList<TranslationParameter>();
        ParameterIterator parameterIterator = null;
        try {
            parameterIterator = new ParameterIterator(this.getPersistenceManager(), ((PersistableObject)translationDBObjectReference.getOMWBObj()).getKey());
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
        if (parameterIterator == null) {
            return null;
        }
        TranslationParameter translationParameter = null;
        while (parameterIterator.hasNext()) {
            MdMigrParameter mdMigrParameter = (MdMigrParameter)parameterIterator.next();
            translationParameter = new TranslationParameter();
            translationParameter.setExtra(mdMigrParameter.getParamExisting() == 1);
            translationParameter.setName(mdMigrParameter.getParamName());
            translationParameter.setParamPosition(mdMigrParameter.getParamOrder().intValue());
            translationParameter.setParamType(mdMigrParameter.getParamType());
            translationParameter.setDataType(new TranslationDataType(mdMigrParameter.getParamDataType()));
            translationParameter.setDefaultValueStr(mdMigrParameter.getDefaultValue());
            arrayList.add(translationParameter);
        }
        return arrayList;
    }

    public ArrayList<TranslationColumn> getTargetColumns(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        if (translationDBObjectReference.getType().equals(TranslationObjectType.COLUMN_TYPE) && translationDBObjectReference.getObjName() == null) {
            return null;
        }
        this.completeSourceObject(translationDBObjectReference, translationDBObjectReference.getOMWBObj());
        PersistableObject persistableObject = null;
        try {
            persistableObject = ConvertUtils.findPersistableCopy(this.getPersistenceManager(), (PersistableObject)translationDBObjectReference.getOMWBObj(), this.getConnectionId());
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (persistableObject == null) {
            return null;
        }
        ArrayList<TranslationColumn> arrayList = new ArrayList<TranslationColumn>();
        try {
            CloseableIterator closeableIterator = PersistenceUtility.getInstance(this.getPersistenceManager()).getColumnsForTableId(persistableObject.getKey());
            while (closeableIterator.hasNext()) {
                MdColumn mdColumn = (MdColumn)closeableIterator.next();
                String string = mdColumn.getIdentityClause();
                TranslationColumn translationColumn = new TranslationColumn(new TranslationDBObjectReference(null, null, null, null, mdColumn.getColumnName(), TranslationObjectType.COLUMN_TYPE, null), new TranslationDataType(mdColumn.getColumnType()));
                if (string != null) {
                    translationColumn.setDefaultValue(string);
                }
                translationColumn.setColumnIndex(mdColumn.getColumnOrder().intValue());
                arrayList.add(translationColumn);
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
            return null;
        }
        return arrayList;
    }

    public TranslationDataType getTargetDataType(TranslationDataType translationDataType, Object object) {
        Integer n;
        Integer n2;
        String string = translationDataType.getDataType();
        try {
            n2 = Integer.valueOf(translationDataType.getPrecision());
        }
        catch (Exception exception) {
            n2 = null;
        }
        try {
            n = Integer.valueOf(translationDataType.getScale());
        }
        catch (Exception exception) {
            n = null;
        }
        DataTypeSpecification dataTypeSpecification = this.m_conversionMap.mapDataType(new DataTypeSpecification(string, n2, n));
        if (dataTypeSpecification == null) {
            return null;
        }
        TranslationDataType translationDataType2 = new TranslationDataType(dataTypeSpecification.getName());
        if (dataTypeSpecification.getPrecision() != null) {
            translationDataType2.setPrecision(dataTypeSpecification.getPrecision().toString());
        }
        if (dataTypeSpecification.getScale() != null) {
            translationDataType2.setScale(dataTypeSpecification.getScale().toString());
        }
        translationDataType2.setSchema(translationDataType.getSchema());
        return translationDataType2;
    }

    public ArrayList<TranslationDBObjectReference> getTargetObjectsThisDependsOn(TranslationDBObjectReference translationDBObjectReference) throws TranslationObjectNotFoundException {
        return null;
    }

    public TranslationPreferences getTranslationPreferences(Object object) {
        return TranslationContext.getStaticTranslationPreferences(object);
    }

    public static TranslationPreferences getStaticTranslationPreferences(Object object) {
        TranslationPreferences translationPreferences = new TranslationPreferences();
        if (_preferencesOn) {
            translationPreferences.setFormatMask(TranslationContext.getFormatMaskPreference());
            translationPreferences.setQueryAssignmentPreference(TranslationContext.getQueryAssignmentPreference());
            translationPreferences.setGenerateEntireEmulationPkg(TranslationContext.getGenerateEntireEmulationPkg());
            translationPreferences.setIsQuotedIdentifierOnSQLServer(TranslationContext.getIsQuotedIdentifierOnSQLServer());
            translationPreferences.setIsQuotedIdentifierOnSybase(TranslationContext.getIsQuotedIdentifierOnSybase());
            translationPreferences.setUseCompoundTrigger(TranslationContext.getUseCompoundTrigger());
            translationPreferences.setIs12c(TranslationContext.is12c());
        }
        return translationPreferences;
    }

    private static boolean is12c() {
        Preferences preferences = Preferences.getPreferences();
        MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
        return migrationConfig.getMigrate12c();
    }

    private static boolean getUseCompoundTrigger() {
        boolean bl = false;
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
            ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
            bl = configurationData.useCompoundTrigger();
        }
        catch (Exception exception) {
            return bl;
        }
        return bl;
    }

    private static boolean getIsQuotedIdentifierOnSQLServer() {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return true;
        }
        catch (Error error) {
            return true;
        }
        MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
        return migrationConfig.isQuotedIdentifierOnSQLServer();
    }

    private static boolean getIsQuotedIdentifierOnSybase() {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return false;
        }
        catch (Error error) {
            return false;
        }
        MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
        return migrationConfig.isQuotedIdentifierOnSybase();
    }

    private static String getFormatMaskPreference() {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
        ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
        return configurationData.getDateFormat();
    }

    private static String getQueryAssignmentPreference() {
        Preferences preferences = null;
        try {
            preferences = Preferences.getPreferences();
        }
        catch (Exception exception) {
            return null;
        }
        catch (Error error) {
            return null;
        }
        ConfigurationData configurationData = ConfigurationData.getInstance((PropertyStorage)preferences);
        return configurationData.getQueryAssignment();
    }

    public static boolean getGenerateEntireEmulationPkg() {
        return MigrationAddin.getMigrationConfig().getGenerateEntireEmulationPkg();
    }

    public ArrayList<String> getEmulationFuncsForSchema(Object object) {
        DBObjectId dBObjectId = (DBObjectId)object;
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
        try {
            return persistenceUtility.getEmulationFuncsForSchema(dBObjectId);
        }
        catch (PersistenceException persistenceException) {
            return null;
        }
    }

    public ArrayList<String> getEmulationFuncsForConnection(Object object) {
        DBObjectId dBObjectId = (DBObjectId)object;
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(this.getPersistenceManager());
        try {
            return persistenceUtility.getEmulationFuncsForConnection(dBObjectId);
        }
        catch (PersistenceException persistenceException) {
            return null;
        }
    }

    public String getInfoKeyValue(String string) {
        return this.m_infoKeyValue.get(string);
    }

    public void addInfoKeyValue(String string, String string2) {
        this.m_infoKeyValue.put(string, string2);
    }

    public void clearInfoKey() {
        this.m_infoKeyValue.clear();
    }

    public void setPreferences(TranslationPreferences translationPreferences) {
    }

    public String getExistingDynamicName(String string, TranslationDBObjectReference translationDBObjectReference) {
        Object var3_3 = null;
        if (this.m_dynamicObjectOwners.containsKey(this.getDynamicKey(string, translationDBObjectReference))) {
            return this.m_dynamicObjectOwners.get(this.getDynamicKey(string, translationDBObjectReference));
        }
        return this.getNewDynamicName(string, translationDBObjectReference);
    }

    private String getDecentName(String string) {
        string = string.replaceFirst("^#+", "");
        return this.subStringUpTo(string, 27);
    }

    public String getNewDynamicName(String string, TranslationDBObjectReference translationDBObjectReference) {
        String string2 = translationDBObjectReference.getIdentifierName();
        String string3 = "tt";
        String string4 = this.subStringUpTo(this.getDecentName(string), 24);
        String string5 = string3 + "_" + string4;
        int n = this.getUniqueNumber(string5);
        if (n != 1) {
            string5 = string5 + "_" + n;
        }
        this.m_dynamicObjectOwners.put(this.getDynamicKey(string, translationDBObjectReference), string5);
        return string5;
    }

    private String getDynamicKey(String string, TranslationDBObjectReference translationDBObjectReference) {
        if ((PersistableObject)translationDBObjectReference.getOMWBObj() != null) {
            return ((PersistableObject)translationDBObjectReference.getOMWBObj()).getKey() + ":" + string;
        }
        return "UNKNOWN:" + string;
    }

    private String subStringUpTo(String string, int n) {
        String string2 = string.length() > n ? string.substring(0, n) : string;
        return string2;
    }

    private int getUniqueNumber(String string) {
        int n = 1;
        if (this.getDynamicObjects().containsKey(string)) {
            n = this.getDynamicObjects().get(string) + 1;
        }
        this.setDynamicObjects(string, n);
        return n;
    }

    private HashMap<String, Integer> getDynamicObjects() {
        return this.m_dynamicObjectsIncrement;
    }

    private void setDynamicObjects(String string, int n) {
        if (this.m_dynamicObjectsIncrement.containsKey(string)) {
            this.m_dynamicObjectsIncrement.remove(string);
        }
        this.getDynamicObjects().put(string, n);
    }

    public LinkedList<Long> getViewGenOrderList() {
        return this.m_viewGenOrderList;
    }

    public void setViewGenOrderList(LinkedList<Long> linkedList) {
        this.m_viewGenOrderList = linkedList;
    }

    public void setUseViewList(boolean bl) {
        this.m_useViewList = bl;
        if (!bl) {
            this.m_viewGenOrderList = null;
        }
    }

    public boolean getUseViewList() {
        return this.m_useViewList;
    }

    public void determineViewGenerationOrder(TranslationDBObject translationDBObject, ExtStringTemplate extStringTemplate) {
        MdView mdView;
        PersistenceManager persistenceManager = this.getPersistenceManager();
        PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(persistenceManager);
        LinkedList<Long> linkedList = this.getViewGenOrderList();
        DBObjectId dBObjectId = this.getConnectionId();
        if (linkedList == null) {
            this.m_viewGenOrderList = new LinkedList();
            linkedList = this.m_viewGenOrderList;
        }
        MdView mdView2 = (MdView)translationDBObject.getOMWBObj();
        try {
            mdView = ConvertUtils.findViewCopy(mdView2, persistenceManager, dBObjectId);
        }
        catch (Exception exception) {
            this.setUseViewList(false);
            return;
        }
        MdSchema mdSchema = null;
        MdSchema mdSchema2 = MdSchema.getExistingInstance(mdView2.getSchemaId());
        String string = this.getQualifiedPartName(extStringTemplate.toString(), 1);
        if (string != null && string != mdSchema2.getName()) {
            return;
        }
        mdSchema = mdSchema2;
        String string2 = this.getQualifiedPartName(extStringTemplate.toString(), 0);
        if (string2 == null) {
            return;
        }
        DBObjectId dBObjectId2 = null;
        try {
            dBObjectId2 = persistenceUtility.getIdForView(mdSchema.getKey(), string2);
        }
        catch (PersistenceException persistenceException) {
            this.insertIntoList(linkedList, mdView.getKey().getId(), -1L);
            return;
        }
        MdView mdView3 = null;
        try {
            mdView3 = ConvertUtils.findViewCopy(MdView.getExistingInstance(dBObjectId2), persistenceManager, dBObjectId);
        }
        catch (Exception exception) {
            this.setUseViewList(false);
            return;
        }
        boolean bl = this.insertIntoList(linkedList, mdView.getKey().getId(), mdView3.getKey().getId());
        if (!bl) {
            this.setUseViewList(false);
        }
    }

    private boolean insertIntoList(LinkedList<Long> linkedList, long l, long l2) {
        int n = -1;
        int n2 = -1;
        if (linkedList.isEmpty()) {
            linkedList.addFirst(l);
            if (l2 > 0L) {
                linkedList.addFirst(l2);
            }
            return true;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            long l3 = (Long)iterator.next();
            if (l3 != l) continue;
            n = linkedList.indexOf(l3);
        }
        Iterator iterator2 = linkedList.iterator();
        while (iterator2.hasNext()) {
            long l4 = (Long)iterator2.next();
            if (l4 != l2) continue;
            n2 = linkedList.indexOf(l4);
        }
        if (n < 0 && n2 < 0) {
            linkedList.addFirst(l);
            if (l2 > 0L) {
                linkedList.addFirst(l2);
            }
            return true;
        }
        if (n < 0 && n2 >= 0) {
            linkedList.add(n2 + 1, l);
            return true;
        }
        if (n >= 0 && n2 < 0) {
            if (l2 > 0L) {
                linkedList.addFirst(l2);
            }
            return true;
        }
        return n >= 0 && n2 >= 0 && n > n2;
    }

    private String getQualifiedPartName(String string, int n) {
        String[] stringArray = string.split(".");
        if (stringArray.length == 0 && n == 0) {
            return string;
        }
        if (n > stringArray.length - 1) {
            return null;
        }
        return stringArray[stringArray.length - 1 - n];
    }

    public String getChangedIdentifierName(String string) {
        string = string.replaceAll("\"", " ").trim();
        String string2 = ConvertUtils.getChangedIdentifierNameExceptConn(string.toUpperCase(), this.getPersistenceManager(), this.getConnectionId());
        return string2;
    }

    public String getEmulationPackageName() {
        return this.EMULATIONPACKAGENAME;
    }

    public void setEmulationPackageName(String string) {
        this.EMULATIONPACKAGENAME = string;
    }

    public String getDefaultSchema() {
        return this.m_defaultSchema;
    }

    public void setDefaultSchema(String string) {
        this.m_defaultSchema = string;
    }

    public String toString() {
        return "TranslationContext";
    }

    public void enablePreferences(boolean bl) {
        _preferencesOn = bl;
    }
}

