/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.command_line.CMDLineError;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationCmdInterface;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public abstract class MigrationCmd
implements MigrationCmdInterface {
    private MigrationDetails m_migrationDetails = null;
    private String m_name;
    private long startTime = 0L;
    private long endTime = 0L;
    private boolean m_isSilent;
    private CMDOut m_cmdout = null;
    private PersistenceManager _pman = null;
    public boolean m_isPersistenceManagerRequired = true;

    protected MigrationCmd(String string, MigrationDetails migrationDetails, CMDOut cMDOut, boolean bl) {
        this.m_name = string;
        this.m_migrationDetails = migrationDetails;
        this.m_cmdout = cMDOut;
        this.m_isSilent = bl;
    }

    public String getName() {
        return this.m_name;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isSilent() {
        return this.m_isSilent;
    }

    public CMDOut getCmdout() {
        return this.m_cmdout;
    }

    protected MigrationDetails getMigrationDetails() {
        return this.m_migrationDetails;
    }

    @Override
    public void execute() throws CMDLineError {
        boolean bl = false;
        this.startTime = System.currentTimeMillis();
        if (DBUtil.getConnectionResolver() == null) {
            DBUtil.setConnectionResolver((ConnectionResolver)Connections.getInstance());
        }
        if (this.m_isPersistenceManagerRequired) {
            this.getPersistenceManager();
        }
        this.executeImpl();
        this.endTime = System.currentTimeMillis();
        if (!this.isSilent() && this.getMigrationDetails() != null && this.getMigrationDetails().isActionSpecified(this.m_name)) {
            this.getCmdout().printResult(this.m_name + " completed successfully");
        }
    }

    protected void verifyRepository() throws CMDLineError {
        String string = MigrationAddin.getDefaultMigrationRepository();
        if (string == null || string.trim().equals("")) {
            throw new CMDLineError(this.getName(), "Repository not Associated", null);
        }
    }

    protected PersistenceManager getPersistenceManager() {
        if (this._pman == null) {
            this._pman = MigrationAddin.getPersistenceManager();
        }
        if (this._pman == null) {
            String string = MigrationAddin.getDefaultMigrationRepository();
            try {
                Connections.getInstance().getConnection(string);
            }
            catch (DBException dBException) {
                throw new IllegalStateException(dBException);
            }
            MigrationAddin.openRepository(string);
            this._pman = MigrationAddin.getPersistenceManager();
        }
        return this._pman;
    }

    protected abstract void executeImpl() throws CMDLineError;

    public void signalCancel() {
    }
}

