/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.core.Messages;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationStorer;

public final class QueryCapture {
    private QueryCapture() {
        throw new UnsupportedOperationException(Messages.getString("QueryCapture.0"));
    }

    public static CloseableResultSet issueSQL(String string, Connection connection, CaptureContext captureContext) throws SQLException {
        String string2 = captureContext.applyToSQLString(string);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string2);
        return new CloseableResultSet(statement, resultSet);
    }

    public static void doCatalogCapture(String string, Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL(string, connection, captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        while (resultSet.next()) {
            if (captureContext.shouldCancel()) {
                closeableResultSet.close();
                CaptureEvent captureEvent = new CaptureEvent(-1, "SCHEMA", "");
                captureContext.getAudience().fireListeners(captureEvent);
                return;
            }
            QueryCapture.processCatalogRow(resultSet, migrationStorer, captureContext);
        }
        closeableResultSet.close();
    }

    protected static void processCatalogRow(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext) throws SQLException, PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        MdCatalog mdCatalog = new MdCatalog(dBObjectId);
        String string = resultSet.getString(1);
        mdCatalog.setCatalogName(string);
        migrationStorer.storeObject(mdCatalog);
    }

    public static void doSchemaCapture(String string, Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL(string, connection, captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        while (resultSet.next()) {
            if (captureContext.shouldCancel()) {
                closeableResultSet.close();
                CaptureEvent captureEvent = new CaptureEvent(-1, "SCHEMA", "");
                captureContext.getAudience().fireListeners(captureEvent);
                return;
            }
            QueryCapture.processSchemaRow(resultSet, migrationStorer, captureContext);
        }
        closeableResultSet.close();
    }

    public static void processSchemaRow(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext) throws SQLException, PersistenceException {
        CaptureAudience captureAudience = captureContext.getAudience();
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        MdSchema mdSchema = new MdSchema(dBObjectId);
        mdSchema.setName(resultSet.getString(1));
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() > 1) {
            for (int i = 1; i < resultSetMetaData.getColumnCount(); ++i) {
                mdSchema.addProperty(resultSetMetaData.getColumnName(i), resultSet.getString(i), dBObjectId2);
            }
        }
        CaptureEvent captureEvent = new CaptureEvent(3, "SCHEMA", mdSchema.getName());
        captureAudience.fireListeners(captureEvent);
        migrationStorer.storeObject(mdSchema);
        captureEvent.setEventId(4);
        captureAudience.fireListeners(captureEvent);
    }

    public static void doTableCapture(String string, Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL(string, connection, captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        while (resultSet.next()) {
            if (captureContext.shouldCancel()) {
                closeableResultSet.close();
                CaptureEvent captureEvent = new CaptureEvent(-1, "TABLE", "");
                captureContext.getAudience().fireListeners(captureEvent);
                return;
            }
            QueryCapture.processTableRow(resultSet, migrationStorer, captureContext);
        }
        closeableResultSet.close();
    }

    public static void processTableRow(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext) throws PersistenceException, SQLException {
        CaptureAudience captureAudience = captureContext.getAudience();
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        String string = "";
        MdCatalog mdCatalog = (MdCatalog)captureContext.getContextVariable("CATALOG");
        if (mdCatalog != null && !MigrationUtils.catalogIsDummy(mdCatalog)) {
            string = mdCatalog.getCatalogName() + ".";
        }
        String string2 = (String)captureContext.getContextVariable("SCHEMA");
        string = string + string2 + ".";
        String string3 = resultSet.getString(1);
        string = string + string3;
        MdTable mdTable = new MdTable(dBObjectId, string3, string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (resultSetMetaData.getColumnCount() > 1) {
            for (int i = 1; i < resultSetMetaData.getColumnCount(); ++i) {
                mdTable.addProperty(resultSetMetaData.getColumnName(i), resultSet.getString(i), dBObjectId2);
            }
        }
        CaptureEvent captureEvent = new CaptureEvent(3, "TABLE", mdTable.getTableName());
        captureAudience.fireListeners(captureEvent);
        migrationStorer.storeObject(mdTable);
        captureEvent.setEventId(4);
        captureAudience.fireListeners(captureEvent);
    }

    public static void doTypeCapture(String string, String string2, Connection connection, MigrationStorer migrationStorer, CaptureContext captureContext) throws PersistenceException, SQLException {
        CloseableResultSet closeableResultSet = QueryCapture.issueSQL(string, connection, captureContext);
        ResultSet resultSet = closeableResultSet.getResultSet();
        int n = 1;
        while (resultSet.next()) {
            if (captureContext.shouldCancel()) {
                closeableResultSet.close();
                CaptureEvent captureEvent = new CaptureEvent(-1, string2, "");
                captureContext.getAudience().fireListeners(captureEvent);
                return;
            }
            if (string2.equals("MD_COLUMNS")) {
                QueryCapture.processColumnRow(resultSet, migrationStorer, captureContext, n++);
                continue;
            }
            if (string2.equals("MD_COLUMNSDEFAULTS")) {
                QueryCapture.processColumnRowWithDefaults(resultSet, migrationStorer, captureContext, n++);
                continue;
            }
            if (string2.equals("MD_INDEXES")) {
                QueryCapture.processIndexRow(resultSet, migrationStorer, captureContext);
                continue;
            }
            throw new PersistenceException(MessageFormat.format(Messages.getString("QueryCapture.13"), string2));
        }
        closeableResultSet.close();
    }

    private static void processColumnRow(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext, int n) throws PersistenceException, SQLException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        MdColumn mdColumn = new MdColumn(dBObjectId, resultSet.getString(1), n);
        CaptureAudience captureAudience = captureContext.getAudience();
        mdColumn.setColumnType(resultSet.getString(2));
        mdColumn.setPrecision(resultSet.getInt(3));
        mdColumn.setScale(resultSet.getInt(4));
        String string = resultSet.getString(5);
        string = string.toUpperCase().equals("Y") || string.equals("1") ? "Y" : "N";
        mdColumn.setNullable(string);
        CaptureEvent captureEvent = new CaptureEvent(3, "COLUMN", mdColumn.getColumnName());
        captureAudience.fireListeners(captureEvent);
        migrationStorer.storeObject(mdColumn);
        captureEvent.setEventId(4);
        captureAudience.fireListeners(captureEvent);
    }

    private static void processColumnRowWithDefaults(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext, int n) throws PersistenceException, SQLException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        MdColumn mdColumn = new MdColumn(dBObjectId, resultSet.getString(1), n);
        CaptureAudience captureAudience = captureContext.getAudience();
        mdColumn.setColumnType(resultSet.getString(2));
        mdColumn.setPrecision(resultSet.getInt(3));
        mdColumn.setScale(resultSet.getInt(4));
        String string = resultSet.getString(5);
        string = string.toUpperCase().equals("Y") || string.equals("1") ? "Y" : "N";
        mdColumn.setNullable(string);
        mdColumn.setDefaultValue(resultSet.getString(6));
        CaptureEvent captureEvent = new CaptureEvent(3, "COLUMN", mdColumn.getColumnName());
        captureAudience.fireListeners(captureEvent);
        migrationStorer.storeObject(mdColumn);
        captureEvent.setEventId(4);
        captureAudience.fireListeners(captureEvent);
    }

    private static void processIndexRow(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext) throws PersistenceException, SQLException {
    }
}

