/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.capture.Capturer;
import oracle.dbtools.migration.capture.offline.MultiDatabaseOfflineCapturer;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;

public class OfflineCaptureWorker
extends CaptureWorker {
    private MultiDatabaseOfflineCapturer m_capturer;
    private ArrayList<DBObjectId> m_capturedCatalogs = new ArrayList();

    public OfflineCaptureWorker(OfflineCapturer offlineCapturer, String string, String string2) {
        this((MultiDatabaseOfflineCapturer)offlineCapturer, string, string2, null);
    }

    public OfflineCaptureWorker(MultiDatabaseOfflineCapturer multiDatabaseOfflineCapturer, String string, String string2, MigrationObjectFilterList migrationObjectFilterList) {
        super(string, string2, migrationObjectFilterList);
        this.m_capturer = multiDatabaseOfflineCapturer;
        this.addActionListener(new CaptureEventListener(){

            @Override
            public void raiseEvent(CaptureEvent captureEvent) {
                if (captureEvent.getEventId() == 6) {
                    ((AbstractOfflineCapturer)OfflineCaptureWorker.this.m_capturer).captureStarting();
                }
            }
        });
    }

    @Override
    protected void captureCatalogImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_CATALOGS", this.m_context, migrationObjectFilter);
    }

    @Override
    protected void capturePerCatalogImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(string, this.m_context, migrationObjectFilter);
    }

    @Override
    protected void capturePerSchemaImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(string, this.m_context, migrationObjectFilter);
    }

    @Override
    protected void capturePerTableImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(string, this.m_context, migrationObjectFilter);
    }

    @Override
    protected void capturePerViewImpl(String string, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects(string, this.m_context, migrationObjectFilter);
    }

    @Override
    protected void captureSchemaImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_SCHEMAS", this.m_context, migrationObjectFilter);
    }

    @Override
    protected void captureTableImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_TABLES", this.m_context, migrationObjectFilter);
    }

    @Override
    protected Capturer getCapturer() {
        return this.m_capturer;
    }

    @Override
    protected void captureSynonymImpl(MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        this.m_capturer.captureObjects("MD_SYNONYMS", this.m_context, migrationObjectFilter);
    }

    @Override
    public boolean runCapture() throws PersistenceException, CaptureException {
        boolean bl = true;
        Object var2_2 = null;
        while (this.m_capturer.hasMoreDatabase()) {
            bl &= super.runCapture();
            try {
                this.m_capturer.cleanUp();
            }
            catch (OfflineCaptureException offlineCaptureException) {}
        }
        this.m_capturedCatalogs.clear();
        return bl;
    }

    @Override
    protected void captureCatalog() throws PersistenceException, CaptureException {
        super.captureCatalog();
        boolean bl = false;
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllCatalogsRec> closeableIterator = persistenceUtility.getCatalogsForConnectionId(dBObjectId);
        while (closeableIterator.hasNext()) {
            Object object;
            bl = true;
            if (this.shouldCancel()) {
                closeableIterator.close();
                object = new CaptureEvent(-1, "SCHEMA", "");
                this.fireListeners((CaptureEvent)object);
                return;
            }
            object = (MgvAllCatalogsRec)closeableIterator.next();
            DBObjectId dBObjectId2 = ((MgvAllCatalogsRec)object).getCatalogId();
            if (this.m_capturedCatalogs.contains(dBObjectId2)) continue;
            this.checkNewCatalog(dBObjectId2);
            this.m_capturedCatalogs.add(dBObjectId2);
            return;
        }
        if (!bl) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.NO_VALID_CATALOGS");
        }
    }

    @Override
    protected void captureSchema() throws PersistenceException, SQLException, CaptureException {
        DBObjectId dBObjectId;
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_SCHEMAS");
        }
        if ((dBObjectId = (DBObjectId)this.m_context.getContextVariable("CATALOGID")) != null) {
            this.captureSchemaImpl(migrationObjectFilter);
        } else {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.NO_VALID_CATALOGS");
        }
    }

    @Override
    protected void capturePerSchema(String string) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CATALOGID");
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType(string);
        }
        this.m_context.setContextVariable("PER_CONTEXT", "MD_SCHEMAS");
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId(dBObjectId);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                object = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)object);
                this.m_context.resetContextVariable("PER_CONTEXT");
                return;
            }
            object = (MdSchema)closeableIterator.next();
            this.checkNewSchema(((PersistableObject)object).getKey());
            this.capturePerSchemaImpl(string, migrationObjectFilter);
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    @Override
    protected void captureTables() throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CATALOGID");
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_TABLES");
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId2 = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId(dBObjectId);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                object = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)object);
                return;
            }
            object = (MdSchema)closeableIterator.next();
            this.checkNewSchema(((PersistableObject)object).getKey());
            this.captureTableImpl(migrationObjectFilter);
        }
    }

    @Override
    protected void capturePerTable(String string) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CATALOGID");
        this.m_context.setContextVariable("PER_CONTEXT", "MD_TABLES");
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType(string);
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId(dBObjectId);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                object = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)object);
                return;
            }
            object = (MdSchema)closeableIterator.next();
            CloseableIterator closeableIterator2 = persistenceUtility.getTablesForSchemaId(((PersistableObject)object).getKey());
            while (closeableIterator2.hasNext()) {
                Object object2;
                if (this.shouldCancel()) {
                    object2 = new CaptureEvent(-1, "CATALOG", "");
                    this.fireListeners((CaptureEvent)object2);
                    this.m_context.resetContextVariable("PER_CONTEXT");
                    return;
                }
                object2 = (MdTable)closeableIterator2.next();
                this.checkNewSchema(((MdTable)object2).getSchemaId());
                this.checkNewTable(((PersistableObject)object2).getKey());
                this.capturePerTableImpl(string, migrationObjectFilter);
            }
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    @Override
    protected void capturePerView(String string) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CATALOGID");
        this.m_context.setContextVariable("PER_CONTEXT", "MD_VIEWS");
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType(string);
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId(dBObjectId);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                object = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)object);
                return;
            }
            object = (MdSchema)closeableIterator.next();
            CloseableIterator closeableIterator2 = persistenceUtility.getViewsForSchemaId(((PersistableObject)object).getKey());
            while (closeableIterator2.hasNext()) {
                Object object2;
                if (this.shouldCancel()) {
                    object2 = new CaptureEvent(-1, "CATALOG", "");
                    this.fireListeners((CaptureEvent)object2);
                    this.m_context.resetContextVariable("PER_CONTEXT");
                    return;
                }
                object2 = (MdView)closeableIterator2.next();
                this.checkNewSchema(((MdView)object2).getSchemaId());
                this.checkNewView(((PersistableObject)object2).getKey());
                this.capturePerViewImpl(string, migrationObjectFilter);
            }
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    @Override
    protected void captureSynonyms() throws PersistenceException, CaptureException, SQLException {
        MigrationObjectFilter migrationObjectFilter = null;
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CATALOGID");
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_SYNONYMS");
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId2 = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator closeableIterator = persistenceUtility.getSchemasforCatalogId(dBObjectId);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                object = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)object);
                return;
            }
            object = (MdSchema)closeableIterator.next();
            this.checkNewSchema(((PersistableObject)object).getKey());
            this.captureSynonymImpl(migrationObjectFilter);
        }
    }
}

