/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.babelfish;

import java.io.IOException;
import java.io.Reader;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.parser.internalapi.TranslateResultWithASTs;
import oracle.dbtools.migration.parser.plugin.Fingerprint;
import oracle.dbtools.migration.translation.RepoTranslationAPI;
import oracle.dbtools.migration.translation.SchemaDetails;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.translation.api.prefs.TranslationPreferences;
import oracle.sql.CLOB;

public abstract class STFTranslator {
    protected static final boolean DEBUG = false;
    protected static Connection m_conn;
    protected String m_profileName;
    protected int m_profileID;
    protected boolean m_translate_new_sql = false;
    protected boolean m_raise_translation_error = false;
    protected boolean m_log_translation_error = false;
    protected boolean m_trace_translation = false;
    protected ITranslationAll m_translator;
    protected static String _callingSchema;
    protected static final String TESTING_PROFILE_NAME = "SQLDEVPROFILETESTNAME";
    private static final String STFERROR = "/*STFTranslator:ERROR:";
    private static final String STFINFO = "/*STFTranslator:INFO:";
    private static final String FINGERPRINT_LIMITION_MSG = "/*STFTranslator:ERROR:could not fingerprint*/";
    private static final String TEMPLATE_LIMITION_MSG = "/*STFTranslator:ERROR:could not convert*/";

    protected abstract String getTranslatorName();

    protected abstract ITranslationAll getSQLTranslator();

    protected STFTranslator() throws SQLException {
        STFTranslator.verifyDatabaseConnection();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws SQLException {
        String string = "/*+ no_sql_translation */ select  sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_NAME'),  sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_ID'),  p.TRANSLATE_NEW_SQL , p.RAISE_TRANSLATION_ERROR,  p.LOG_TRANSLATION_ERROR,  p.TRACE_TRANSLATION  from all_sql_translation_profiles p, all_objects o  where p.owner = o.owner and  p.profile_name = o.object_name and  o.object_id = sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_ID')";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = m_conn.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new SQLException("SQL translation profile not found");
            }
            this.m_profileName = resultSet.getString(1);
            this.m_profileID = resultSet.getInt(2);
            String string2 = resultSet.getString(3);
            String string3 = resultSet.getString(4);
            String string4 = resultSet.getString(5);
            String string5 = resultSet.getString(6);
            this.m_translate_new_sql = string2.equalsIgnoreCase("TRUE");
            this.m_raise_translation_error = string3.equalsIgnoreCase("TRUE");
            this.m_log_translation_error = string4.equalsIgnoreCase("TRUE");
            this.m_trace_translation = string5.equalsIgnoreCase("TRUE");
            this.m_translator = this.getSQLTranslator();
        }
        catch (Throwable throwable) {
            STFTranslator.close(resultSet, preparedStatement);
            throw throwable;
        }
        STFTranslator.close(resultSet, preparedStatement);
    }

    public boolean translateSQL_(CLOB cLOB, CLOB[] cLOBArray) {
        String string = null;
        try {
            string = STFTranslator.clobToString(cLOB);
        }
        catch (SQLException sQLException) {
            this.printError("could not read input with exception");
            STFTranslator.print(sQLException);
            return false;
        }
        if (string == null || string.trim().equals("")) {
            this.printError("input is empty");
            return false;
        }
        String string2 = null;
        Fingerprint fingerprint = null;
        HashMap hashMap = null;
        this.Debug("original SQL " + string);
        try {
            fingerprint = this.m_translator.fingerprint(string);
            string2 = fingerprint.getFingerprint();
            hashMap = fingerprint.getValues();
            this.Debug("fingerprint " + string2);
        }
        catch (Exception exception) {
            this.printError("could not create fingerprint with exception");
            STFTranslator.print(exception);
            this.printInfo("sql: " + string);
            this.registerTemplate("/*STFTranslator:ERROR:could not fingerprint*/ " + string, "/*STFTranslator:ERROR:could not convert*/ " + string, false);
            return false;
        }
        if (string2 == null || string2.trim().equals("")) {
            this.printError("could not create fingerprint");
            this.printInfo("sql: " + string);
            this.registerTemplate("/*STFTranslator:ERROR:could not fingerprint*/ " + string, "/*STFTranslator:ERROR:could not convert*/ " + string, false);
            return false;
        }
        String string3 = null;
        try {
            string3 = this.lookupTemplate(string2);
        }
        catch (SQLException sQLException) {
            this.printError("fingerprint lookup failed with exception");
            STFTranslator.print(sQLException);
            this.printInfo("fingerprint: " + string2);
        }
        if (string3 == null) {
            if (this.m_translate_new_sql) {
                try {
                    string3 = this.convertFingerprint(string2);
                    if (string3 == null) {
                        this.registerTemplate(string2, "/*STFTranslator:ERROR:could not convert*/ " + string2, false);
                        return false;
                    }
                    this.registerTemplate(string2, string3, true);
                }
                catch (Exception exception) {
                    this.printError("fingerprint conversion failed with exception");
                    STFTranslator.print(exception);
                    this.printInfo("fingerprint: " + string2);
                    this.registerTemplate(string2, "/*STFTranslator:ERROR:could not convert*/ " + string2, false);
                    return false;
                }
            } else {
                this.printInfo("fingerprint not found and translate_new_sql=false");
                return false;
            }
        }
        this.Debug("template " + string3);
        String string4 = null;
        try {
            string4 = this.applyLiterals(string3, hashMap);
        }
        catch (Exception exception) {
            this.printError("failed to apply literals with exception");
            STFTranslator.print(exception);
            this.printInfo("sql: " + string);
            return false;
        }
        this.Debug("translated SQL " + string4);
        if (string4 == null || string4.trim().equals("")) {
            this.printError("failed to apply literals");
            this.printInfo("sql: " + string);
            return false;
        }
        try {
            cLOBArray[0] = STFTranslator.stringToCLOB(string4);
        }
        catch (Exception exception) {
            this.printError("failed to set translatedText output with exception");
            STFTranslator.print(exception);
            this.printInfo("target: " + string4);
            return false;
        }
        return true;
    }

    private String applyLiterals(String string, HashMap<String, String> hashMap) {
        if (string != null && hashMap != null) {
            for (String string2 : hashMap.keySet()) {
                String string3 = hashMap.get(string2);
                this.Debug("replace " + string2 + " with " + string3);
                string = string.replace(string2, string3);
            }
        }
        return string;
    }

    protected String convertFingerprint(String string) throws TranslationException, PersistenceException, NoSuchObjectException {
        SchemaDetails schemaDetails;
        String string2 = null;
        TranslateResultWithASTs translateResultWithASTs = null;
        TranslationPreferences translationPreferences = this.getTranslatorPreferences();
        translateResultWithASTs = this.isRepo(m_conn) ? ((schemaDetails = this.getSchemaDetails(m_conn, this.m_profileName)) != null ? RepoTranslationAPI.translate(string, schemaDetails, new PersistenceManager(m_conn), "oracle.dbtools.migration.parser.tsql.TSQLParserMain") : RepoTranslationAPI.translate((String)string, (String)"oracle.dbtools.migration.parser.tsql.TSQLParserMain", (TranslationPreferences)translationPreferences)) : RepoTranslationAPI.translate((String)string, (String)"oracle.dbtools.migration.parser.tsql.TSQLParserMain", (TranslationPreferences)translationPreferences);
        string2 = translateResultWithASTs.getTargetString();
        string2 = this.removeTrailingComma(string2);
        return string2;
    }

    private TranslationPreferences getTranslatorPreferences() {
        TranslationPreferences translationPreferences = new TranslationPreferences();
        translationPreferences.setIs12c(true);
        return translationPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String lookupTemplate(String string) throws SQLException {
        String string2 = null;
        String string3 = "/*+ no_sql_translation */ select st.translated_text from all_sql_translations st, all_objects o where st.owner = o.owner and st.profile_name = o.object_name and o.object_id = ? and dbms_sql_translator.sql_hash(st.sql_text) = dbms_sql_translator.sql_hash(?) and dbms_lob.compare(st.sql_text,?) = 0 and st.enabled = 'TRUE'";
        CLOB cLOB = STFTranslator.stringToCLOB(string);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = m_conn.prepareStatement(string3);
            preparedStatement.setInt(1, this.m_profileID);
            preparedStatement.setClob(2, (Clob)cLOB);
            preparedStatement.setClob(3, (Clob)cLOB);
            resultSet = preparedStatement.executeQuery();
            string2 = resultSet.next() ? STFTranslator.clobToString((CLOB)resultSet.getClob(1)) : null;
            this.Debug("found " + string2 + " for " + string);
        }
        catch (Throwable throwable) {
            STFTranslator.close(resultSet, preparedStatement);
            throw throwable;
        }
        STFTranslator.close(resultSet, preparedStatement);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTemplate(String string, String string2, boolean bl) {
        this.Debug("registering " + string2 + " for " + string);
        CallableStatement callableStatement = null;
        String string3 = "/*+ no_sql_translation */ begin dbms_sql_translator.register_sql_translation(?,?,?," + bl + "); end;";
        try {
            callableStatement = m_conn.prepareCall(string3);
            callableStatement.setString(1, this.m_profileName);
            callableStatement.setClob(2, (Clob)STFTranslator.stringToCLOB(string));
            callableStatement.setClob(3, (Clob)STFTranslator.stringToCLOB(string2));
            callableStatement.execute();
        }
        catch (Exception exception) {
            this.printError("could not register template");
            STFTranslator.print(exception);
        }
        finally {
            this.close(callableStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaDetails getSchemaDetails(Connection connection, String string) {
        String string2 = "/*+ no_sql_translation */ SELECT value from MD_ADDITIONAL_PROPERTIES WHERE PROP_KEY=:targetSchemaName";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        SchemaDetails schemaDetails = null;
        try {
            preparedStatement = connection.prepareStatement(string2);
            String string3 = "BABELFISH:" + string;
            preparedStatement.setString(1, string3);
            resultSet = preparedStatement.executeQuery();
            String string4 = null;
            while (resultSet.next()) {
                string4 = resultSet.getString(1);
                schemaDetails = new SchemaDetails(string4);
            }
            STFTranslator.close(resultSet, preparedStatement);
        }
        catch (Exception exception) {
            STFTranslator.print(exception);
        }
        finally {
            STFTranslator.close(resultSet, preparedStatement);
        }
        return schemaDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRepo(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            if (connection != null) {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("/*+ no_sql_translation */ SELECT REVISION FROM MD_REPOVERSIONS");
                resultSet.next();
                n = resultSet.getInt("REVISION");
            }
        }
        catch (SQLException sQLException) {
            boolean bl = false;
            return bl;
        }
        finally {
            STFTranslator.close(resultSet, statement);
        }
        return true;
    }

    private void Debug(String string) {
    }

    private static String clobToString(CLOB cLOB) throws SQLException {
        Reader reader = cLOB.getCharacterStream();
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[4096];
        try {
            int n;
            while ((n = reader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
        return stringBuffer.toString();
    }

    private static CLOB stringToCLOB(String string) throws SQLException {
        CLOB cLOB = null;
        cLOB = CLOB.createTemporary((Connection)m_conn, (boolean)false, (int)12);
        cLOB.setString(1L, string);
        return cLOB;
    }

    private static void close(ResultSet resultSet, Statement statement) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            STFTranslator.print(exception);
        }
    }

    private void close(CallableStatement callableStatement) {
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (Exception exception) {
            STFTranslator.print(exception);
        }
    }

    private static void verifyDatabaseConnection() {
        try {
            m_conn = DriverManager.getConnection("jdbc:default:connection");
        }
        catch (SQLException sQLException) {
            throw new InternalError(sQLException.getMessage());
        }
    }

    private String removeTrailingComma(String string) {
        if ((string = string.trim()).startsWith("CREATE OR REPLACE PACKAGE") || string.startsWith("CREATE OR REPLACE PROCEDURE") || string.startsWith("CREATE OR REPLACE FUNCTION") || string.startsWith("CREATE OR REPLACE TRIGGER") || string.startsWith("DECLARE") || string.startsWith("BEGIN")) {
            return string;
        }
        return string.endsWith(";") ? string.substring(0, string.length() - 1) : string;
    }

    protected static void print(Exception exception) {
        System.out.println(exception.getLocalizedMessage());
        exception.printStackTrace();
    }

    protected void printError(String string) {
        System.out.println(STFERROR + string + "*/");
    }

    protected void printInfo(String string) {
        System.out.println(STFINFO + string + "*/");
    }

    private static int getProfileID() {
        int n;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            String string = "/*+ no_sql_translation */ select sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_ID') from dual";
            preparedStatement = m_conn.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new InternalError("sys_context('USERENV', 'SQL_TRANSLATION_PROFILE_ID') not available");
            }
            n = resultSet.getInt(1);
        }
        catch (SQLException sQLException) {
            try {
                throw new InternalError(sQLException.getMessage());
            }
            catch (Throwable throwable) {
                STFTranslator.close(resultSet, preparedStatement);
                throw throwable;
            }
        }
        STFTranslator.close(resultSet, preparedStatement);
        return n;
    }

    public static boolean translateError(int n, int[] nArray, String[] stringArray) {
        nArray[0] = 0;
        stringArray[0] = "00000";
        return false;
    }

    static {
        _callingSchema = null;
    }
}

