/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.dbtools.metadata.persistence.CloseableResultSet;

public class PersistenceManager {
    private Connection m_conn;
    private Hashtable<String, PreparedStatement> m_preparedStatementCache;
    private int m_cacheHitCount;
    private int m_cacheMissCount;

    public PersistenceManager(Connection connection) {
        this.m_conn = connection;
        this.m_preparedStatementCache = new Hashtable();
        this.m_cacheHitCount = 0;
        this.m_cacheMissCount = 0;
    }

    public Connection getConn() {
        return this.m_conn;
    }

    public void commit() throws SQLException {
        if (this.m_conn != null && !this.m_conn.getAutoCommit()) {
            this.m_conn.commit();
        }
    }

    public void rollback() throws SQLException {
        this.m_conn.rollback();
    }

    public PreparedStatement getPreparedStatement(String string) throws SQLException {
        return this.getPreparedStatement(string, null);
    }

    public PreparedStatement getPreparedStatement(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement = this.getPreparedStatementCache().get(string);
        if (preparedStatement == null) {
            ++this.m_cacheMissCount;
            preparedStatement = stringArray == null ? this.getConn().prepareStatement(string) : this.getConn().prepareStatement(string, stringArray);
            this.m_preparedStatementCache.put(string, preparedStatement);
        } else {
            ++this.m_cacheHitCount;
        }
        return preparedStatement;
    }

    public String debugCache() {
        if (this.m_cacheMissCount + this.m_cacheHitCount == 0) {
            return String.format("Cache contains %d items.  Hit count=%d, Miss count=%d", this.m_preparedStatementCache.size(), this.m_cacheHitCount, this.m_cacheMissCount);
        }
        return String.format("Cache contains %d items.  Hit count=%d, Miss count=%d, ratio=%2.4f%%", this.m_preparedStatementCache.size(), this.m_cacheHitCount, this.m_cacheMissCount, Float.valueOf(100.0f * (float)this.m_cacheHitCount / (float)(this.m_cacheMissCount + this.m_cacheHitCount)));
    }

    public void releaseCache() {
        if (this.m_preparedStatementCache != null) {
            for (PreparedStatement preparedStatement : this.m_preparedStatementCache.values()) {
                CloseableResultSet.close(preparedStatement, null);
            }
        }
        this.m_preparedStatementCache = null;
        this.m_cacheHitCount = 0;
        this.m_cacheMissCount = 0;
    }

    private void refreshOracleCursors() {
        try {
            PreparedStatement preparedStatement = this.getPreparedStatement("select 'dummy cursor to refresh' from dual");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.close();
            resultSet = null;
            preparedStatement.close();
            preparedStatement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Hashtable<String, PreparedStatement> getPreparedStatementCache() {
        if (this.m_preparedStatementCache == null) {
            this.m_preparedStatementCache = new Hashtable();
            this.m_cacheHitCount = 0;
            this.m_cacheMissCount = 0;
        }
        return this.m_preparedStatementCache;
    }
}

