/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.createRepository;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.migration.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;

public final class RepositoryRegistry {
    private static final String KEY_PACKAGE = Messages.getString("RepositoryRegistry.0");
    private static final String KEY_TYPE = Messages.getString("RepositoryRegistry.1");
    private static final String KEY_SEQUENCE = Messages.getString("RepositoryRegistry.2");
    private static final String KEY_VIEW = "VIEW";
    private static final String KEY_TABLE = "TABLE";
    private static final String KEY_MATERIALIZED_VIEW = "MATERIALIZED VIEW";
    private static final String KEY_STAGE_OBJECT = "STAGE OBJECT";
    private static List<RegistryData> s_repoEntityList = new ArrayList<RegistryData>();

    private RepositoryRegistry() {
    }

    public static boolean dropRepository(Connection connection, AbstractMigrationProgressRunnable abstractMigrationProgressRunnable) {
        boolean bl = true;
        try {
            Statement statement = connection.createStatement();
            for (int i = 0; i < s_repoEntityList.size(); ++i) {
                RegistryData registryData = s_repoEntityList.get(i);
                try {
                    String string = "DROP " + registryData.getId() + " " + registryData.getValue();
                    if (KEY_TABLE.equals(registryData.getId())) {
                        string = string + " CASCADE CONSTRAINTS";
                    }
                    abstractMigrationProgressRunnable.updateProgress(i * 100 / s_repoEntityList.size(), "", Messages.getString("RepositoryRegistry.69") + registryData.getId() + " " + registryData.getValue());
                    statement.executeUpdate(string);
                    continue;
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == 942 || sQLException.getErrorCode() == 4043 || sQLException.getErrorCode() == 2289) continue;
                    bl = false;
                    MigrationLogUtil.logThrowable(sQLException.getMessage(), MigrationAddinArb.getString("REPOSITORY_DROP_TITLE"), (Throwable)sQLException);
                }
            }
        }
        catch (SQLException sQLException) {
            MigrationLogUtil.logThrowable(sQLException.getMessage(), new Object[0], (Throwable)sQLException);
            bl = false;
        }
        if (bl) {
            abstractMigrationProgressRunnable.updateProgress(100, "", MigrationAddinArb.getString("REPOSITORY_REMOVED"));
        }
        return bl;
    }

    public static boolean dropRepository(Connection connection, IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) throws ExecutionException {
        boolean bl;
        block5: {
            bl = true;
            try {
                Statement statement = connection.createStatement();
                for (int i = 0; i < s_repoEntityList.size(); ++i) {
                    RegistryData registryData = s_repoEntityList.get(i);
                    String string = "DROP " + registryData.getId() + " " + registryData.getValue();
                    if (KEY_TABLE.equals(registryData.getId())) {
                        string = string + " CASCADE CONSTRAINTS";
                    }
                    iRaptorTaskProgressUpdater.getDescriptor().setMessage(Messages.getString("RepositoryRegistry.69") + (registryData.getId() == null ? "" : registryData.getId()) + " " + (registryData.getValue() == null ? "" : registryData.getValue()));
                    statement.executeUpdate(string);
                }
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() == 942 || sQLException.getErrorCode() == 4043 || sQLException.getErrorCode() == 2289) break block5;
                bl = false;
                MigrationLogUtil.logThrowable(sQLException.getMessage(), MigrationAddinArb.getString("REPOSITORY_DROP_TITLE"), (Throwable)sQLException);
            }
        }
        if (bl) {
            iRaptorTaskProgressUpdater.getDescriptor().setMessage(MigrationAddinArb.getString("REPOSITORY_REMOVED"));
        }
        return bl;
    }

    static {
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_TABLES"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_SCHEMA"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_CATALOGS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_CONNECTIONS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_VIEWS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_STORED_PROGRAMS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_VIEW_TRIGGERS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_TABLE_TRIGGERS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_CAPTURED_SQL"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_CATALOG_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_SCHEMA_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_TABLES_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_PROGRAMS_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_VIEW_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_COLUMN_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_COLUMNDT_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_DERIVED_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_CONSTRAINTS_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_INDEX_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_TRIGGER_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_PARTITIONS_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_ALL_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_DERIVATIVES"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_SCRATCH_DERIVATIVES"));
        s_repoEntityList.add(new RegistryData(KEY_VIEW, "MGV_IDENTIFIER_DELIMITER"));
        s_repoEntityList.add(new RegistryData(KEY_SEQUENCE, "DBOBJECTID_SEQUENCE"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_PROJECTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_CONNECTIONS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_USERS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_SCHEMAS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_TABLES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_VIEWS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_INDEXES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_COLUMNS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_PARTITIONS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_INDEX_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_GROUPS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_GROUP_MEMBERS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_PRIVILEGES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_USER_DEFINED_DATA_TYPES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_TRIGGERS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_STORED_PROGRAMS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_TABLESPACES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_ADDITIONAL_PROPERTIES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_DERIVATIVES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_SEQUENCES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_PACKAGES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_OTHER_OBJECTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_SYNONYMS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_REPOVERSIONS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_CONSTRAINTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_CONSTRAINT_DETAILS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_CATALOGS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MIGRLOG"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_GROUP_PRIVILEGES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_USER_PRIVILEGES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MIGR_DATATYPE_TRANSFORM_MAP"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MIGR_DATATYPE_TRANSFORM_RULE"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_MIGR_PARAMETER"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_MIGR_DEPENDENCY"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MIGR_GENERATION_ORDER"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_REGISTRY"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_MIGR_WEAKDEP"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MIGRATION_RESERVED_WORDS"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_FILTER_SET"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_FILTER"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "NAMELIST"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "NAME_AND_COUNT_ARRAY"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "NAME_AND_COUNT_T"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "OBJECTIDLIST"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_REPORT_DETAIL_TABLE"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_REPORT_DETAIL_ROW"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_REPORT_SUM_TABLE"));
        s_repoEntityList.add(new RegistryData(KEY_TYPE, "MIGR_REPORT_SUM_ROW"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_APPLICATIONS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_APPLICATIONFILES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_FILE_ARTIFACTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_NUMROW$SOURCE"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "MD_NUMROW$TARGET"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "MD_META"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "MIGRATION_TRANSFORMER"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "MIGRATION"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "MIGRATION_REPORT"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_MIGRLOG"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SERVERDETAIL"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_CHECK_CONSTRAINTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_COLUMNS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_DATABASES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_DB_PRINCIPALS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_DB_ROLE_MEMBERS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_DT_CONSTRAINTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_FN_KEYS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_FN_KEY_COLUMNS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_IDENTITY_COLUMNS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_INDEXES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_INDEX_COLUMNS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_OBJECTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_SCHEMAS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_SCHEMATA"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_SERVER_PRINCIPALS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_SQL_MODULES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_SYSPROPERTIES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_TABLES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_TABLE_PRIVILEGES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SS2K5_TYPES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SYB12_SYSCOLUMNS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SYB12_SYSCOMMENTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SYB12_SYSCONSTRAINTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SYB12_SYSDATABASES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SYB12_SYSINDEXES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SYB12_SYSOBJECTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SYB12_SYSREFERENCES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SYB12_SYSTYPES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_SYB12_SYSUSERS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_ALL_RI_PARENTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_COLUMNS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_DATABASES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_FKEYS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_IDXCONSTRAINTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_INDICES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_JOININDICES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_LOG"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_PROCEDURES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_SHOWTBLCHECKS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_TABLES"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_TABLETEXT"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_TRIGGERS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TERADATA_UDTS"));
        s_repoEntityList.add(new RegistryData(KEY_TABLE, "STAGE_TRANSLATEDSQL"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "SS2K5ALLPLATFORM"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "SYB12ALLPLATFORM"));
        s_repoEntityList.add(new RegistryData(KEY_PACKAGE, "TDALLPLATFORM"));
    }

    private static final class RegistryData {
        private final String _id;
        private final String _value;

        public RegistryData(String string, String string2) {
            this._id = string;
            this._value = string2;
        }

        public String getId() {
            return this._id;
        }

        public String getValue() {
            return this._value;
        }
    }
}

