/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.wizard;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ide.Service;
import javax.ide.command.Context;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.spi.ProviderNotFoundException;
import javax.ide.util.MetaClass;
import javax.ide.wizard.Wizard;
import javax.ide.wizard.spi.WizardHook;

public class WizardManager
extends Service {
    private final Map _wizardInstancesById = new HashMap();

    public boolean invokeWizard(Context context, String id) {
        Wizard theWizard = this.findOrCreateWizard(id);
        return theWizard.invoke(context);
    }

    protected final WizardHook getWizardHook() {
        return (WizardHook)ExtensionRegistry.getExtensionRegistry().getHook(WizardHook.ELEMENT);
    }

    private MetaClass getWizardClass(String id) {
        return this.getWizardHook().getWizardInfo(id).getWizardClass();
    }

    protected final Collection getAllWizardClasses() {
        return this.getWizardHook().getAllWizardClasses();
    }

    protected final Wizard findOrCreateWizard(String id) {
        Wizard theWizard = (Wizard)this._wizardInstancesById.get(id);
        if (theWizard == null) {
            MetaClass wizardClass = this.getWizardClass(id);
            if (wizardClass == null) {
                throw new IllegalArgumentException("No such wizard: " + id);
            }
            try {
                theWizard = (Wizard)wizardClass.newInstance();
                this._wizardInstancesById.put(id, theWizard);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create wizard " + id);
            }
        }
        return theWizard;
    }

    public static WizardManager getWizardManager() {
        try {
            return (WizardManager)WizardManager.getService(WizardManager.class);
        }
        catch (ProviderNotFoundException lnfe) {
            lnfe.printStackTrace();
            throw new IllegalStateException("no wizard manager");
        }
    }
}

