/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ide.extension.spi.Stack;

public final class ScopedMap
extends AbstractMap {
    private final Stack _mapStack = new Stack();

    public ScopedMap() {
        this.enterScope();
    }

    void reset() {
        while (this._mapStack.size() > 1) {
            this._mapStack.pop();
        }
    }

    public void enterScope() {
        this._mapStack.push(new HashMap());
    }

    public void exitScope() {
        this._mapStack.pop();
    }

    @Override
    public Object put(Object key, Object value) {
        Map topMap = (Map)this._mapStack.peek();
        return topMap.put(key, value);
    }

    @Override
    public Object get(Object key) {
        for (Map thisMap : this._mapStack) {
            Object o = thisMap.get(key);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        for (Map thisMap : this._mapStack) {
            Object o = thisMap.remove(key);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public void clear() {
        Iterator i = this._mapStack.iterator();
        while (i.hasNext()) {
            ((Map)i.next()).clear();
        }
    }

    @Override
    public Set entrySet() {
        HashSet hs = new HashSet();
        for (Map thisMap : this._mapStack) {
            hs.addAll(thisMap.entrySet());
        }
        return hs;
    }
}

