/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.ide.Identifiable;
import javax.ide.extension.Extension;
import javax.ide.extension.Extension2;
import javax.ide.extension.ExtensionDependency;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.extension.LoaderType;
import javax.ide.extension.PlatformInfo;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.net.URIPath;
import javax.ide.util.Version;

public final class DefaultExtension
implements Extension2,
Identifiable,
Comparable {
    private String _id;
    private String _name;
    private String _rawName;
    private String _rawOwner;
    private Version _version;
    private Version _edkVersion;
    private String _owner;
    private Collection _dependencies = new ArrayList();
    private URIPath _classpath = new URIPath();
    private PlatformInfo _platformInfo;
    private ExtensionSource _source;
    private boolean _cycleDetector = false;
    private Collection<String> _allImports;
    private LoaderType _loaderType = LoaderType.GLOBAL;

    public DefaultExtension() {
    }

    public DefaultExtension(String id) {
        this._id = id;
    }

    public void setSource(ExtensionSource source) {
        this._source = source;
    }

    public ExtensionSource getSource() {
        return this._source;
    }

    @Override
    public String getID() {
        return this._id;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getOwner() {
        return this._owner;
    }

    @Override
    public Version getVersion() {
        return this._version;
    }

    @Override
    public Version getEDKVersion() {
        return this._edkVersion;
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return this._platformInfo;
    }

    @Override
    public Collection<ExtensionDependency> getDependencies() {
        return this._dependencies;
    }

    public Collection<String> getAllImportedExtensions(ExtensionRegistry registry) {
        if (this._allImports == null) {
            HashSet<String> allDependencies = new HashSet<String>();
            this.getAllImportedExtensionsImpl(allDependencies, registry);
            this._allImports = Collections.unmodifiableCollection(allDependencies);
        }
        return this._allImports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllImportedExtensionsImpl(Collection<String> deps, ExtensionRegistry registry) {
        if (this._cycleDetector) {
            return;
        }
        try {
            this._cycleDetector = true;
            for (ExtensionDependency dep : this.getDependencies()) {
                String id = dep.getID();
                Extension ext = registry.findExtension(id);
                if (ext == null || !(ext instanceof DefaultExtension)) continue;
                deps.add(id);
                ((DefaultExtension)ext).getAllImportedExtensionsImpl(deps, registry);
            }
        }
        finally {
            this._cycleDetector = false;
        }
    }

    @Override
    public URIPath getClassPath() {
        return this._classpath;
    }

    String getRawName() {
        return this._rawName;
    }

    void setRawName(String rawName) {
        this._rawName = rawName == null ? "" : rawName.trim();
    }

    String getRawOwner() {
        return this._rawOwner;
    }

    void setRawOwner(String rawOwner) {
        this._rawOwner = rawOwner;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setOwner(String owner) {
        this._owner = owner;
    }

    public void setVersion(Version version) {
        this._version = version;
    }

    public void setEDKVersion(Version edkVersion) {
        this._edkVersion = edkVersion;
    }

    public void setPlatformInfo(PlatformInfo info) {
        this._platformInfo = info;
    }

    public void addDependency(ExtensionDependency dependency) {
        this._dependencies.add(dependency);
    }

    public void setClassPath(URIPath classpath) {
        this._classpath = classpath;
    }

    public String toString() {
        return this.getID() + " " + String.valueOf(this.getVersion());
    }

    public int compareTo(Object o) {
        if (o instanceof Extension) {
            return this.getName().compareTo(((Extension)o).getName());
        }
        return -1;
    }

    public void setPreferredLoader(LoaderType loaderType) {
        if (loaderType == null) {
            throw new NullPointerException("loaderType is null");
        }
        this._loaderType = loaderType;
    }

    @Override
    public LoaderType getPreferredLoader() {
        return this._loaderType;
    }
}

