/*
 * Decompiled with CFR 0.152.
 */
package javax.ide.extension.spi;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ElementVisitorFactory;
import javax.ide.extension.Extension;
import javax.ide.extension.LoaderType;
import javax.ide.extension.spi.DefaultExtension;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.SimpleGlobMatcher;
import javax.ide.net.VirtualFileSystem;
import javax.ide.util.Version;

public abstract class BaseExtensionVisitor
extends ElementVisitor {
    private static final Logger LOG = Logger.getLogger(BaseExtensionVisitor.class.getName());
    public static final ElementName ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "extension");
    protected static final ElementName CLASSPATH_ELEMENT = new ElementName("http://jcp.org/jsr/198/extension-manifest", "classpath");
    static final ElementName HOOKS = new ElementName("http://jcp.org/jsr/198/extension-manifest", "hooks");
    private ElementVisitor _hooksVisitor = this.createHooksVisitor();
    private ElementVisitorFactory _hookVisitorFactory;
    public static final String KEY_EXTENSION_SOURCE = "extSource";
    private static final Version MAX_ESDK_VERSION = new Version("1.0");
    private boolean addedSourceToClassLoader = false;

    private LoaderType loaderTypeFromString(ElementContext context, String loaderTypeString) {
        if (loaderTypeString == null) {
            return LoaderType.GLOBAL;
        }
        if ((loaderTypeString = loaderTypeString.trim()).length() == 0) {
            return LoaderType.GLOBAL;
        }
        try {
            return LoaderType.valueOf(loaderTypeString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.log(context, Level.WARNING, "Unrecognized value for 'loader' attribute: '" + loaderTypeString + "'. Should be 'global' or 'closure'.");
            return LoaderType.GLOBAL;
        }
    }

    protected DefaultExtension processExtension(ElementStartContext context) {
        Version parsedESDKVersion;
        Version parsedVersion;
        this.addedSourceToClassLoader = false;
        String id = context.getAttributeValue("id");
        if (id == null || (id = id.trim()) == "") {
            this.log(context, Level.SEVERE, "Missing required attribute 'id'");
            return null;
        }
        String version = context.getAttributeValue("version");
        if (version == null || (version = version.trim()) == "") {
            this.log(context, Level.SEVERE, "Missing required attribute 'version'");
            return null;
        }
        try {
            parsedVersion = new Version(version);
        }
        catch (NumberFormatException nfe) {
            this.log(context, Level.SEVERE, "Incorrectly formed version: " + version);
            return null;
        }
        String esdkversion = context.getAttributeValue("esdk-version");
        if (esdkversion == null || (esdkversion = esdkversion.trim()) == "") {
            this.log(context, Level.SEVERE, "Missing required attribute 'esdk-version'");
            return null;
        }
        try {
            parsedESDKVersion = new Version(esdkversion);
        }
        catch (NumberFormatException nfe) {
            this.log(context, Level.SEVERE, "Incorrectly formed version: " + esdkversion);
            return null;
        }
        if (parsedESDKVersion.compareTo(MAX_ESDK_VERSION) > 0) {
            this.log(context, Level.SEVERE, "ESDK version " + esdkversion + " is too high. Maximum supported version is " + MAX_ESDK_VERSION);
            return null;
        }
        LoaderType loaderType = this.loaderTypeFromString(context, context.getAttributeValue("loader"));
        DefaultExtension theExtension = new DefaultExtension(id);
        theExtension.setVersion(parsedVersion);
        theExtension.setEDKVersion(parsedESDKVersion);
        theExtension.setSource((ExtensionSource)context.getScopeData().get(KEY_EXTENSION_SOURCE));
        theExtension.setPreferredLoader(loaderType);
        context.getScopeData().put("extension", theExtension);
        context.registerChildVisitor(HOOKS, this._hooksVisitor);
        return theExtension;
    }

    @Override
    public final void end(ElementEndContext end) {
        Extension extension = (Extension)end.getScopeData().get("extension");
        this.extension(end, extension);
        this._addExtensionSourceToClasspath(end);
    }

    protected void extension(ElementContext context, Extension extension) {
    }

    protected static final DefaultExtension getExtension(ElementContext context) {
        return (DefaultExtension)context.getScopeData().get("extension");
    }

    protected static final ExtensionSource getSource(ElementContext context) {
        return (ExtensionSource)context.getScopeData().get(KEY_EXTENSION_SOURCE);
    }

    protected abstract void addToClasspath(ElementContext var1, Extension var2, URI var3);

    protected final void setHookVisitorFactory(ElementVisitorFactory hookFactory) {
        this._hookVisitorFactory = hookFactory;
    }

    protected ElementVisitor createClasspathVisitor() {
        return new ClasspathVisitor();
    }

    public static final Collection<URI> matchWildcard(URI parent, String expression) {
        URI[] children = VirtualFileSystem.getVirtualFileSystem().list(parent);
        if (children == null) {
            return null;
        }
        ArrayList<URI> matching = new ArrayList<URI>();
        SimpleGlobMatcher matcher = new SimpleGlobMatcher(expression);
        for (URI uri : children) {
            String fileName = VirtualFileSystem.getVirtualFileSystem().getFileName(uri);
            if (fileName == null || !matcher.matches(fileName)) continue;
            matching.add(uri);
        }
        LOG.fine("Wildcard " + expression + " expanded to: " + matching);
        return matching;
    }

    protected ElementVisitor createHooksVisitor() {
        return new HooksVisitor();
    }

    private void _addExtensionSourceToClasspath(ElementContext context) {
        if (this.addedSourceToClassLoader) {
            return;
        }
        this.addExtensionSourceToClasspath(context);
        this.addedSourceToClassLoader = true;
    }

    protected void addExtensionSourceToClasspath(ElementContext context) {
        DefaultExtension extension = BaseExtensionVisitor.getExtension(context);
        ExtensionSource source = extension.getSource();
        LOG.fine("Adding source for " + extension.getID() + " to classpath: " + source.getClasspathEntry());
        this.addToClasspath(context, extension, source.getClasspathEntry());
    }

    private final class HooksVisitor
    extends ElementVisitor {
        private HooksVisitor() {
        }

        @Override
        public void start(ElementStartContext context) {
            if (BaseExtensionVisitor.this._hookVisitorFactory != null) {
                context.registerVisitorFactory(BaseExtensionVisitor.this._hookVisitorFactory);
            }
            BaseExtensionVisitor.this._addExtensionSourceToClasspath(context);
        }
    }

    public class ClasspathVisitor
    extends ElementVisitor {
        protected URI getClasspathEntry(String text, ElementEndContext context) {
            return this.resolveURI(context, text);
        }

        private URI resolveURI(ElementContext context, String text) {
            return BaseExtensionVisitor.getSource(context).resolvePath(BaseExtensionVisitor.getExtension(context), text);
        }

        protected boolean acceptClasspathEntry(ElementContext context, URI uri) {
            return true;
        }

        private Collection<URI> getClasspathEntries(String text, ElementEndContext context) {
            if (text == null) {
                return null;
            }
            int posOfWildcard = -1;
            int posOfSeparator = -1;
            for (int i = text.length() - 1; i >= 0; --i) {
                char c = text.charAt(i);
                if (c == '*') {
                    posOfWildcard = i;
                }
                if (c != '/') continue;
                posOfSeparator = i;
                break;
            }
            if (posOfWildcard == -1 || posOfSeparator == -1 || posOfSeparator == text.length() - 1) {
                return null;
            }
            LOG.fine("Procesing wildcard classpath entry: " + text);
            String dirPath = text.substring(0, posOfSeparator);
            String glob = text.substring(posOfSeparator + 1);
            URI parentURI = this.resolveURI(context, dirPath);
            if (!VirtualFileSystem.getVirtualFileSystem().isDirectory(parentURI)) {
                LOG.fine("Parent directory for wildcard entry does not exist: " + parentURI);
                return null;
            }
            return BaseExtensionVisitor.matchWildcard(parentURI, glob);
        }

        @Override
        public final void end(ElementEndContext context) {
            int end;
            String text = context.getText();
            if (text.length() == 0) {
                this.log(context, Level.WARNING, "Empty classpath definition");
                return;
            }
            int start = 0;
            while ((end = text.indexOf(44, start)) >= 0) {
                this.addEntryToClasspath(text.substring(start, end).trim(), context);
                start = end + 1;
            }
            this.addEntryToClasspath(text.substring(start).trim(), context);
        }

        private void addEntryToClasspath(String text, ElementEndContext context) {
            if (text.length() == 0) {
                this.log(context, Level.WARNING, "Empty classpath definition");
                return;
            }
            Collection<URI> expansion = this.getClasspathEntries(text, context);
            if (expansion == null) {
                URI uri = this.getClasspathEntry(text, context);
                if (uri != null) {
                    this.addURIToClasspath(context, BaseExtensionVisitor.getExtension(context), uri);
                }
            } else {
                for (URI uri : expansion) {
                    this.addURIToClasspath(context, BaseExtensionVisitor.getExtension(context), uri);
                }
            }
        }

        private void addURIToClasspath(ElementContext context, Extension ext, URI entry) {
            if (!this.acceptClasspathEntry(context, entry)) {
                return;
            }
            if (ext instanceof DefaultExtension) {
                ext.getClassPath().add(entry);
            }
            BaseExtensionVisitor.this.addToClasspath(context, ext, entry);
        }
    }

    public final class ClasspathsVisitor
    extends ElementVisitor {
        private final ElementVisitor _cpVisitor;

        public ClasspathsVisitor() {
            this._cpVisitor = BaseExtensionVisitor.this.createClasspathVisitor();
        }

        @Override
        public void start(ElementStartContext context) {
            context.registerChildVisitor(CLASSPATH_ELEMENT, this._cpVisitor);
        }
    }
}

