/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.dynalistener;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;
import oracle.jdevimpl.runner.uidebug.debuggee.Debuggee;
import oracle.jdevimpl.runner.uidebug.debuggee.References;
import oracle.jdevimpl.runner.uidebug.debuggee.dynalistener.ListenerFinder;

public final class ProxyListener
implements ContainerListener,
InvocationHandler {
    private int _referenceID = -1;
    private ArrayList _listened;
    private String _listenerTypeName;
    private ProxyListener _root;
    private Component _component;
    private boolean _includeChildren;
    private static final String[] BEAN_PREFIXES = new String[]{"get", "is", "has"};
    private static final Object[] NOARGS = new Object[0];
    private Object _listener;

    public ProxyListener(Component component, String listenerTypeName, boolean includeChildren) {
        this.init(this, component, listenerTypeName, includeChildren);
    }

    private ProxyListener(ProxyListener root, Component component, String listenerTypeName, boolean includeChildren) {
        this.init(root, component, listenerTypeName, includeChildren);
    }

    private void init(ProxyListener root, Component component, String listenerTypeName, boolean includeChildren) {
        this._root = root;
        this._component = component;
        this._listenerTypeName = listenerTypeName;
        this._includeChildren = includeChildren;
        try {
            Class proxyClass = ProxyListener.getListenerClass(this._listenerTypeName);
            Constructor constructor = proxyClass.getConstructor(InvocationHandler.class);
            this._listener = constructor.newInstance(this);
            this.addListener(this._component);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getReferenceID() {
        if (this._referenceID == -1) {
            this._referenceID = References.getInstance().getReference(this);
        }
        return this._referenceID;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Object event = args[0];
        ArrayList properties = ProxyListener.buildProperties(event);
        Component component = this._component;
        Debuggee debuggee = Debuggee.getInstance();
        int rootID = References.getInstance().getReference(this._root._component);
        int componentID = References.getInstance().getReference(component);
        DebugStream stream = debuggee.getStream();
        stream.beginWriteTransaction();
        try {
            stream.writeInt(-1);
            stream.writeInt(100);
            stream.writeInt(rootID);
            stream.writeInt(this.getReferenceID());
            stream.writeInt(componentID);
            stream.writeUTF(methodName);
            int n = properties.size();
            stream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                Object[] pair = (Object[])properties.get(i);
                stream.writeUTF((String)pair[0]);
                stream.writeUTF((String)pair[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        stream.endWriteTransaction();
        return null;
    }

    private void addListener(Component targetComponent) {
        try {
            Object[] methodParameters = new Object[]{this._listener};
            Method method = ListenerFinder.getListenerMethod(targetComponent, "add", this._listenerTypeName);
            method.invoke((Object)targetComponent, methodParameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this._includeChildren && targetComponent instanceof Container) {
            Container container = (Container)targetComponent;
            container.addContainerListener(this);
            int n = container.getComponentCount();
            this._listened = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                Component child = container.getComponent(i);
                ProxyListener proxyListener = new ProxyListener(this._root, child, this._listenerTypeName, true);
                this._listened.add(proxyListener);
            }
        }
    }

    public void removeRootListener() {
        this._root.removeListener();
    }

    private void removeListener() {
        try {
            Method method = ListenerFinder.getListenerMethod(this._component, "remove", this._listenerTypeName);
            Object[] methodParameters = new Object[]{this._listener};
            method.invoke((Object)this._component, methodParameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this._listened != null) {
            for (int i = this._listened.size() - 1; i >= 0; --i) {
                ProxyListener proxyListener = (ProxyListener)this._listened.get(i);
                proxyListener.removeListener();
            }
        }
    }

    @Override
    public void componentAdded(ContainerEvent event) {
        Component child = event.getChild();
        try {
            this.addListener(child);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        if (this._listened != null) {
            Component child = e.getChild();
            for (int i = 0; i < this._listened.size(); ++i) {
                ProxyListener proxyListener = (ProxyListener)this._listened.get(i);
                if (!proxyListener.isListenerFor(child)) continue;
                proxyListener.removeRootListener();
            }
        }
    }

    private boolean isListenerFor(Component child) {
        return child == this._component;
    }

    private static String getBeanPropertyName(String methodName) {
        for (int i = 0; i < BEAN_PREFIXES.length; ++i) {
            char nextChar;
            int prefixLen;
            String prefix = BEAN_PREFIXES[i];
            if (!methodName.startsWith(prefix) || (prefixLen = prefix.length()) >= methodName.length() || !Character.isUpperCase(nextChar = methodName.charAt(prefixLen))) continue;
            return methodName.substring(prefixLen);
        }
        return null;
    }

    private static ArrayList buildProperties(Object event) {
        Class<?> eventClass;
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        for (eventClass = event.getClass(); eventClass != null && (eventClass.getModifiers() & 1) == 0; eventClass = eventClass.getSuperclass()) {
        }
        if (eventClass != null) {
            Method[] methods = eventClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] parameterTypes;
                Method method = methods[i];
                String methodName = method.getName();
                String propertyName = ProxyListener.getBeanPropertyName(methodName);
                if (propertyName == null || "Class".equals(propertyName) || (parameterTypes = method.getParameterTypes()) != null && parameterTypes.length != 0) continue;
                try {
                    String propertyValue;
                    Object returnedValue = method.invoke(event, NOARGS);
                    if (returnedValue instanceof String) {
                        propertyValue = (String)returnedValue;
                    } else if (returnedValue instanceof Integer) {
                        Integer intValue = (Integer)returnedValue;
                        propertyValue = intValue.toString();
                    } else if (returnedValue instanceof Component) {
                        int componentID = References.getInstance().getReference(returnedValue);
                        propertyValue = returnedValue.getClass().getName() + "(" + componentID + ")";
                    } else {
                        propertyValue = "[" + String.valueOf(returnedValue) + "]";
                    }
                    Object[] pair = new Object[]{propertyName, propertyValue};
                    ret.add(pair);
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    private static Class getListenerClass(String listenerTypeName) throws ClassNotFoundException {
        ClassLoader classLoader = ListenerFinder.class.getClassLoader();
        Class<?> listenerClass = classLoader.loadClass(listenerTypeName);
        Class<?> ret = Proxy.getProxyClass(classLoader, listenerClass);
        return ret;
    }
}

