/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.debuggee.dynalistener;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;

public class ListenerFinder {
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String LISTENER = "Listener";

    public static ArrayList findEventTypes(Class cls) {
        ArrayList<String> listenerTypes = new ArrayList<String>();
        try {
            ClassLoader classLoader = cls.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            Class<?> eventListenerClass = classLoader.loadClass("java.util.EventListener");
            Method[] methods = cls.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                String listenerTypeName;
                Class<?> listenerType;
                Class<?>[] parameterTypes;
                Class<?> returnType;
                Method method = methods[i];
                String methodName = method.getName();
                if (!methodName.startsWith(ADD) || !methodName.endsWith(LISTENER) || (returnType = method.getReturnType()) != Void.TYPE || (parameterTypes = method.getParameterTypes()).length != 1 || !(listenerType = parameterTypes[0]).isInterface() || !(listenerTypeName = listenerType.getName()).endsWith(LISTENER) || !eventListenerClass.isAssignableFrom(listenerType)) continue;
                String baseName = ListenerFinder.getBaseName(listenerType);
                if (!(ADD + baseName + LISTENER).equals(methodName)) continue;
                Class[] removeParameterTypes = new Class[]{listenerType};
                try {
                    Method removeMethod = cls.getMethod(REMOVE + baseName + LISTENER, removeParameterTypes);
                    if (removeMethod.getReturnType() != Void.TYPE) continue;
                    listenerTypes.add(listenerTypeName);
                    continue;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cannot find java.util.EventListener");
            e.printStackTrace();
        }
        return listenerTypes;
    }

    public static ArrayList findObjectListeners(Object target) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        Class<?> targetClass = target.getClass();
        Class[] parameterTypes = new Class[]{Class.class};
        Object[] args = new Object[1];
        try {
            Method method = targetClass.getMethod("getListeners", parameterTypes);
            ArrayList listeners = ListenerFinder.findEventTypes(targetClass);
            for (int i = 0; i < listeners.size(); ++i) {
                String listenerClassName = (String)listeners.get(i);
                try {
                    Class<?> listenerInterface;
                    args[0] = listenerInterface = systemClassLoader.loadClass(listenerClassName);
                    try {
                        EventListener[] targetListeners = (EventListener[])method.invoke(target, args);
                        if (targetListeners == null) continue;
                        for (int j = 0; j < targetListeners.length; ++j) {
                            EventListener targetListener = targetListeners[j];
                            Class<?> targetListenerClass = targetListener.getClass();
                            String targetListenerName = targetListenerClass.getName();
                            ret.add(new Object[]{listenerClassName, targetListenerName});
                        }
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        System.err.println("Failed to get listeners: " + listenerClassName);
                        e.printStackTrace();
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        System.err.println("Failed to get listeners: " + listenerClassName);
                        e.printStackTrace();
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        System.err.println("Failed to get listeners: " + listenerClassName);
                        e.printStackTrace();
                        continue;
                    }
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Failed to get listeners: " + listenerClassName);
                    e.printStackTrace();
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static String getBaseName(String listenerTypeName) {
        int dotPos = listenerTypeName.lastIndexOf(46);
        String baseName = listenerTypeName.substring(dotPos + 1);
        return baseName;
    }

    private static String getBaseName(Class listenerType) {
        String name;
        Package listenerPackage = listenerType.getPackage();
        String listenerTypeName = listenerType.getName();
        int packageLen = 0;
        if (listenerPackage != null && (name = listenerPackage.getName()).length() != 0) {
            packageLen = name.length() + 1;
        }
        String baseName = listenerTypeName.substring(packageLen, listenerTypeName.length() - LISTENER.length());
        return baseName;
    }

    static Method getListenerMethod(Component targetComponent, String methodPrefix, String listenerTypeName) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> targetClass = targetComponent.getClass();
        String baseName = ListenerFinder.getBaseName(listenerTypeName);
        String methodName = methodPrefix + baseName;
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        Class<?> listenerInterface = systemClassLoader.loadClass(listenerTypeName);
        Class[] methodParameterTypes = new Class[]{listenerInterface};
        Method method = targetClass.getMethod(methodName, methodParameterTypes);
        return method;
    }
}

