/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.comm.codec;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Hashtable;
import oracle.jdevimpl.runner.uidebug.comm.codec.BufferedImageIOConstants;

public final class BufferedImageReader
implements BufferedImageIOConstants {
    private DataInputStream _stream;

    public BufferedImageReader(DataInputStream stream) {
        this._stream = stream;
    }

    private void read(int[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this._stream.readInt();
        }
    }

    private void read(short[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this._stream.readShort();
        }
    }

    void readCompressed(int[] array) throws IOException {
        int len = array.length;
        int i = 0;
        while (i < len) {
            int subLen = this.readCompressedNumber();
            if (subLen > 0) {
                this.readIdentical(array, i, subLen);
                i += subLen;
                continue;
            }
            this.readDifferent(array, i, -subLen);
            i += -subLen;
        }
    }

    public int readCompressedNumber() throws IOException {
        byte bFirst = this._stream.readByte();
        boolean cont = (bFirst & 0x40) != 0;
        int n = bFirst & 0x3F;
        int shift = 6;
        if (cont) {
            byte b;
            do {
                b = this._stream.readByte();
                int x = b & 0x7F;
                n |= x << shift;
                shift += 7;
            } while ((b & 0x80) != 0);
        }
        return (bFirst & 0x80) == 0 ? n : -n;
    }

    private void readIdentical(int[] array, int at, int len) throws IOException {
        int value = this._stream.readInt();
        Arrays.fill(array, at, at + len, value);
    }

    private void readDifferent(int[] array, int at, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            array[at + i] = this._stream.readInt();
        }
    }

    public BufferedImage read() throws IOException {
        ColorModel colorModel = this.readColorModel();
        WritableRaster raster = this.readWritableRaster();
        Hashtable properties = this.readProperties();
        BufferedImage bufferedImage = new BufferedImage(colorModel, raster, false, properties);
        return bufferedImage;
    }

    private ColorModel readColorModel() throws IOException {
        ColorModel colorModel;
        byte modelType = this._stream.readByte();
        switch (modelType) {
            case 1: {
                colorModel = this.readIndexColorModel();
                break;
            }
            case 2: {
                colorModel = this.readDirectColorModel();
                break;
            }
            case 3: {
                colorModel = this.readComponentColorModel();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported color model: " + modelType);
            }
        }
        return colorModel;
    }

    private IndexColorModel readIndexColorModel() throws IOException {
        int mapSize = this._stream.readInt();
        int pixelSize = this._stream.readInt();
        byte[] rs = new byte[mapSize];
        byte[] gs = new byte[mapSize];
        byte[] bs = new byte[mapSize];
        this._stream.readFully(rs);
        this._stream.readFully(gs);
        this._stream.readFully(bs);
        IndexColorModel indexColorModel = new IndexColorModel(pixelSize, mapSize, rs, gs, bs);
        return indexColorModel;
    }

    private DirectColorModel readDirectColorModel() throws IOException {
        int pixelSize = this._stream.readInt();
        int redMask = this._stream.readInt();
        int greenMask = this._stream.readInt();
        int blueMask = this._stream.readInt();
        DirectColorModel directColorModel = new DirectColorModel(pixelSize, redMask, greenMask, blueMask);
        return directColorModel;
    }

    private ComponentColorModel readComponentColorModel() throws IOException {
        ComponentColorModel componentColorModel = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(this._stream);
            ColorSpace colorSpace = (ColorSpace)objectInputStream.readObject();
            int componentSizeLength = this._stream.readInt();
            int[] componentSize = new int[componentSizeLength];
            this.read(componentSize);
            boolean alpha = this._stream.readBoolean();
            boolean alphaPremultiplied = this._stream.readBoolean();
            int transparency = this._stream.readInt();
            int transferType = this._stream.readInt();
            componentColorModel = new ComponentColorModel(colorSpace, componentSize, alpha, alphaPremultiplied, transparency, transferType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return componentColorModel;
    }

    private WritableRaster readWritableRaster() throws IOException {
        int width = this._stream.readInt();
        int height = this._stream.readInt();
        DataBuffer dataBuffer = this.readDataBuffer();
        SampleModel sampleModel = this.readSampleModel(dataBuffer.getDataType(), width, height);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
        return raster;
    }

    private DataBuffer readDataBuffer() throws IOException {
        DataBuffer dataBuffer;
        byte dataType = this._stream.readByte();
        switch (dataType) {
            case 0: {
                dataBuffer = this.readDataBufferByte();
                break;
            }
            case 2: {
                dataBuffer = this.readDataBufferShort();
                break;
            }
            case 1: {
                dataBuffer = this.readDataBufferUShort();
                break;
            }
            case 3: {
                dataBuffer = this.readDataBufferInt();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported databuffer type: " + dataType);
            }
        }
        return dataBuffer;
    }

    private DataBufferByte readDataBufferByte() throws IOException {
        int numBanks = this._stream.readInt();
        int size = this._stream.readInt();
        byte[][] banks = new byte[numBanks][];
        for (int i = 0; i < numBanks; ++i) {
            byte[] bank = new byte[size];
            banks[i] = bank;
            this._stream.readFully(bank);
        }
        DataBufferByte dataBufferByte = new DataBufferByte(banks, size);
        return dataBufferByte;
    }

    private DataBufferInt readDataBufferInt() throws IOException {
        int numBanks = this._stream.readInt();
        int size = this._stream.readInt();
        int[][] banks = new int[numBanks][];
        for (int i = 0; i < numBanks; ++i) {
            int[] bank = new int[size];
            banks[i] = bank;
            this.readCompressed(bank);
        }
        DataBufferInt dataBufferInt = new DataBufferInt(banks, size);
        return dataBufferInt;
    }

    private DataBufferShort readDataBufferShort() throws IOException {
        int numBanks = this._stream.readInt();
        int size = this._stream.readInt();
        short[][] banks = new short[numBanks][];
        for (int i = 0; i < numBanks; ++i) {
            short[] bank = new short[size];
            banks[i] = bank;
            this.read(bank);
        }
        DataBufferShort dataBufferShort = new DataBufferShort(banks, size);
        return dataBufferShort;
    }

    private DataBufferUShort readDataBufferUShort() throws IOException {
        int numBanks = this._stream.readInt();
        int size = this._stream.readInt();
        short[][] banks = new short[numBanks][];
        for (int i = 0; i < numBanks; ++i) {
            short[] bank = new short[size];
            banks[i] = bank;
            this.read(bank);
        }
        DataBufferUShort dataBufferUShort = new DataBufferUShort(banks, size);
        return dataBufferUShort;
    }

    private SampleModel readSampleModel(int dataType, int width, int height) throws IOException {
        SampleModel model;
        byte modelType = this._stream.readByte();
        switch (modelType) {
            case 1: {
                model = this.readPixelInterleavedSampleModel(dataType, width, height);
                break;
            }
            case 2: {
                model = this.readSinglePixelPackedSampleModel(dataType, width, height);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported sample model: " + modelType);
            }
        }
        return model;
    }

    private PixelInterleavedSampleModel readPixelInterleavedSampleModel(int dataType, int width, int height) throws IOException {
        int scanlistStride = this._stream.readInt();
        int pixelStride = this._stream.readInt();
        int numBands = this._stream.readInt();
        int[] bandOffsets = new int[numBands];
        this.read(bandOffsets);
        PixelInterleavedSampleModel model = new PixelInterleavedSampleModel(dataType, width, height, pixelStride, scanlistStride, bandOffsets);
        return model;
    }

    private SinglePixelPackedSampleModel readSinglePixelPackedSampleModel(int dataType, int width, int height) throws IOException {
        int scanlineStride = this._stream.readInt();
        int maskLength = this._stream.readInt();
        int[] bitMasks = new int[maskLength];
        this.read(bitMasks);
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(dataType, width, height, scanlineStride, bitMasks);
        return singlePixelPackedSampleModel;
    }

    private Hashtable readProperties() throws IOException {
        Hashtable properties;
        int numProp = this._stream.readInt();
        if (numProp != 0) {
            properties = new Hashtable();
            block4: for (int i = 0; i < numProp; ++i) {
                String propertyName = this._stream.readUTF();
                byte propertyType = this._stream.readByte();
                switch (propertyType) {
                    case 1: {
                        Object property = this._stream.readUTF();
                        continue block4;
                    }
                    case 2: {
                        Object property = new Integer(this._stream.readInt());
                        continue block4;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported property type: " + propertyName + " = " + propertyType);
                    }
                }
            }
        } else {
            properties = null;
        }
        return properties;
    }
}

