/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.comm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import oracle.jdevimpl.runner.uidebug.comm.DebugStream;

public final class DebugStreamFactory {
    private DebugStreamFactory() {
    }

    public static DebugStream createServerSocket(int port) {
        DebugStream stream = null;
        try {
            ServerSocket sListen = new ServerSocket(port, 1);
            Socket sTalk = sListen.accept();
            sListen.close();
            stream = DebugStreamFactory.createServerDebugStream(sTalk);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stream;
    }

    public static Thread createServerSocket(int port, ActionListener listener) {
        ServerWaitingThread serverWaitingThread = new ServerWaitingThread(listener);
        if (serverWaitingThread.connect(port)) {
            return serverWaitingThread;
        }
        return null;
    }

    public static DebugStream createClientSocket(InetAddress host, int port) {
        DebugStream stream = null;
        try {
            Socket socket = new Socket(host, port);
            InputStream is = socket.getInputStream();
            OutputStream os = socket.getOutputStream();
            DataInputStream dis = new DataInputStream(is);
            DataOutputStream dos = new DataOutputStream(os);
            stream = new DebugStream(dis, dos);
            stream.setSide(true);
            stream.readHandshake();
            stream.writeHandshake();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stream;
    }

    private static DebugStream createServerDebugStream(Socket sTalk) throws IOException {
        InputStream is = sTalk.getInputStream();
        OutputStream os = sTalk.getOutputStream();
        DebugStream stream = new DebugStream(is, os);
        stream.setSide(false);
        stream.writeHandshake();
        stream.readHandshake();
        return stream;
    }

    private static class ServerWaitingThread
    extends Thread {
        private ActionListener _listener;
        private ServerSocket _listen;

        public ServerWaitingThread(ActionListener listener) {
            this._listener = listener;
        }

        private boolean connect(int port) {
            boolean ret = false;
            try {
                this._listen = new ServerSocket(port, 5);
                ret = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return ret;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        while (true) {
                            Socket sTalk = this._listen.accept();
                            DebugStream stream = DebugStreamFactory.createServerDebugStream(sTalk);
                            ActionEvent event = new ActionEvent(stream, 1001, null);
                            this._listener.actionPerformed(event);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

