/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.uidebug.comm;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.jdevimpl.runner.uidebug.comm.codec.BufferedImageReader;
import oracle.jdevimpl.runner.uidebug.comm.codec.BufferedImageWriter;

public class DebugStream {
    private static final boolean DEBUG_DATA = false;
    private static final boolean DEBUG_SIZE = false;
    private static final boolean DEBUG_IMAGE = false;
    private static final boolean DEBUG_THREAD = false;
    private static final boolean DEBUG = false;
    private DataInputStream _dis;
    private DataOutputStream _dos;
    private boolean _outputLocked;
    private HashMap _sentClasses = new HashMap();
    private ArrayList _receivedClasses = new ArrayList();
    private boolean _rightSide;
    private long _read;
    private long _written;
    private int _nextClassID = 0;

    public DebugStream(InputStream dis, OutputStream dos) {
        this._dis = new DataInputStream(dis);
        this._dos = new DataOutputStream(new BufferedOutputStream(dos));
    }

    public void writeHandshake() throws IOException {
        this.writeInt(91765);
        this.writeInt(3);
        this.flush();
    }

    public void readHandshake() throws IOException {
        int magic = this.readInt();
        if (magic != 91765) {
            throw new IllegalStateException("Invalid magic number");
        }
        int version = this.readInt();
        if (version != 3) {
            throw new IllegalStateException("Invalid protocol version");
        }
    }

    private void debugPrint(String s) {
        this.debugPrint(s, 0, 0);
    }

    private void debugPrint(String s, int read, int written) {
        boolean DEBUG_PRINT = false;
    }

    private void checkThread() {
    }

    public void setSide(boolean rightSide) {
        this._rightSide = rightSide;
    }

    public synchronized void beginWriteTransaction() {
        if (this._outputLocked) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._outputLocked = true;
    }

    public synchronized void endWriteTransaction() {
        try {
            this.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._outputLocked = false;
        this.notify();
    }

    public final void flush() throws IOException {
        this.debugPrint("flush()");
        this._dos.flush();
    }

    public final int readInt() throws IOException {
        this.debugPrint("readInt()...");
        this.checkThread();
        int i = this._dis.readInt();
        this.debugPrint("readInt() = " + i, 4, 0);
        return i;
    }

    public final void writeInt(int i) throws IOException {
        this.debugPrint("writeInt(" + i + ")", 0, 4);
        this._dos.writeInt(i);
    }

    public final boolean readBoolean() throws IOException {
        this.debugPrint("readBoolean()...");
        this.checkThread();
        boolean b = this._dis.readBoolean();
        this.debugPrint("readBoolean() = " + b, 1, 0);
        return b;
    }

    public final void writeBoolean(boolean b) throws IOException {
        this.debugPrint("writeBoolean(" + b + ")", 0, 1);
        this._dos.writeBoolean(b);
    }

    public final String readUTF() throws IOException {
        this.debugPrint("readUTF()...");
        this.checkThread();
        String s = this._dis.readUTF();
        this.debugPrint("readUTF() = " + s, s.length() * 2, 0);
        return s;
    }

    public final void writeUTF(String s) throws IOException {
        this.debugPrint("writeUTF(" + s + ")", 0, s.length() * 2);
        this._dos.writeUTF(s);
    }

    public final byte[] readBytes() throws IOException {
        int size = this.readInt();
        byte[] bytes = new byte[size];
        this._dis.readFully(bytes);
        return bytes;
    }

    public final void writeBytes(byte[] bytes) throws IOException {
        this._dos.writeInt(bytes.length);
        this._dos.write(bytes);
    }

    public final String readClass() throws IOException {
        String ret;
        int classID = this.readInt();
        if (classID >= this._receivedClasses.size()) {
            ret = this.readUTF();
            this._receivedClasses.add(ret);
        } else {
            ret = (String)this._receivedClasses.get(classID);
        }
        return ret;
    }

    public final void writeClass(String sClassName) throws IOException {
        Integer classID = (Integer)this._sentClasses.get(sClassName);
        if (classID == null) {
            classID = new Integer(this._nextClassID++);
            this._sentClasses.put(sClassName, classID);
            this.writeInt(classID);
            this.writeUTF(sClassName);
        } else {
            this.writeInt(classID);
        }
    }

    public final void writeImage(BufferedImage bufferedImage) throws IOException {
        BufferedImageWriter bufferedImageWriter = new BufferedImageWriter(this._dos);
        bufferedImageWriter.write(bufferedImage);
    }

    public final BufferedImage readImage() throws IOException {
        BufferedImage bufferedImage = null;
        BufferedImageReader bufferedImageReader = new BufferedImageReader(this._dis);
        bufferedImage = bufferedImageReader.read();
        return bufferedImage;
    }
}

