/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import oracle.javatools.ui.table.RolloverTableHandler;

public class RolloverTableRenderer
implements TableCellRenderer {
    private TableCellRenderer _baseRenderer;
    private boolean _explicitlySetBackground;

    public RolloverTableRenderer(TableCellRenderer baseRenderer) {
        this.setBaseRenderer(baseRenderer);
    }

    public TableCellRenderer getBaseRenderer() {
        return this._baseRenderer;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean isRollover = this._isTableCellRolloverHighlight(table, row, column);
        if (isSelected && isRollover) {
            isSelected = false;
        }
        boolean setBack = this._explicitlySetBackground;
        TableCellRenderer baseRenderer = this.getBaseRenderer();
        if (baseRenderer == null && (baseRenderer = table.getDefaultRenderer(table.getColumnClass(column))) instanceof DefaultTableCellRenderer) {
            setBack = true;
        }
        Component c = baseRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this._setTableCellRolloverHighlight(table, c, isSelected, setBack, isRollover);
        return c;
    }

    void setBaseRenderer(TableCellRenderer baseRenderer) {
        this._baseRenderer = baseRenderer;
        if (baseRenderer instanceof DefaultTableCellRenderer) {
            this._explicitlySetBackground = true;
        }
    }

    private boolean _isTableCellRolloverHighlight(JTable table, int row, int column) {
        Integer rRow = (Integer)table.getClientProperty("ROLLOVER_ROW");
        Integer rCol = (Integer)table.getClientProperty("ROLLOVER_COLUMN");
        rRow = rRow == null ? -1 : rRow;
        rCol = rCol == null ? -1 : rCol;
        return table.getCellSelectionEnabled() && rRow == row && rCol == column || table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed() && rRow == row || table.getColumnSelectionAllowed() && !table.getRowSelectionAllowed() && rCol == column || table.getCellSelectionEnabled() && rRow == row && rCol == -2 || table.getCellSelectionEnabled() && rRow == -2 && column == rCol;
    }

    private void _setTableCellRolloverHighlight(JTable table, Component c, boolean isSelected, boolean explicitlySetBackground, boolean isRollover) {
        if (isRollover) {
            c.setBackground(RolloverTableHandler.getTableCellRolloverHighlight());
            c.setForeground(table.getForeground());
        } else if (explicitlySetBackground) {
            if (isSelected) {
                c.setBackground(table.getSelectionBackground());
            } else {
                c.setBackground(table.getBackground());
            }
        }
    }
}

