/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.javatools.ui.table.ColumnSelector;
import oracle.javatools.ui.table.DisplayableTable;
import oracle.javatools.ui.table.GenericTableHeaderRenderer;
import oracle.javatools.ui.table.RowHeader;
import oracle.javatools.ui.table.TableHelper;
import oracle.javatools.ui.table.TableUIManager;

public class GenericTable
extends JTable
implements DisplayableTable {
    private boolean _showToolTips = true;
    private boolean _selectAll;
    private Boolean _useTransferHandler = null;
    private Color _sortColumnBackgroundColor = TableUIManager.SORTED_COL_BACK;

    public GenericTable() {
        this._init();
    }

    public GenericTable(TableModel model) {
        super(model);
        this._init();
    }

    public GenericTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this._init();
    }

    public GenericTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this._init();
    }

    public void setColumnSelectorAvailable(boolean isAvailable) {
        TableHelper.setColumnSelectorAvailable(this, isAvailable);
    }

    public boolean isColumnSelectorAvailable() {
        return TableHelper.isColumnSelectorAvailable(this);
    }

    public void setSelectColumnsAction(Action selectColumn) {
        TableHelper.setSelectColumnsAction(this, selectColumn);
    }

    public Action getSelectColumnsAction() {
        return TableHelper.getSelectColumnsAction(this);
    }

    public void setColumnSelectorActions(Action ... actions) {
        TableHelper.setColumnSelectorActions(this, actions);
    }

    public Action[] getColumnSelectorActions() {
        return TableHelper.getColumnSelectorActions(this);
    }

    public void setHiddenColumns(int[] hiddenColumns) {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        cs.setHiddenColumns(hiddenColumns);
    }

    public int[] getHiddenColumns() {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        return cs.getHiddenColumns();
    }

    public void setNoEntryInstructionText(String text) {
        TableHelper.setNoEntryInstructionText(this, text);
    }

    public String getNoEntryInstructionText() {
        return TableHelper.getNoEntryInstructionText(this);
    }

    public void setShowToolTips(boolean showToolTips) {
        this._showToolTips = showToolTips;
    }

    public boolean isShowToolTips() {
        return this._showToolTips;
    }

    public void setResizeColumnOnDoubleClick(boolean isOn) {
        TableHelper.setResizeColumnOnDoubleClick(this, isOn);
    }

    public boolean isResizeColumnOnDoubleClick() {
        return TableHelper.isResizeColumnOnDoubleClick(this);
    }

    public void sizeTableToContents() {
        this.sizeTableToContents(null);
    }

    public void sizeTableToContents(Object[] prototypeValues) {
        TableHelper.sizeTableToContents(this, prototypeValues);
    }

    public void setVisibleRows(int rows) {
        JScrollPane pane = TableHelper.getTableScrollPane(this);
        if (pane != null) {
            TableHelper.setVisibleRows(this, pane, rows);
        }
    }

    public void setPreferredVisibleRowCount(int visibleRowCount) {
        TableHelper.setPreferredVisibleRowCount(this, visibleRowCount);
    }

    public int getPreferredVisibleRowCount() {
        return TableHelper.getPreferredVisibleRowCount(this);
    }

    public void setRowHeader(RowHeader rowHeader) {
        this.putClientProperty("tableRowHeader", rowHeader);
    }

    public RowHeader getRowHeader() {
        return (RowHeader)this.getClientProperty("tableRowHeader");
    }

    public RowHeader createDefaultRowHeader() {
        return new RowHeader(this);
    }

    public void setColumnHeaderSelectionEnabled(boolean select) {
        TableHelper.setColumnHeaderSelectionEnabled(this, select);
    }

    public boolean isColumnHeaderSelectionEnabled() {
        return TableHelper.isColumnHeaderSelectionEnabled(this);
    }

    public void setSelectAllEnabled(boolean enable) {
        if (enable != this.isSelectAllEnabled()) {
            this._selectAll = enable;
            JScrollPane pane = TableHelper.getTableScrollPane(this);
            if (pane != null) {
                TableHelper.setSelectAllEnabled(this, pane, enable);
            }
        }
    }

    public boolean isSelectAllEnabled() {
        return this._selectAll;
    }

    public void setRolloverHighlightingEnabled(boolean highlight) {
        TableHelper.setRolloverHighlightingEnabled(this, highlight);
    }

    public boolean isRolloverHighlightingEnabled() {
        return TableHelper.isRolloverHighlightingEnabled(this);
    }

    public void setUseTransferHandler(boolean useTransferHandler) {
        this._useTransferHandler = useTransferHandler;
        this._updateTransferHandler();
    }

    public boolean getUseTransferHandler() {
        return this._useTransferHandler == null || this._useTransferHandler != false;
    }

    public void setSortColumnBackgroundColor(Color c) {
        if (c != this._sortColumnBackgroundColor) {
            this._sortColumnBackgroundColor = c;
            this.repaint();
        }
    }

    public Color getSortColumnBackgroundColor() {
        return this._sortColumnBackgroundColor;
    }

    @Override
    public String convertValueToText(Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return null;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        JScrollPane scrollPane = TableHelper.getTableScrollPane(this);
        if (scrollPane != null) {
            JViewport viewport = scrollPane.getViewport();
            if (this.isSelectAllEnabled()) {
                TableHelper.setSelectAllEnabled(this, scrollPane, this.isSelectAllEnabled());
            }
            scrollPane.setOpaque(true);
            viewport.setOpaque(true);
            scrollPane.setBackground(this.getBackground());
            viewport.setBackground(this.getBackground());
            Border border = scrollPane.getBorder();
            if (border == null || border instanceof UIResource) {
                scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            }
            scrollPane.setCorner("LOWER_RIGHT_CORNER", new JPanel());
            RowHeader rowHeader = this.getRowHeader();
            if (rowHeader != null) {
                scrollPane.setRowHeaderView(rowHeader);
            }
        }
    }

    @Override
    protected void unconfigureEnclosingScrollPane() {
        super.unconfigureEnclosingScrollPane();
        JScrollPane scrollPane = TableHelper.getTableScrollPane(this);
        if (scrollPane != null) {
            RowHeader rowHeader;
            if (this.isSelectAllEnabled()) {
                TableHelper.setSelectAllEnabled(this, scrollPane, false);
            }
            if ((rowHeader = this.getRowHeader()) != null) {
                scrollPane.setRowHeaderView(null);
            }
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String tip;
        if (!this._showToolTips) {
            return super.getToolTipText(event);
        }
        Point mousePos = event.getPoint();
        int column = this.columnAtPoint(mousePos);
        int row = this.rowAtPoint(mousePos);
        if (column != -1 && row != -1 && (tip = TableHelper.getTruncatedCellValue(this, row, column)) != null) {
            return tip;
        }
        return super.getToolTipText(event);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (!this.isPreferredSizeSet() && this.getRowCount() == 0) {
            size.height = TableHelper.getNoEntryDefaultHeight(this);
        }
        return size;
    }

    @Override
    public void paintComponent(Graphics g) {
        List<RowSorter.SortKey> sortKeys;
        super.paintComponent(g);
        RowSorter<? extends TableModel> sorter = this.getRowSorter();
        if (sorter != null && (sortKeys = sorter.getSortKeys()).size() > 0) {
            int column = this.convertColumnIndexToView(sortKeys.get(0).getColumn());
            switch (sortKeys.get(0).getSortOrder()) {
                case ASCENDING: 
                case DESCENDING: {
                    Rectangle rect = this.getCellRect(this.getRowCount() - 1, column, true);
                    Color c = this.getSortColumnBackgroundColor();
                    if (c == null) {
                        c = TableUIManager.SORTED_COL_BACK;
                    }
                    g.setColor(c);
                    g.fillRect(rect.x, rect.y + rect.height, rect.width, this.getHeight());
                }
            }
        }
    }

    @Override
    public void setUI(TableUI ui) {
        super.setUI(ui);
        if (this._useTransferHandler == null) {
            this._useTransferHandler = Boolean.TRUE;
        }
        this._updateTransferHandler();
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        if (columnClass == null) {
            return super.getDefaultRenderer(Object.class);
        }
        return super.getDefaultRenderer(columnClass);
    }

    @Override
    public void selectAll() {
        TableHelper.stopCellEditing(this);
        super.selectAll();
    }

    protected void setColumnVisible(TableColumn column, int modelColumn, boolean isVisible) {
        ColumnSelector cs = TableHelper.getColumnSelector(this);
        cs.setColumnVisible(column, modelColumn, isVisible);
    }

    @Override
    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        TableHelper.installGenericTableRenderer(this);
    }

    private void _init() {
        this.setAutoResizeMode(4);
        JTableHeader header = this.getTableHeader();
        if (header != null) {
            header.setDefaultRenderer(new GenericTableHeaderRenderer());
        }
        this.setFillsViewportHeight(true);
        this.setRolloverHighlightingEnabled(true);
        this.setColumnHeaderSelectionEnabled(true);
        this.setGridColor(TableUIManager.TABLE_GRID_COLOR);
        this.setResizeColumnOnDoubleClick(true);
        this.setRowHeight(TableHelper.getDefaultRowHeight());
    }

    private void _updateTransferHandler() {
        if (this._useTransferHandler.booleanValue()) {
            TableHelper.installTableTransferHandler(this, false);
        } else {
            this.setTransferHandler(null);
        }
    }
}

