/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchProgress;
import oracle.javatools.ui.search.SlideTip;
import org.jdesktop.animation.timing.Cycle;
import org.jdesktop.animation.timing.Envelope;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingTarget;

public final class SearchField
extends JPanel {
    private static final Color PROGRESS_BAR_COLOR = new Color(206, 223, 247);
    private static final int INDETERMINATE_RECT_WIDTH = 50;
    private static final Insets BORDER_INSETS = new Insets(2, 8, 2, 8);
    private static final Color BORDER_COLOR = new Color(132, 130, 132);
    private final JPanel _searchPanel;
    private final JButton _searchButton = new JButton();
    private final PromptedTextField _textField;
    private final JPanel _insideFieldButtonPanel = new JPanel();
    private final JPanel _outsideFieldButtonPanel = new JPanel();
    private final CancelButton _cancelButton = new CancelButton();
    private final JButton _previousButton = new JButton();
    private final JButton _nextButton = new JButton();
    private final List<SearchCategory> _categories = new ArrayList<SearchCategory>();
    private final List<JMenuItem> _extraItems = new ArrayList<JMenuItem>();
    private transient SearchCategory _selectedCategory;
    private final Timer _searchTimer;
    private String _lastSearch;
    private final List<SearchListener> _listeners = new CopyOnWriteArrayList<SearchListener>();
    private Style _style;
    private TypingDelay _typingDelay;
    private JPopupMenu categoryMenu = new JPopupMenu();
    private boolean _allowEmptySearch = false;
    private boolean _isSearching = false;
    private boolean _isAdjusting = false;
    private transient SearchProgress _searchProgress;
    private float _indeterminateProgress = -1.0f;
    private final Action _clearAction;
    private final Action _findNextAction;
    private final Action _findPreviousAction;
    private final Action _categoryDropDownAction;
    private Component _keyEventTargetComponent;
    private boolean _notifyOnEmptySearch = false;
    private boolean _autoFind = false;
    private static final String CATEGORY_DROP_DOWN_ACTION_ID = "categoryDropDownAction";
    private static final String FIND_NEXT_ACTION_ID = "findNextAction";
    private static final String FIND_PREVIOUS_ACTION_ID = "findPreviousAction";
    private static final String CLEAR_ACTION_ID = "clearAction";
    private transient SlideTip _searchWrappedTip = new SlideTip();
    private transient SlideTip _searchFailedTip = new SlideTip();

    public SearchField() {
        this(new PromptedTextField(), true);
    }

    public SearchField(Style style) {
        this(new PromptedTextField(), true);
        this.setStyle(style);
    }

    public SearchField(PromptedTextField textField) {
        this(textField, true);
    }

    public SearchField(PromptedTextField textField, Style style) {
        this(textField, true);
        this.setStyle(style);
    }

    private SearchField(PromptedTextField textField, boolean buttonsInsideField) {
        this._textField = textField;
        this._textField.setMinimumSize(new Dimension(25, 0));
        this._clearAction = this.createClearAction();
        this._findNextAction = this.createFindNextAction();
        this._findPreviousAction = this.createFindPreviousAction();
        this._categoryDropDownAction = this.createCategoryDropDownAction();
        this._cancelButton.setAction(this._clearAction);
        this._nextButton.setAction(this._findNextAction);
        this._previousButton.setAction(this._findPreviousAction);
        this.setPopDownAction(this._categoryDropDownAction);
        this._searchButton.putClientProperty(UIConstants.VETO_CONVERSION, true);
        this._cancelButton.putClientProperty(UIConstants.VETO_CONVERSION, true);
        this._nextButton.putClientProperty(UIConstants.VETO_CONVERSION, true);
        this._previousButton.putClientProperty(UIConstants.VETO_CONVERSION, true);
        this._searchPanel = new JPanel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                int height = this.getHeight();
                int width = this.getWidth();
                Object oldAAValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                try {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    GeneralPath areaPath = new GeneralPath();
                    areaPath.append(new Arc2D.Double(0.0, 0.0, BORDER_INSETS.left * 2 - 1, height - 1, 90.0, 180.0, 0), true);
                    areaPath.lineTo(0 + width - BORDER_INSETS.right - 2, 0 + height - 1);
                    areaPath.append(new Arc2D.Double(0 + width - BORDER_INSETS.right * 2 - 1, 0.0, BORDER_INSETS.right * 2 - 1, height - 1, 270.0, 180.0, 0), true);
                    areaPath.lineTo(0 + BORDER_INSETS.left, 0.0f);
                    g2d.setColor(UIManager.getColor("TextArea.background"));
                    g2d.fill(areaPath);
                    if (SearchField.this._searchProgress != null) {
                        Shape oldClip = g2d.getClip();
                        try {
                            g2d.setClip(areaPath);
                            g.setColor(PROGRESS_BAR_COLOR);
                            if (SearchField.this._searchProgress.isDeterminate()) {
                                double pctComplete = (double)SearchField.this._searchProgress.getProgress() / (double)SearchField.this._searchProgress.getTotalSteps();
                                int progressBarWidth = (int)((double)width * pctComplete);
                                g.fillRect(0, 0, progressBarWidth, height);
                            } else if (SearchField.this._indeterminateProgress >= 0.0f) {
                                int x = (int)((float)width * SearchField.this._indeterminateProgress);
                                g.fillRect(x, 0, 50, height);
                            }
                        }
                        finally {
                            g2d.setClip(oldClip);
                        }
                    }
                    g2d.setColor(BORDER_COLOR);
                    g2d.draw(areaPath);
                }
                finally {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAValue);
                }
                super.paintComponent(g);
            }
        };
        this._textField.setOpaque(false);
        this.setOpaque(false);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this._searchPanel, "Center");
        if (!buttonsInsideField) {
            this.add((Component)this._outsideFieldButtonPanel, "East");
        }
        this._searchPanel.setBorder(new EmptyBorder(BORDER_INSETS));
        this.updateUI();
        this._textField.setBorder(null);
        this._searchPanel.setOpaque(false);
        this._searchPanel.setLayout(new BorderLayout(0, 0));
        this._searchPanel.add((Component)this._searchButton, "West");
        this._searchPanel.add((Component)this._textField, "Center");
        if (buttonsInsideField) {
            JPanel tmp = new JPanel();
            tmp.setLayout(new BorderLayout());
            tmp.setOpaque(false);
            tmp.add((Component)this._insideFieldButtonPanel, "West");
            tmp.add((Component)this._outsideFieldButtonPanel, "East");
            this._searchPanel.add((Component)tmp, "East");
        } else {
            this._searchPanel.add((Component)this._insideFieldButtonPanel, "East");
        }
        this._insideFieldButtonPanel.setLayout(new BoxLayout(this._insideFieldButtonPanel, 0));
        this._insideFieldButtonPanel.setOpaque(false);
        this._insideFieldButtonPanel.add(this._cancelButton);
        this._outsideFieldButtonPanel.setLayout(new BoxLayout(this._outsideFieldButtonPanel, 0));
        this._outsideFieldButtonPanel.setOpaque(false);
        this._cancelButton.setHidden(false);
        this._nextButton.setVisible(false);
        this._previousButton.setVisible(false);
        this.configureIconicButton(this._searchButton);
        this.configureIconicButton(this._cancelButton, OracleIcons.getIcon((String)"delete.png"), UIBundle.get("CLEAR_SEARCH"));
        this.configureIconicButton(this._previousButton, OracleIcons.getIcon((String)"previous.png"), UIBundle.get("PREVIOUS_MATCH"));
        this._outsideFieldButtonPanel.add(this._nextButton);
        this._outsideFieldButtonPanel.add(this._previousButton);
        ActionListener timerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SearchField.this.isFiringEventsOnKeypress()) {
                    SearchField.this.fireSearchPerformed(SearchEvent.Direction.FORWARD, true);
                }
            }
        };
        this._searchTimer = new Timer(0, timerListener);
        this._searchTimer.setRepeats(false);
        this._searchTimer.setCoalesce(true);
        this.setStyle(Style.FILTER);
        this.setTypingDelay(TypingDelay.FAST);
        this._textField.getDocument().addDocumentListener(new DocumentListener(){

            private void update() {
                if (SearchField.this._isAdjusting) {
                    return;
                }
                if (SearchField.this.isFiringEventsOnKeypress()) {
                    SearchField.this._searchTimer.stop();
                    SearchField.this._searchTimer.start();
                } else {
                    SearchField.this.updateButtons();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }
        });
        this._searchButton.setBorder(new EmptyBorder(0, 0, 0, 3));
        this.installKeyboard();
        this.addPropertyChangeListener("allowEmptySearch", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SearchField.this.updateButtons();
            }
        });
    }

    public void setNotifyOnEmptySearch(boolean notifyOnEmptySearch) {
        this._notifyOnEmptySearch = notifyOnEmptySearch;
    }

    public void setKeyEventTargetComponent(Component c) {
        if (c == this._keyEventTargetComponent) {
            return;
        }
        Component old = this._keyEventTargetComponent;
        this._keyEventTargetComponent = c;
        this.firePropertyChange("keyEventTargetComponent", old, c);
    }

    public Component getKeyEventTargetComponent() {
        return this._keyEventTargetComponent;
    }

    @Override
    public void setForeground(Color color) {
        if (this.getTextField() != null) {
            this.getTextField().setForeground(color);
        }
    }

    private boolean isFiringEventsOnKeypress() {
        return this.getStyle() == Style.FILTER || this.isAutoFind() && this.getStyle() == Style.FIND;
    }

    private void installKeyboard() {
        this.installFindNextKeyStroke(KeyStroke.getKeyStroke("ENTER"));
        this.installFindNextKeyStroke(KeyStroke.getKeyStroke("DOWN"));
        this.installFindPreviousKeyStroke(KeyStroke.getKeyStroke("shift ENTER"));
        this.installFindPreviousKeyStroke(KeyStroke.getKeyStroke("UP"));
        this.getActionMap().put(FIND_NEXT_ACTION_ID, this._findNextAction);
        this.getActionMap().put(FIND_PREVIOUS_ACTION_ID, this._findPreviousAction);
        this.getActionMap().put(CLEAR_ACTION_ID, this._clearAction);
    }

    public void installFindNextKeyStroke(KeyStroke keyStroke) {
        this.getInputMap(1).put(keyStroke, FIND_NEXT_ACTION_ID);
    }

    public void installFindPreviousKeyStroke(KeyStroke keyStroke) {
        this.getInputMap(1).put(keyStroke, FIND_PREVIOUS_ACTION_ID);
    }

    private Action createClearAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SearchField.this.getStyle() == Style.FILTER) {
                    SearchField.this.clear();
                }
            }
        };
    }

    private Action createFindNextAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchField.this.getStyle() == Style.FIND) {
                    SearchField.this.fireSearchPerformed(SearchEvent.Direction.FORWARD, false);
                } else if (SearchField.this.getStyle() == Style.SEARCH) {
                    if (SearchField.this._isSearching) {
                        if (SearchField.this._searchProgress == null) {
                            throw new IllegalStateException("No progress object while searching!");
                        }
                        SearchField.this._searchProgress.setStopped(true);
                        SearchField.this._nextButton.setEnabled(false);
                    } else {
                        SearchField.this.fireSearchPerformed(SearchEvent.Direction.FORWARD, false);
                    }
                }
            }
        };
    }

    private Action createFindPreviousAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchField.this.getStyle() == Style.FILTER) {
                    return;
                }
                SearchField.this.fireSearchPerformed(SearchEvent.Direction.BACKWARD, false);
            }
        };
    }

    private Action createCategoryDropDownAction() {
        AbstractAction a = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchField.this._categories.isEmpty() && SearchField.this._extraItems.isEmpty()) {
                    return;
                }
                SearchField.this.categoryMenu.removeAll();
                if (!SearchField.this._categories.isEmpty()) {
                    ButtonGroup bg = new ButtonGroup();
                    for (SearchCategory c : SearchField.this._categories) {
                        JRadioButtonMenuItem item = new JRadioButtonMenuItem(new SearchCategoryAction(c));
                        bg.add(item);
                        SearchField.this.categoryMenu.add(item);
                        item.setSelected(SearchField.this._selectedCategory == c);
                    }
                }
                if (!SearchField.this._categories.isEmpty() && !SearchField.this._extraItems.isEmpty()) {
                    SearchField.this.categoryMenu.addSeparator();
                }
                for (JMenuItem item : SearchField.this._extraItems) {
                    SearchField.this.categoryMenu.add(item);
                }
                SearchField.this.categoryMenu.show(SearchField.this._searchButton, 0, SearchField.this._searchButton.getHeight());
            }
        };
        a.putValue("SmallIcon", OracleIcons.getIcon((String)"find.png"));
        return a;
    }

    public void showSearchWrapped() {
        this._searchWrappedTip.setText("The find wrapped");
        this._searchWrappedTip.show(this._textField.getBounds().x, this, 3000);
    }

    public void showSearchFailed() {
        this._searchFailedTip.setIcon(OracleIcons.getIcon((String)"warning.png"));
        this._searchFailedTip.setText("Not found");
        this._searchFailedTip.show(this._textField.getBounds().x, this, 5000);
    }

    public JPopupMenu getCategoriesPopup() {
        return this.categoryMenu;
    }

    public void setAutoFind(boolean autoFind) {
        if (this._autoFind != autoFind) {
            this._autoFind = autoFind;
            this.firePropertyChange("autoFind", !this._autoFind, this._autoFind);
        }
    }

    public void setAllowEmptySearch(boolean allowEmptySearch) {
        if (this._allowEmptySearch != allowEmptySearch) {
            this._allowEmptySearch = allowEmptySearch;
            this.firePropertyChange("allowEmptySearch", !this._allowEmptySearch, this._allowEmptySearch);
        }
    }

    public boolean isAutoFind() {
        return this._autoFind;
    }

    public boolean isAllowEmptySearch() {
        return this._allowEmptySearch;
    }

    public void clear() {
        try {
            String textBeforeCancel = this._textField.getText();
            this._textField.getDocument().remove(0, this._textField.getDocument().getLength());
            this._searchTimer.stop();
            this.fireSearchCleared(textBeforeCancel);
            this.fireSearchPerformed(SearchEvent.Direction.FORWARD, false);
        }
        catch (BadLocationException ble) {
            throw new IllegalStateException(ble);
        }
    }

    public void setStyle(Style style) {
        if (style == null) {
            throw new NullPointerException("style is null");
        }
        Style oldStyle = this._style;
        if (oldStyle != style) {
            this._style = style;
            this.updateButtons();
            this.firePropertyChange("style", (Object)oldStyle, (Object)style);
            this.setText("");
            this._lastSearch = null;
        }
    }

    public Style getStyle() {
        return this._style;
    }

    public void setPopDownAction(Action action) {
        Object oldCommand;
        KeyStroke oldKeyStroke;
        if (action == null) {
            throw new NullPointerException("action is null");
        }
        InputMap inputMap = this.getInputMap(1);
        Action oldAction = this._searchButton.getAction();
        if (oldAction != null && (oldKeyStroke = (KeyStroke)oldAction.getValue("AcceleratorKey")) != null && (oldCommand = inputMap.get(oldKeyStroke)) != null) {
            this.getActionMap().remove(oldCommand);
        }
        this._searchButton.setAction(action);
        Icon disabledIcon = (Icon)action.getValue("SmallIcon");
        if (disabledIcon == null) {
            throw new IllegalArgumentException("Action must have an icon");
        }
        PopupIndicator enabledIcon = new PopupIndicator(disabledIcon);
        this._searchButton.setIcon(enabledIcon);
        this._searchButton.setDisabledIcon(disabledIcon);
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        if (keyStroke == null) {
            keyStroke = KeyStroke.getKeyStroke("alt DOWN");
        }
        inputMap.put(keyStroke, CATEGORY_DROP_DOWN_ACTION_ID);
        this.getActionMap().put(CATEGORY_DROP_DOWN_ACTION_ID, action);
    }

    public final Action getPopDownAction() {
        return this._searchButton.getAction();
    }

    public void addCategoryMenuItem(JMenuItem item) {
        if (item == null) {
            throw new NullPointerException("item is null");
        }
        this._extraItems.add(item);
        this.updateButtons();
    }

    public void removeCategoryMenuItem(JMenuItem item) {
        this._extraItems.remove(item);
        this.updateButtons();
    }

    public void clearCategoryMenuItems() {
        this._extraItems.clear();
        this.updateButtons();
    }

    public void addCategory(SearchCategory category) {
        if (category == null) {
            throw new NullPointerException("category is null");
        }
        this._categories.add(category);
        if (this._categories.size() == 1) {
            this.setSelectedCategory(category);
        }
        this.updateButtons();
    }

    public void removeCategory(SearchCategory category) {
        this._categories.remove(category);
        if (category != null && category.equals(this._selectedCategory)) {
            if (this._categories.size() == 0) {
                this.setSelectedCategory(null);
            } else {
                this.setSelectedCategory(this._categories.get(0));
            }
        }
        this.updateButtons();
    }

    public void clearCategories() {
        this._categories.clear();
        this.setSelectedCategory(null);
        this.updateButtons();
    }

    public SearchCategory getSelectedCategory() {
        return this._selectedCategory;
    }

    public void setSelectedCategory(SearchCategory selectedCategory) {
        if (selectedCategory == null && !this._categories.isEmpty()) {
            throw new IllegalStateException("Cannot set selected category to null when there are categories");
        }
        if (!this._categories.contains(selectedCategory) && selectedCategory != null) {
            throw new IllegalArgumentException("Category " + selectedCategory + " has not been added.");
        }
        SearchCategory old = this._selectedCategory;
        if ((old == null || selectedCategory == null) && old != selectedCategory || old != null && !old.equals(selectedCategory)) {
            this._selectedCategory = selectedCategory;
            this.updateButtons();
            this.firePropertyChange("selectedCategory", old, selectedCategory);
            this.fireSearchCategoryChanged();
        }
        this.getTextField().setToolTipText(this._selectedCategory != null ? this._selectedCategory.getLabel() : "");
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.getKeyCode() == 27) {
            boolean isEscapeOverridden;
            InputMap map = this.getInputMap(condition);
            boolean bl = isEscapeOverridden = map != null && map.get(ks) != null;
            if (this.processEscapeKey(e) && !isEscapeOverridden) {
                return true;
            }
        }
        boolean processed = super.processKeyBinding(ks, e, condition, pressed);
        if (this._keyEventTargetComponent == null) {
            return processed;
        }
        try {
            e.setSource(this._keyEventTargetComponent);
            Method processKeyEvent = JComponent.class.getDeclaredMethod("processKeyEvent", KeyEvent.class);
            processKeyEvent.setAccessible(true);
            processKeyEvent.invoke((Object)this._keyEventTargetComponent, e);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return e.isConsumed();
    }

    private boolean processEscapeKey(KeyEvent e) {
        if (!this.isEnabled() || !this.hasSearchText()) {
            return false;
        }
        Action action = this.getActionMap().get(CLEAR_ACTION_ID);
        if (action == null) {
            return false;
        }
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        return SwingUtilities.notifyAction(action, stroke, e, this, e.getModifiers());
    }

    private void updateCategoriesAction() {
        if (this._categoryDropDownAction != null) {
            boolean haveCategories = !this._categories.isEmpty() || !this._extraItems.isEmpty();
            this._categoryDropDownAction.setEnabled(haveCategories);
        }
    }

    private void updateButtons() {
        boolean haveSearch;
        this.updateCategoriesAction();
        Boolean wasEnabled = (Boolean)this._searchButton.getClientProperty("enabledState");
        Action action = this._searchButton.getAction();
        if (action != null) {
            boolean isEnabled;
            boolean bl = isEnabled = action.isEnabled() || this._allowEmptySearch && this.getStyle() == Style.SEARCH;
            if (wasEnabled == null || wasEnabled != isEnabled) {
                this._searchButton.putClientProperty("iconicButtonUIActive", isEnabled);
                action.setEnabled(!isEnabled);
                action.setEnabled(isEnabled);
            }
        }
        this._nextButton.setVisible(this.getStyle() == Style.FIND || this.getStyle() == Style.SEARCH);
        this._previousButton.setVisible(this.getStyle() == Style.FIND);
        boolean bl = haveSearch = this._textField.getDocument().getLength() != 0;
        if (haveSearch) {
            this._cancelButton.setHidden(this.getStyle() != Style.FILTER);
        } else {
            this._cancelButton.setHidden(true);
        }
        if (this.getSelectedCategory() != null) {
            this.setPrompt(this.getSelectedCategory().getLabel());
        } else if (this._categories.size() > 0) {
            this.setPrompt("");
        }
        switch (this.getStyle()) {
            case SEARCH: {
                if (this._isSearching) {
                    this.configureIconicButton(this._nextButton, OracleIcons.getIcon((String)"terminate.png"), UIBundle.get("STOP_SEARCH"));
                    break;
                }
                this.configureIconicButton(this._nextButton, OracleIcons.getIcon((String)"quick_query.png"), UIBundle.get("START_SEARCH"));
                break;
            }
            case FIND: {
                this.configureIconicButton(this._nextButton, OracleIcons.getIcon((String)"next.png"), UIBundle.get("NEXT_MATCH"));
            }
        }
        this._nextButton.setEnabled(haveSearch || this._isSearching && !this._searchProgress.isStopped());
        this._previousButton.setEnabled(haveSearch);
    }

    private boolean hasSearchText() {
        return this._textField.getText().length() > 0;
    }

    private boolean shouldIgnoreEmptySearch() {
        return this.getStyle() == Style.SEARCH && !this._allowEmptySearch || this.getStyle() == Style.FIND && !this._notifyOnEmptySearch;
    }

    protected final void fireSearchPerformed(SearchEvent.Direction direction, boolean keypress) {
        if (this._listeners.isEmpty()) {
            return;
        }
        if (this.shouldIgnoreEmptySearch() && !this.hasSearchText()) {
            return;
        }
        String searchText = this._textField.getText();
        if (this.getStyle() == Style.FILTER && searchText.equals(this._lastSearch)) {
            return;
        }
        this._lastSearch = searchText;
        if (this.getStyle() == Style.SEARCH) {
            this.startSearchAnimation();
        }
        SearchEvent event = new SearchEvent(this, searchText, this.getSelectedCategory(), this._searchProgress, direction, keypress);
        for (SearchListener listener : this._listeners) {
            listener.searchPerformed(event);
        }
        this.updateButtons();
    }

    private void startSearchAnimation() {
        this._indeterminateProgress = 0.0f;
        TimingTarget tgt = new TimingTarget(){

            public void end() {
            }

            public void begin() {
            }

            public void timingEvent(long l, long l1, float fraction) {
                SearchField.this._indeterminateProgress = fraction * 1.0f;
                SearchField.this.repaint();
            }
        };
        final TimingController controller = new TimingController(new Cycle(1000, 30), new Envelope(-1.0, 0, Envelope.RepeatBehavior.REVERSE, Envelope.EndBehavior.RESET), tgt);
        controller.start();
        this._searchProgress = new SearchProgress(){

            @Override
            public void setProgress(int progress) {
                super.setProgress(progress);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        controller.stop();
                        SearchField.this._indeterminateProgress = -1.0f;
                        SearchField.this.repaint();
                    }
                });
            }

            @Override
            public void finish() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchField.this._isSearching = false;
                        SearchField.this._searchProgress = null;
                        controller.stop();
                        SearchField.this._indeterminateProgress = -1.0f;
                        SearchField.this.repaint();
                        SearchField.this.updateButtons();
                    }
                });
            }
        };
        this._isSearching = true;
    }

    protected final void fireSearchCategoryChanged() {
        if (!this.hasSearchText() || this._listeners.isEmpty()) {
            return;
        }
        SearchEvent event = new SearchEvent(this, this._textField.getText(), this.getSelectedCategory(), null, SearchEvent.Direction.FORWARD, false);
        for (SearchListener listener : this._listeners) {
            listener.searchCategoryChanged(event);
        }
    }

    protected final void fireSearchCleared(String textBeforeClear) {
        SearchEvent event = new SearchEvent(this, textBeforeClear, true);
        for (SearchListener listener : this._listeners) {
            listener.searchPerformed(event);
        }
    }

    public void addSearchListener(SearchListener sl) {
        if (sl == null) {
            throw new NullPointerException("sl is null");
        }
        this._listeners.add(sl);
    }

    public void removeSearchListener(SearchListener sl) {
        this._listeners.remove(sl);
    }

    public void setPrompt(String prompt) {
        this._textField.setPrompt(prompt);
    }

    public void setTypingDelay(TypingDelay delay) {
        if (delay == null) {
            throw new NullPointerException("delay is null");
        }
        if (this._typingDelay != delay) {
            TypingDelay old = this._typingDelay;
            this._typingDelay = delay;
            this._typingDelay.configureSearchField(this);
            this.firePropertyChange("typingDelay", (Object)old, (Object)delay);
        }
    }

    public TypingDelay getTypingDelay() {
        return this._typingDelay;
    }

    private void setTimerDelay(TimeUnit unit, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("delay " + delay + " is invalid. Must be >= 0.");
        }
        long delayInMillis = unit.toMillis(delay);
        this._searchTimer.setDelay((int)delayInMillis);
        this._searchTimer.setInitialDelay((int)delayInMillis);
    }

    public String getText() {
        return this._textField.getText();
    }

    public PromptedTextField getTextField() {
        return this._textField;
    }

    public void setText(String text) {
        this._textField.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String newText, boolean isAdjusting) {
        try {
            if (isAdjusting) {
                this._isAdjusting = true;
                this._searchTimer.stop();
            }
            this._textField.setText(newText);
            this.updateButtons();
        }
        finally {
            this._isAdjusting = false;
        }
    }

    public void doSearch(SearchCategory category, String searchText, SearchEvent.Direction direction) {
        this.doSearch(category, searchText, direction, true);
    }

    public void doSearch(SearchCategory category, String searchText, SearchEvent.Direction direction, boolean force) {
        if (force) {
            this._lastSearch = null;
        }
        this.setSelectedCategory(category);
        this.setText(searchText);
        this.fireSearchPerformed(direction, false);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (this._textField != null) {
            comp.setBackground(this._textField.getBackground());
        }
    }

    @Override
    public void requestFocus() {
        this._textField.requestFocus();
    }

    private void configureIconicButton(AbstractButton button, Icon icon, String tooltip) {
        if (button == null) {
            return;
        }
        Action action = button.getAction();
        if (action != null) {
            action.putValue("SmallIcon", icon);
            action.putValue("ShortDescription", tooltip);
        }
        this.configureIconicButton(button);
    }

    private void configureIconicButton(AbstractButton button) {
        IconicButtonUI.install(button);
        button.setOpaque(false);
        button.setFocusable(false);
        button.setContentAreaFilled(false);
        button.setBorder(null);
    }

    private class CancelButton
    extends JButton {
        private boolean isHidden = false;

        CancelButton() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    if (CancelButton.this.isHidden) {
                        me.consume();
                        SearchField.this._textField.requestFocus();
                    }
                }
            });
        }

        @Override
        public boolean isFocusable() {
            return !this.isHidden;
        }

        public void setHidden(boolean hide) {
            this.isHidden = hide;
            this.repaint();
            if (this.isHidden) {
                SearchField.this._textField.requestFocus();
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            if (!this.isHidden) {
                super.paintComponent(g);
            }
        }

        @Override
        public Cursor getCursor() {
            if (this.isHidden) {
                return SearchField.this._textField.getCursor();
            }
            return super.getCursor();
        }
    }

    private class SearchCategoryAction
    extends AbstractAction {
        private SearchCategory _searchCategory;

        SearchCategoryAction(SearchCategory sc) {
            super(sc.getLabel());
            this._searchCategory = sc;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchField.this.setSelectedCategory(this._searchCategory);
        }
    }

    private static final class PopupIndicator
    implements Icon {
        private static final int GAP = 2;
        private static final int SIZE = 4;
        private final Icon _baseIcon;
        private final Polygon _inner = new Polygon();

        public PopupIndicator(Icon baseIcon) {
            this._baseIcon = baseIcon;
            this._inner.addPoint(0, 0);
            this._inner.addPoint(2, 2);
            this._inner.addPoint(4, 0);
        }

        @Override
        public int getIconHeight() {
            return Math.max(this._inner.getBounds().height, this._baseIcon.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return 2 + this._inner.getBounds().width + this._baseIcon.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this._baseIcon.paintIcon(c, g, x, y);
            if (c.isEnabled()) {
                this.paint(g, this._baseIcon.getIconWidth() + 2, y + this.getIconHeight() / 2 - this._inner.getBounds().height / 2, c.getForeground());
            } else {
                this.paint(g, this._baseIcon.getIconWidth() + 2, y + this.getIconHeight() / 2 - this._inner.getBounds().height / 2, c.getBackground().darker());
            }
        }

        private void paint(Graphics g, int x, int y, Color color) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(color);
            g.fillPolygon(this._inner);
            g.drawPolygon(this._inner);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    public static enum Style {
        FILTER,
        SEARCH,
        FIND;

    }

    public static enum TypingDelay {
        FAST(200L),
        SLOW(850L);

        private final long _delayInMs;

        private TypingDelay(long delayInMs) {
            this._delayInMs = delayInMs;
        }

        void configureSearchField(SearchField sf) {
            sf.setTimerDelay(TimeUnit.MILLISECONDS, this._delayInMs);
        }
    }
}

