/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.javatools.ui.calendar.CalendarDateProvider;
import oracle.javatools.ui.calendar.CalendarPanel;
import oracle.javatools.ui.calendar.CalendarPopupButton;
import oracle.javatools.ui.calendar.Day;
import oracle.javatools.ui.internal.ReflectiveCellRenderer;

class UICDateDemoPanel
extends JPanel {
    private JPanel _datePanel;
    private JComboBox _localeCombo;
    private JComboBox _tzCombo;
    private JCheckBox _multiCheckbox;
    private JCheckBox _showTimeCheckbox;
    private JCheckBox _showTimeZoneCheckbox;
    private JCheckBox _editTimeCheckbox;
    private DateEditor _minDate;
    private DateEditor _maxDate;
    private DateEditor _selDate;
    private DateEditor _showDate;
    private JCheckBox _minCheckbox;
    private JCheckBox _maxCheckbox;
    private JCheckBox _providerCheckbox;
    private JButton _addDate;
    private JButton _selectDate;
    private JButton _showButton;
    private JButton _removeDate;
    private JButton _dumpDates;
    private CalendarPanel _cp;
    private CalendarPanel _popupCp;
    private DateEditor _popupCpDateEditor;

    public UICDateDemoPanel() {
        this.setLayout(new BorderLayout(10, 0));
        this.add((Component)this._createDatePicker(), "West");
        this.add((Component)this._createControlPanel(), "East");
    }

    private JComponent _createDatePicker() {
        JPanel compPanel = new JPanel(new BorderLayout());
        this._datePanel = new JPanel();
        this._cp = new CalendarPanel(Locale.ENGLISH);
        this._datePanel.add(this._cp);
        compPanel.setBorder(BorderFactory.createEmptyBorder(50, 0, 0, 0));
        JPanel topPanel = new JPanel(new BorderLayout(5, 5));
        topPanel.add((Component)new JLabel("CalendarPanel:"), "North");
        topPanel.add((Component)this._datePanel, "Center");
        compPanel.add((Component)topPanel, "North");
        CalendarPopupButton popupButton = new CalendarPopupButton();
        JPanel bottomPanel = new JPanel(new BorderLayout(5, 5));
        bottomPanel.add((Component)new JLabel("CalendarPopupButton:"), "North");
        bottomPanel.add(Box.createHorizontalStrut(5));
        bottomPanel.add((Component)popupButton, "West");
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 200, 0));
        bottomPanel.setAlignmentX(1.0f);
        compPanel.add((Component)bottomPanel, "South");
        this._popupCp = popupButton.getCalendarPanel();
        this._popupCpDateEditor = new DateEditor();
        this._popupCp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date[] dates;
                if (e.getActionCommand() == "SELECTION_CHANGED_COMMAND" && (dates = UICDateDemoPanel.this._popupCp.getSelectedDates()).length > 0) {
                    UICDateDemoPanel.this._popupCpDateEditor.setDate(dates[0]);
                }
            }
        });
        bottomPanel.add((Component)this._popupCpDateEditor, "East");
        return compPanel;
    }

    private JComponent _createControlPanel() {
        JPanel controlPanel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        controlPanel.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        this._createLocaleCombo();
        this._createTimeZoneCombo();
        this._createMultiSelect();
        this._createShowTime();
        this._createShowTimeZone();
        this._createEditTime();
        this._createVisibleDate();
        this._createMinDate();
        this._createMaxDate();
        this._createDateSelect();
        this._createDateProvider();
        this._createSelectDump();
        c.insets = new Insets(2, 2, 0, 2);
        c.anchor = 17;
        c.gridwidth = 0;
        JLabel controlLabel = new JLabel("A date/time picker with test controls that invoke");
        JLabel controlLabel2 = new JLabel("methods available on the Calendar Picker API");
        gridbag.setConstraints(controlLabel, c);
        controlPanel.add(controlLabel);
        c.insets = new Insets(0, 2, 15, 2);
        gridbag.setConstraints(controlLabel2, c);
        controlPanel.add(controlLabel2);
        c.insets = new Insets(10, 2, 0, 2);
        JLabel interLabel = new JLabel("Internationalization:");
        gridbag.setConstraints(interLabel, c);
        controlPanel.add(interLabel);
        c.insets = new Insets(2, 2, 0, 2);
        c.fill = 2;
        JSeparator interSep = new JSeparator(0);
        gridbag.setConstraints(interSep, c);
        controlPanel.add(interSep);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 2);
        c.gridwidth = 1;
        c.fill = 2;
        JLabel localeLabel = new JLabel("Locale: ");
        gridbag.setConstraints(localeLabel, c);
        controlPanel.add(localeLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(this._localeCombo, c);
        controlPanel.add(this._localeCombo);
        c.insets = new Insets(2, 2, 0, 2);
        c.gridwidth = 1;
        JLabel tzLabel = new JLabel("Time zone: ");
        gridbag.setConstraints(tzLabel, c);
        controlPanel.add(tzLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(this._tzCombo, c);
        controlPanel.add(this._tzCombo);
        c.insets = new Insets(10, 2, 0, 2);
        JLabel displayLabel = new JLabel("Display options");
        gridbag.setConstraints(displayLabel, c);
        controlPanel.add(displayLabel);
        c.insets = new Insets(2, 2, 0, 2);
        c.fill = 2;
        JSeparator displaySep = new JSeparator(0);
        gridbag.setConstraints(displaySep, c);
        controlPanel.add(displaySep);
        c.fill = 0;
        gridbag.setConstraints(this._multiCheckbox, c);
        controlPanel.add(this._multiCheckbox);
        gridbag.setConstraints(this._showTimeCheckbox, c);
        controlPanel.add(this._showTimeCheckbox);
        gridbag.setConstraints(this._showTimeZoneCheckbox, c);
        controlPanel.add(this._showTimeZoneCheckbox);
        gridbag.setConstraints(this._editTimeCheckbox, c);
        controlPanel.add(this._editTimeCheckbox);
        c.gridwidth = -1;
        gridbag.setConstraints(this._showButton, c);
        controlPanel.add(this._showButton);
        c.gridwidth = 0;
        gridbag.setConstraints((Component)this._showDate, c);
        controlPanel.add((Component)this._showDate);
        c.insets = new Insets(10, 2, 0, 2);
        JLabel validLabel = new JLabel("Valid Dates");
        gridbag.setConstraints(validLabel, c);
        controlPanel.add(validLabel);
        c.insets = new Insets(2, 2, 0, 2);
        c.fill = 2;
        JSeparator validSep = new JSeparator(0);
        gridbag.setConstraints(validSep, c);
        controlPanel.add(validSep);
        c.fill = 0;
        gridbag.setConstraints(this._providerCheckbox, c);
        controlPanel.add(this._providerCheckbox);
        c.gridwidth = 3;
        gridbag.setConstraints(this._minCheckbox, c);
        controlPanel.add(this._minCheckbox);
        c.gridwidth = 0;
        gridbag.setConstraints((Component)this._minDate, c);
        controlPanel.add((Component)this._minDate);
        c.gridwidth = 3;
        gridbag.setConstraints(this._maxCheckbox, c);
        controlPanel.add(this._maxCheckbox);
        c.gridwidth = 0;
        gridbag.setConstraints((Component)this._maxDate, c);
        controlPanel.add((Component)this._maxDate);
        c.insets = new Insets(10, 2, 0, 2);
        JLabel selLabel = new JLabel("Date Selection");
        gridbag.setConstraints(selLabel, c);
        controlPanel.add(selLabel);
        c.insets = new Insets(2, 2, 0, 2);
        c.fill = 2;
        JSeparator selSep = new JSeparator(0);
        gridbag.setConstraints(selSep, c);
        controlPanel.add(selSep);
        c.fill = 0;
        c.gridwidth = 1;
        gridbag.setConstraints(this._selectDate, c);
        controlPanel.add(this._selectDate);
        gridbag.setConstraints(this._addDate, c);
        controlPanel.add(this._addDate);
        gridbag.setConstraints(this._removeDate, c);
        controlPanel.add(this._removeDate);
        c.gridwidth = 0;
        gridbag.setConstraints((Component)this._selDate, c);
        controlPanel.add((Component)this._selDate);
        c.gridwidth = 3;
        c.insets = new Insets(2, 2, 20, 2);
        JLabel dumpLabel = new JLabel("Dump selected dates to console: ");
        gridbag.setConstraints(dumpLabel, c);
        controlPanel.add(dumpLabel);
        c.gridwidth = 0;
        gridbag.setConstraints(this._dumpDates, c);
        controlPanel.add(this._dumpDates);
        return controlPanel;
    }

    private JComponent _createLocaleCombo() {
        this._localeCombo = new JComboBox<Locale>(Locale.getAvailableLocales());
        this._localeCombo.setSelectedItem(Locale.ENGLISH);
        this._localeCombo.setRenderer(new ReflectiveCellRenderer(Locale.class, "getDisplayName"));
        this._localeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                UICDateDemoPanel.this._reloadCalendar();
            }
        });
        return this._localeCombo;
    }

    private JComponent _createTimeZoneCombo() {
        this._tzCombo = new JComboBox<TimeZone>(this._getTimeZoneIDs());
        this._tzCombo.setPrototypeDisplayValue("WWWWWWWWWWWWWWW");
        this._tzCombo.setSelectedItem(this._cp.getTimeZone());
        this._tzCombo.setRenderer(new TimeZoneRenderer());
        this._tzCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                TimeZone tz = (TimeZone)UICDateDemoPanel.this._tzCombo.getSelectedItem();
                UICDateDemoPanel.this._cp.setTimeZone(tz);
                UICDateDemoPanel.this._popupCp.setTimeZone(tz);
            }
        });
        return this._tzCombo;
    }

    private TimeZone[] _getTimeZoneIDs() {
        LinkedList<String> zoneNames = new LinkedList<String>();
        LinkedList<TimeZone> zones = new LinkedList<TimeZone>();
        for (String zoneID : TimeZone.getAvailableIDs()) {
            try {
                TimeZone tz = TimeZone.getTimeZone(zoneID);
                String displayName = tz.getDisplayName(true, 1, (Locale)this._localeCombo.getSelectedItem());
                if (zoneNames.contains(displayName)) continue;
                zoneNames.add(displayName);
                zones.add(tz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return zones.toArray(new TimeZone[0]);
    }

    private JComponent _createMultiSelect() {
        this._multiCheckbox = new JCheckBox("Multi-select");
        this._multiCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.setMultiSelect(UICDateDemoPanel.this._multiCheckbox.isSelected());
                UICDateDemoPanel.this._popupCp.setMultiSelect(UICDateDemoPanel.this._multiCheckbox.isSelected());
            }
        });
        return this._multiCheckbox;
    }

    private JComponent _createShowTime() {
        this._showTimeCheckbox = new JCheckBox("Display Time");
        this._showTimeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.setShowTime(UICDateDemoPanel.this._showTimeCheckbox.isSelected());
                UICDateDemoPanel.this._popupCp.setShowTime(UICDateDemoPanel.this._showTimeCheckbox.isSelected());
            }
        });
        return this._showTimeCheckbox;
    }

    private JComponent _createShowTimeZone() {
        this._showTimeZoneCheckbox = new JCheckBox("Display TimeZone");
        this._showTimeZoneCheckbox.setSelected(true);
        this._showTimeZoneCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.setShowTimeZone(UICDateDemoPanel.this._showTimeZoneCheckbox.isSelected());
                UICDateDemoPanel.this._popupCp.setShowTimeZone(UICDateDemoPanel.this._showTimeZoneCheckbox.isSelected());
            }
        });
        return this._showTimeZoneCheckbox;
    }

    private JComponent _createEditTime() {
        this._editTimeCheckbox = new JCheckBox("Edit Time");
        this._editTimeCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.setEditTime(UICDateDemoPanel.this._editTimeCheckbox.isSelected());
                UICDateDemoPanel.this._popupCp.setEditTime(UICDateDemoPanel.this._editTimeCheckbox.isSelected());
            }
        });
        return this._editTimeCheckbox;
    }

    private JComponent _createDateProvider() {
        this._providerCheckbox = new JCheckBox("Restrict selection to predefined dates in Sep 2005");
        this._providerCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.setDateProvider(UICDateDemoPanel.this._providerCheckbox.isSelected() ? new ExampleDateProvider() : null);
                UICDateDemoPanel.this._popupCp.setDateProvider(UICDateDemoPanel.this._providerCheckbox.isSelected() ? new ExampleDateProvider() : null);
            }
        });
        return this._providerCheckbox;
    }

    private void _createVisibleDate() {
        this._showButton = new JButton("Show");
        this._showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.makeDateVisible(UICDateDemoPanel.this._showDate.getDate());
                UICDateDemoPanel.this._popupCp.makeDateVisible(UICDateDemoPanel.this._showDate.getDate());
            }
        });
        this._showDate = new DateEditor();
        this._showDate.setDateFormat((DateFormat)new SimpleDateFormat("dd.MMM.yyyy"));
    }

    private void _createMinDate() {
        this._minCheckbox = new JCheckBox("Minimum date: ");
        this._minCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.setMinimumDate(UICDateDemoPanel.this._minCheckbox.isSelected() ? UICDateDemoPanel.this._minDate.getDate() : null);
                UICDateDemoPanel.this._popupCp.setMinimumDate(UICDateDemoPanel.this._minCheckbox.isSelected() ? UICDateDemoPanel.this._minDate.getDate() : null);
            }
        });
        this._minDate = new DateEditor();
        this._minDate.setDateFormat((DateFormat)new SimpleDateFormat("dd.MMM.yyyy"));
        this._minDate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("date") && UICDateDemoPanel.this._minCheckbox.isSelected()) {
                    UICDateDemoPanel.this._cp.setMinimumDate(UICDateDemoPanel.this._minDate.getDate());
                    UICDateDemoPanel.this._popupCp.setMinimumDate(UICDateDemoPanel.this._minDate.getDate());
                }
            }
        });
    }

    private void _createMaxDate() {
        this._maxCheckbox = new JCheckBox("Maximum date: ");
        this._maxCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.setMaximumDate(UICDateDemoPanel.this._maxCheckbox.isSelected() ? UICDateDemoPanel.this._maxDate.getDate() : null);
                UICDateDemoPanel.this._popupCp.setMaximumDate(UICDateDemoPanel.this._maxCheckbox.isSelected() ? UICDateDemoPanel.this._maxDate.getDate() : null);
            }
        });
        this._maxDate = new DateEditor();
        this._maxDate.setDateFormat((DateFormat)new SimpleDateFormat("dd.MMM.yyyy"));
        this._maxDate.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("date") && UICDateDemoPanel.this._maxCheckbox.isSelected()) {
                    UICDateDemoPanel.this._cp.setMaximumDate(UICDateDemoPanel.this._maxDate.getDate());
                    UICDateDemoPanel.this._popupCp.setMaximumDate(UICDateDemoPanel.this._maxDate.getDate());
                }
            }
        });
    }

    private void _createDateSelect() {
        this._selectDate = new JButton("Select");
        this._selectDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.setSelectedDate(UICDateDemoPanel.this._selDate.getDate());
                UICDateDemoPanel.this._popupCp.setSelectedDate(UICDateDemoPanel.this._selDate.getDate());
            }
        });
        this._addDate = new JButton("Add");
        this._addDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.addSelectedDates(new Date[]{UICDateDemoPanel.this._selDate.getDate()});
                UICDateDemoPanel.this._popupCp.addSelectedDates(new Date[]{UICDateDemoPanel.this._selDate.getDate()});
            }
        });
        this._removeDate = new JButton("Remove");
        this._removeDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UICDateDemoPanel.this._cp.removeSelectedDates(new Date[]{UICDateDemoPanel.this._selDate.getDate()});
                UICDateDemoPanel.this._popupCp.removeSelectedDates(new Date[]{UICDateDemoPanel.this._selDate.getDate()});
            }
        });
        this._selDate = new DateEditor();
        this._selDate.setDateFormat((DateFormat)new SimpleDateFormat("dd.MMM.yyyy"));
    }

    private void _createSelectDump() {
        this._dumpDates = new JButton("Dump");
        this._dumpDates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date[] dates;
                System.out.println("-------------------");
                DateFormat sdf = SimpleDateFormat.getDateTimeInstance(1, 1, (Locale)UICDateDemoPanel.this._localeCombo.getSelectedItem());
                for (Date date : dates = UICDateDemoPanel.this._cp.getSelectedDates()) {
                    System.out.println("Date/Time: " + sdf.format(date) + ", TimeZone: " + UICDateDemoPanel.this._cp.getTimeZone().getDisplayName());
                }
            }
        });
    }

    private void _reloadCalendar() {
        Locale locale = (Locale)this._localeCombo.getSelectedItem();
        this._datePanel.removeAll();
        this._cp = new CalendarPanel(locale);
        this._cp.setMinimumDate(this._minCheckbox.isSelected() ? this._minDate.getDate() : null);
        this._cp.setMaximumDate(this._maxCheckbox.isSelected() ? this._maxDate.getDate() : null);
        this._cp.setShowTime(this._showTimeCheckbox.isSelected());
        this._cp.setEditTime(this._editTimeCheckbox.isSelected());
        this._cp.setMultiSelect(this._multiCheckbox.isSelected());
        if (this._providerCheckbox.isSelected()) {
            this._cp.setDateProvider(new ExampleDateProvider());
        }
        TimeZone tz = (TimeZone)this._tzCombo.getSelectedItem();
        this._cp.setTimeZone(tz);
        this._datePanel.add(this._cp);
        this.repaint();
    }

    private class ExampleDateProvider
    implements CalendarDateProvider {
        private HashSet<Day> _validDates = new HashSet();

        public ExampleDateProvider() {
            this._validDates.add(new Day(new Date(105, 8, 1)));
            this._validDates.add(new Day(new Date(105, 8, 2)));
            this._validDates.add(new Day(new Date(105, 8, 5)));
            this._validDates.add(new Day(new Date(105, 8, 6)));
            this._validDates.add(new Day(new Date(105, 8, 7)));
            this._validDates.add(new Day(new Date(105, 8, 10)));
            this._validDates.add(new Day(new Date(105, 8, 11)));
            this._validDates.add(new Day(new Date(105, 8, 21)));
            this._validDates.add(new Day(new Date(105, 8, 22)));
            this._validDates.add(new Day(new Date(105, 8, 23)));
            this._validDates.add(new Day(new Date(105, 8, 27)));
            this._validDates.add(new Day(new Date(105, 8, 28)));
        }

        @Override
        public boolean isDateValid(Date date) {
            return this._validDates.contains(new Day(date));
        }
    }

    private class TimeZoneRenderer
    extends DefaultListCellRenderer {
        private TimeZoneRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TimeZone) {
                TimeZone tz = (TimeZone)value;
                label.setText(tz.getDisplayName(true, 1, (Locale)UICDateDemoPanel.this._localeCombo.getSelectedItem()));
            } else if (value instanceof String) {
                label.setText((String)value);
            }
            return label;
        }
    }
}

