/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.ghost;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import oracle.javatools.ui.ghost.GhostPalette;
import oracle.javatools.ui.ghost.UIConstants;

final class GhostCloseButton
extends JButton {
    private static CloseIcon closeIcon = new CloseIcon();

    public GhostCloseButton() {
        this.setOpaque(false);
        this.setRolloverEnabled(true);
        this.setBorder(null);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setPreferredSize(new Dimension(14, 14));
        this.setIcon(closeIcon);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.getIcon().paintIcon(this, g, 0, 0);
    }

    private static class CloseIcon
    implements Icon {
        private CloseIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (c.getParent() instanceof GhostPalette) {
                GhostPalette gp = (GhostPalette)c.getParent();
                g2.setColor(UIConstants.getColor("ghost.title.foreground", gp.getLook()));
                if (c instanceof AbstractButton && ((AbstractButton)c).getModel().isRollover()) {
                    Composite composite = g2.getComposite();
                    g2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    g2.fillRoundRect(0, 0, this.getIconWidth() - 1, this.getIconHeight() - 1, 6, 6);
                    g2.setComposite(composite);
                }
            }
            g2.drawRoundRect(0, 0, this.getIconWidth() - 1, this.getIconHeight() - 1, 6, 6);
            g2.setStroke(new BasicStroke(1.75f, 2, 1));
            int i = 4;
            g2.drawLine(i, i, this.getIconWidth() - i - 1, this.getIconHeight() - i - 1);
            g2.drawLine(this.getIconWidth() - i - 1, i, i, this.getIconHeight() - i - 1);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 14;
        }

        @Override
        public int getIconHeight() {
            return 14;
        }
    }
}

