/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.datatips;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import oracle.javatools.ui.datatips.DataTipModel;

class NodeTableModel
implements TableModel {
    private DataTipModel dataTipModel;
    private Object node;
    private transient ArrayList tableModelListeners = new ArrayList(2);

    public NodeTableModel(DataTipModel DataTipModel2, Object node) {
        this.dataTipModel = DataTipModel2;
        this.node = node;
    }

    public boolean isExpandable(int row) {
        Object child = this.dataTipModel.getChild(this.node, row);
        return !this.dataTipModel.isLeaf(child);
    }

    public NodeTableModel getNodeTableModelForChild(int row) {
        Object childNode = this.dataTipModel.getChild(this.node, row);
        NodeTableModel childModel = new NodeTableModel(this.dataTipModel, childNode);
        return childModel;
    }

    @Override
    public int getRowCount() {
        return this.dataTipModel.getChildCount(this.node);
    }

    @Override
    public int getColumnCount() {
        return this.dataTipModel.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.dataTipModel.getColumnName(columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.dataTipModel.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Object childNode = this.dataTipModel.getChild(this.node, rowIndex);
        return this.dataTipModel.isCellEditable(childNode, columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object childNode = this.dataTipModel.getChild(this.node, rowIndex);
        return this.dataTipModel.getValueAt(childNode, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object childNode = this.dataTipModel.getChild(this.node, rowIndex);
        this.dataTipModel.setValueAt(aValue, childNode, columnIndex);
        TableModelEvent evt = new TableModelEvent(this, rowIndex);
        this.fireTableChanged(evt);
    }

    @Override
    public synchronized void addTableModelListener(TableModelListener listener) {
        if (this.tableModelListeners == null) {
            this.tableModelListeners = new ArrayList(2);
        }
        this.tableModelListeners.add(listener);
    }

    @Override
    public synchronized void removeTableModelListener(TableModelListener listener) {
        if (this.tableModelListeners != null) {
            this.tableModelListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableChanged(TableModelEvent tableModelEvent) {
        List list;
        NodeTableModel nodeTableModel = this;
        synchronized (nodeTableModel) {
            if (this.tableModelListeners == null) {
                return;
            }
            list = (List)this.tableModelListeners.clone();
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ((TableModelListener)list.get(i)).tableChanged(tableModelEvent);
        }
    }

    Object getNode() {
        return this.node;
    }
}

