/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.datatips;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.javatools.ui.EmptyIcon;
import oracle.javatools.ui.datatips.DataTipWindow;
import oracle.javatools.ui.datatips.NodeTableModel;
import oracle.javatools.ui.table.BasicRowHeaderModel;
import oracle.javatools.ui.table.DefaultRowHeaderRenderer;
import oracle.javatools.ui.table.RowHeader;

public class ExpansionRenderer
extends DefaultRowHeaderRenderer {
    private Icon expandedIcon = UIManager.getIcon("Tree.expandedIcon");
    private Icon collapsedIcon = UIManager.getIcon("Tree.collapsedIcon");
    private Icon emptyIcon = new EmptyIcon(this.expandedIcon);

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        BasicRowHeaderModel listModel = (BasicRowHeaderModel)list.getModel();
        NodeTableModel tableModel = (NodeTableModel)listModel.getTableModel();
        label.setText(null);
        label.setBackground(UIManager.getColor("Label.background"));
        label.setHorizontalAlignment(0);
        if (tableModel.isExpandable(index)) {
            label.setIcon(this.isExpanded((RowHeader)list, index) ? this.expandedIcon : this.collapsedIcon);
        } else {
            label.setIcon(this.emptyIcon);
        }
        Dimension prefSize = label.getPreferredSize();
        prefSize.width = this.expandedIcon.getIconWidth() + 2;
        label.setPreferredSize(prefSize);
        return label;
    }

    private boolean isExpanded(RowHeader rowHeader, int row) {
        DataTipWindow.DataTipWindowImpl w = (DataTipWindow.DataTipWindowImpl)SwingUtilities.getWindowAncestor(rowHeader);
        DataTipWindow dataW = w.getDataTipWindow();
        int selRow = dataW.getSelectedRow();
        return selRow == row && dataW.isExpanded();
    }
}

