/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.datatips;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import oracle.javatools.ui.datatips.DataTipModel;
import oracle.javatools.ui.datatips.DataTipWindow;
import oracle.javatools.ui.datatips.NodeTableModel;
import oracle.javatools.ui.datatips.TableCustomizer;
import oracle.javatools.util.PlatformUtils;

public class DataTip {
    private DataTipWindow baseTipWindow;
    private DataTipModel model;
    private TableCustomizer tableCustomizer;
    private Frame frame;
    private FocusL focusL = new FocusL();
    private Rectangle locationRect = new Rectangle(0, 0, 50, 16);
    private boolean dismissOnMouseExit;

    public DataTip(Frame parentFrame, DataTipModel model) {
        this.model = model;
        this.frame = parentFrame;
    }

    public void setLocationRectangle(Rectangle rect) {
        this.locationRect = rect;
        if (this.baseTipWindow != null) {
            this.baseTipWindow.setLocationRectangle(rect);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.baseTipWindow == null) {
                NodeTableModel tableModel = new NodeTableModel(this.model, this.model.getRoot());
                this.baseTipWindow = new DataTipWindow(null, this.frame, tableModel, this.tableCustomizer);
                this.baseTipWindow.setLocationRectangle(this.locationRect);
                this.baseTipWindow.setVisible(true);
                Toolkit.getDefaultToolkit().addAWTEventListener(this.focusL, 36L);
            }
        } else if (this.frame != null) {
            Component component;
            if (!PlatformUtils.isWindows() && (component = this.frame.getMostRecentFocusOwner()) != null) {
                component.requestFocus();
            }
            this.dispose();
        }
    }

    public void setDismissOnMouseExit(boolean dismiss) {
        this.dismissOnMouseExit = dismiss;
    }

    protected void dispose() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.focusL);
        if (this.baseTipWindow != null) {
            this.baseTipWindow.dispose();
        }
        this.baseTipWindow = null;
        this.frame = null;
        this.model = null;
    }

    public void setTableCustomizer(TableCustomizer tableCustomizer) {
        this.tableCustomizer = tableCustomizer;
    }

    public TableCustomizer getTableCustomizer() {
        return this.tableCustomizer;
    }

    public DataTipWindow getBaseTipWindow() {
        return this.baseTipWindow;
    }

    private class FocusL
    implements AWTEventListener {
        private DataTipWindow focusedWindow;

        private FocusL() {
        }

        private void dispose() {
            this.focusedWindow = null;
            DataTip.this.dispose();
        }

        private void disposeAndSetNewFocus(ComponentEvent event) {
            Window w = SwingUtilities.getWindowAncestor(event.getComponent());
            if (w == null) {
                this.dispose();
            } else if (!(w instanceof DataTipWindow.DataTipWindowImpl)) {
                if (!PlatformUtils.isWindows()) {
                    event.getComponent().requestFocus();
                }
                this.dispose();
            } else {
                this.focusedWindow = ((DataTipWindow.DataTipWindowImpl)w).getDataTipWindow();
                this.focusedWindow.disposeChildren();
            }
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (DataTip.this.dismissOnMouseExit && this.focusedWindow != null && event instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)event;
                Point mouseOnScreen = me.getLocationOnScreen();
                Rectangle bounds = this.focusedWindow.getScreenBounds();
                if (bounds != null && (mouseOnScreen.x < bounds.x - 20 || mouseOnScreen.x > bounds.x + bounds.width + 20 || mouseOnScreen.y < bounds.y - 20 || mouseOnScreen.y > bounds.y + bounds.height + 20)) {
                    this.disposeAndSetNewFocus(me);
                }
            } else if (event instanceof FocusEvent) {
                FocusEvent fe = (FocusEvent)event;
                if (fe.isTemporary() && fe.getOppositeComponent() == null) {
                    this.dispose();
                }
                if (!fe.isTemporary() && fe.getID() == 1004) {
                    this.disposeAndSetNewFocus(fe);
                }
            }
        }
    }
}

