/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.combo.JCustomComboBox;
import oracle.javatools.ui.combo.TreeComboModel;
import oracle.javatools.ui.combo.TreeComboRenderer;

public class JTreeCombo
extends JCustomComboBox {
    private JTree tree;
    private JScrollPane sp;
    private Dimension minSize = new Dimension(160, 200);
    private Dimension maxSize = new Dimension(360, 400);

    public JTreeCombo() {
        this.init();
    }

    public JTreeCombo(TreeModel treeModel) {
        this.init();
        this.setModel(treeModel);
    }

    public void setModel(TreeModel treeModel) {
        TreeComboModel treeComboModel = new TreeComboModel(this.tree);
        this.tree.setModel(treeModel);
        super.setModel(treeComboModel);
        this.expandAll();
    }

    public void setTreeComboRenderer(TreeComboRenderer renderer) {
        this.tree.setCellRenderer(renderer);
        this.setRenderer(renderer);
    }

    public void setRootVisible(boolean visible) {
        this.tree.setRootVisible(visible);
    }

    private void expandAll() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    protected void updatePopupPreferredSize() {
        int prefW = this.tree.getPreferredSize().width;
        Dimension newD = new Dimension(prefW, this.tree.getRowHeight() * this.tree.getRowCount());
        newD.width = Math.max(Math.min(newD.width, this.maxSize.width), this.minSize.width);
        newD.height = Math.max(Math.min(newD.height, this.maxSize.height), this.minSize.height);
        newD.width = Math.max(newD.width, this.getWidth() - 2);
        this.sp.getViewport().setPreferredSize(newD);
    }

    @Override
    public void firePopupMenuWillBecomeVisible() {
        this.updatePopupPreferredSize();
        Object selObj = this.getSelectedItem();
        ((TreeComboModel)this.getModel()).setSelectedItem(selObj);
        super.firePopupMenuWillBecomeVisible();
    }

    @Override
    public void firePopupMenuWillBecomeInvisible() {
        Object lastPathComponent;
        super.firePopupMenuWillBecomeInvisible();
        TreeComboModel comboModel = (TreeComboModel)this.getModel();
        TreePath path = this.tree.getSelectionPath();
        if (path != null && (lastPathComponent = path.getLastPathComponent()) != comboModel.getSelectedItem()) {
            comboModel.setSelectedItem(lastPathComponent);
            this.fireActionEvent();
        }
    }

    private void init() {
        this.tree = new JTree();
        this.tree.addMouseListener(new TreeClickListener());
        this.tree.addMouseMotionListener(new TreeMouseListener());
        this.tree.setFocusable(false);
        this.addKeyListener(new KeyExpandListener());
        this.sp = new JScrollPane(this.tree, 20, 30);
        this.sp.setBorder(BorderFactory.createEmptyBorder());
        this.setPopupComponent(this.sp);
    }

    public void setMinimumPopupSize(Dimension minSize) {
        this.minSize = minSize;
    }

    public Dimension getMinimumPopupSize() {
        return this.minSize;
    }

    public void setMaximumPopupSize(Dimension maxSize) {
        this.maxSize = maxSize;
    }

    public Dimension getMaximumPopupSize() {
        return this.maxSize;
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTreeComboBox();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTreeComboBox
    extends JComboBox.AccessibleJComboBox {
        private Accessible previousSelectedAccessible;

        AccessibleJTreeComboBox() {
            super(JTreeCombo.this);
            this.previousSelectedAccessible = null;
            JTreeCombo.this.tree.addTreeSelectionListener(new AccessibleJComboBoxTreeSelectionListener());
            JTreeCombo.this.addPopupMenuListener(new AccessibleJComboBoxPopupMenuListener());
        }

        @Override
        public String getAccessibleName() {
            int i = JTreeCombo.this.tree.getRowForPath(JTreeCombo.this.tree.getSelectionPath());
            return JTreeCombo.this.tree.convertValueToText(JTreeCombo.this.getModel().getSelectedItem(), true, false, false, i, true);
        }

        private class AccessibleJComboBoxPopupMenuListener
        implements PopupMenuListener {
            private AccessibleJComboBoxPopupMenuListener() {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                TreePath selectedPath = JTreeCombo.this.tree.getSelectionPath();
                if (selectedPath == null) {
                    return;
                }
                AccessibleJTreeComboBox.this.previousSelectedAccessible = JTreeCombo.this.tree.getAccessibleContext().getAccessibleChild(JTreeCombo.this.tree.getRowForPath(selectedPath));
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        }

        private class AccessibleJComboBoxTreeSelectionListener
        implements TreeSelectionListener {
            private AccessibleJComboBoxTreeSelectionListener() {
            }

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath selectedPath = JTreeCombo.this.tree.getSelectionPath();
                if (selectedPath == null) {
                    return;
                }
                Accessible selectedAccessible = JTreeCombo.this.tree.getAccessibleContext().getAccessibleChild(JTreeCombo.this.tree.getRowForPath(selectedPath));
                if (selectedAccessible == null) {
                    return;
                }
                PropertyChangeEvent pce = null;
                if (AccessibleJTreeComboBox.this.previousSelectedAccessible != null) {
                    pce = new PropertyChangeEvent(AccessibleJTreeComboBox.this.previousSelectedAccessible, "AccessibleState", AccessibleState.FOCUSED, null);
                    AccessibleJTreeComboBox.this.firePropertyChange("AccessibleState", null, pce);
                }
                pce = new PropertyChangeEvent(selectedAccessible, "AccessibleState", null, AccessibleState.FOCUSED);
                AccessibleJTreeComboBox.this.firePropertyChange("AccessibleState", null, pce);
                AccessibleJTreeComboBox.this.firePropertyChange("AccessibleActiveDescendant", AccessibleJTreeComboBox.this.previousSelectedAccessible, selectedAccessible);
                AccessibleJTreeComboBox.this.previousSelectedAccessible = selectedAccessible;
            }
        }
    }

    private class TreeClickListener
    extends MouseAdapter {
        private TreeClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Object obj;
            TreePath path = JTreeCombo.this.tree.getPathForLocation(e.getX(), e.getY());
            if (path != null && (obj = path.getLastPathComponent()) != null) {
                JTreeCombo.this.setSelectedItem(obj);
                JTreeCombo.this.hidePopup();
            }
        }
    }

    private class TreeMouseListener
    extends MouseMotionAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            TreePath path = JTreeCombo.this.tree.getPathForLocation(e.getX(), e.getY());
            JTreeCombo.this.tree.setSelectionPath(path);
        }
    }

    private class KeyExpandListener
    extends KeyAdapter {
        private KeyExpandListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreePath tp;
            if (e.getKeyCode() == 37) {
                tp = JTreeCombo.this.tree.getSelectionPath();
                JTreeCombo.this.tree.collapsePath(tp);
            }
            if (e.getKeyCode() == 39) {
                tp = JTreeCombo.this.tree.getSelectionPath();
                JTreeCombo.this.tree.expandPath(tp);
            }
        }
    }
}

