/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checktree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.javatools.ui.TriStateCheckBox;
import oracle.javatools.ui.checktree.TriStateNode;

public class CheckboxTree
extends JTree {
    public CheckboxTree() {
        this._init();
    }

    public CheckboxTree(TreeModel model) {
        super(model);
        this._init();
    }

    @Override
    public void setModel(TreeModel model) {
        super.setModel(model);
    }

    private void _init() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath path = CheckboxTree.this.getSelectionPath();
                if (path != null && !CheckboxTree.this.isEditing()) {
                    CheckboxTree.this.startEditingAtPath(path);
                    if (e.getKeyCode() == 32) {
                        ((CheckboxCellEditor)CheckboxTree.this.getCellEditor()).setPressed(true);
                    }
                }
            }
        });
        this.setCellEditor(new CheckboxCellEditor());
        this.setCellRenderer(new CheckboxCellRenderer());
        this.setEditable(true);
    }

    private class CheckboxCellEditor
    extends CheckboxIconLabel
    implements TreeCellEditor {
        private TriStateNode node;

        public CheckboxCellEditor() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 0));
            this.setFont(UIManager.getFont("Tree.font"));
            this.checkbox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (CheckboxCellEditor.this.node != null) {
                        TriStateCheckBox.State state = CheckboxCellEditor.this.checkbox.getState();
                        if (state == TriStateCheckBox.State.PARTIAL) {
                            CheckboxCellEditor.this.node.setNodeState(TriStateNode.NodeState.PARTIAL);
                        } else if (state == TriStateCheckBox.State.TRUE) {
                            CheckboxCellEditor.this.node.setNodeState(TriStateNode.NodeState.YES);
                        } else {
                            CheckboxCellEditor.this.node.setNodeState(TriStateNode.NodeState.NO);
                        }
                    }
                    CheckboxTree.this.repaint();
                }
            });
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.node = null;
            if (value instanceof TriStateNode) {
                TriStateNode node = (TriStateNode)value;
                if (node.getNodeState() == TriStateNode.NodeState.YES) {
                    this.checkbox.setState(TriStateCheckBox.State.TRUE);
                } else if (node.getNodeState() == TriStateNode.NodeState.NO) {
                    this.checkbox.setState(TriStateCheckBox.State.FALSE);
                } else {
                    this.checkbox.setState(TriStateCheckBox.State.PARTIAL);
                }
                this.label.setText(node.getLabel());
                this.label.setIcon(node.getIcon());
                this.label.isSelected = true;
                this.label.hasFocus = true;
                this.node = node;
            }
            return this;
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkbox.isSelected();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.node = null;
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.node = null;
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
        }

        public void setPressed(boolean b) {
            this.checkbox.getModel().setArmed(true);
            this.checkbox.getModel().setPressed(b);
        }

        @Override
        protected TriStateCheckBox createCheckBox() {
            TriStateCheckBox newCheckBox = new TriStateCheckBox(){

                @Override
                protected void processKeyEvent(KeyEvent event) {
                    super.processKeyEvent(event);
                    if (event.getKeyCode() == 112) {
                        return;
                    }
                    if (event.getSource() != CheckboxTree.this) {
                        CheckboxTree.this.dispatchEvent(new KeyEvent(CheckboxTree.this, event.getID(), event.getWhen(), event.getModifiers(), event.getKeyCode(), event.getKeyChar()));
                    }
                }
            };
            return newCheckBox;
        }
    }

    private class CheckboxCellRenderer
    extends CheckboxIconLabel
    implements TreeCellRenderer {
        public CheckboxCellRenderer() {
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 0));
            this.setFont(UIManager.getFont("Tree.font"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof TriStateNode) {
                TriStateNode node = (TriStateNode)value;
                if (node.getNodeState() == TriStateNode.NodeState.YES) {
                    this.checkbox.setState(TriStateCheckBox.State.TRUE);
                } else if (node.getNodeState() == TriStateNode.NodeState.NO) {
                    this.checkbox.setState(TriStateCheckBox.State.FALSE);
                } else {
                    this.checkbox.setState(TriStateCheckBox.State.PARTIAL);
                }
                this.label.setText(node.getLabel());
                this.label.setIcon(node.getIcon());
            }
            this.label.isSelected = selected;
            this.label.hasFocus = hasFocus;
            return this;
        }
    }

    private static class SelectableLabel
    extends JLabel {
        protected boolean isSelected = false;
        protected boolean hasFocus = false;

        private SelectableLabel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            int x;
            Insets i;
            if (this.isSelected) {
                this.setOpaque(false);
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
                g.setColor(UIManager.getColor("Tree.selectionBackground"));
                i = this.getInsets();
                x = i.left;
                if (this.getIcon() != null) {
                    x += this.getIcon().getIconWidth() + this.getIconTextGap() - 1;
                }
                g.fillRect(x, i.top, this.getWidth() - i.left - i.right - 1, this.getHeight() - i.top - i.bottom - 1);
            } else {
                this.setForeground(UIManager.getColor("Tree.foreground"));
            }
            if (this.hasFocus) {
                this.setOpaque(false);
                g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                i = this.getInsets();
                x = i.left;
                if (this.getIcon() != null) {
                    x += this.getIcon().getIconWidth() + this.getIconTextGap() - 1;
                }
                g.drawRect(x, i.top, this.getWidth() - i.left - i.right - 1, this.getHeight() - i.top - i.bottom - 1);
            }
            super.paintComponent(g);
        }
    }

    private class CheckboxIconLabel
    extends JPanel {
        protected TriStateCheckBox checkbox;
        protected SelectableLabel label = new SelectableLabel();

        CheckboxIconLabel() {
            this.checkbox = this.createCheckBox();
            this.setLayout(new BorderLayout(2, 0));
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.label, "Center");
        }

        protected TriStateCheckBox createCheckBox() {
            TriStateCheckBox cb = new TriStateCheckBox();
            cb.setOpaque(false);
            return cb;
        }
    }
}

