/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.util.MenuUtils;

class StatusButton
extends JToggleButton {
    private static final PopupMenuListener _POPUP_MENU_LISTENER = new ButtonPopupMenuListener();
    private static final Icon _POPUP_ICON = new PopupIndicator();
    private static final int _POPUP_WIDTH = Math.max(3 + _POPUP_ICON.getIconWidth() + 3, 13);
    private static final String _ACTION_SHOW_POPUP_MENU = "ShowPopupMenu";
    private static final ShowPopupListener _ADAPTER = new ShowPopupListener();
    private static final ShowPopupAction _POP_ACTION = new ShowPopupAction();
    private JPopupMenu _popup;
    private boolean _stepSelected;

    public StatusButton() {
        this.setFocusPainted(false);
        this.setHorizontalAlignment(2);
        this.setModel(this.createModel());
        this.setRolloverEnabled(true);
        this.addMouseListener(_ADAPTER);
        this._createKeyBindings();
    }

    public void setMenuActions(Action[] actions) {
        if (actions == null) {
            this.releasePopupMenu();
        } else {
            this.createPopupMenu();
            for (int i = 0; i < actions.length; ++i) {
                Action action = actions[i];
                if (action != null) {
                    this._popup.add(action);
                    continue;
                }
                this._popup.addSeparator();
            }
        }
    }

    protected ButtonModel createModel() {
        return new JToggleButton.ToggleButtonModel(){

            @Override
            public boolean isSelected() {
                return StatusButton.this.isPopupVisible();
            }
        };
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.isPreferredSizeSet() || this._popup == null || this._popup.getComponentCount() == 0) {
            return size;
        }
        size.width += _POPUP_WIDTH + 1;
        return size;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._popup != null) {
            SwingUtilities.updateComponentTreeUI(this._popup);
        }
        this._updateBorder();
    }

    @Override
    public boolean isOpaque() {
        return this.hasFocus() || this.getModel().isRollover() || this.getModel().isSelected();
    }

    @Override
    public Color getForeground() {
        if (this._stepSelected && !this.hasFocus() && !this.getModel().isRollover() && !this.getModel().isSelected()) {
            return Color.white;
        }
        return super.getForeground();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this._popup == null || this._popup.getComponentCount() == 0) {
            return;
        }
        if (this.isEnabled() && (this.hasFocus() || this.getModel().isRollover() || this.getModel().isSelected())) {
            int xoff = -1;
            int x = w - 1 - (_POPUP_WIDTH + _POPUP_ICON.getIconWidth()) / 2 + -1;
            int y = (h - 1 - _POPUP_ICON.getIconHeight()) / 2;
            _POPUP_ICON.paintIcon(this, g, x, y);
        }
    }

    protected JPopupMenu createPopupMenu() {
        if (this._popup == null) {
            this._popup = new JPopupMenu();
            this._popup.addPopupMenuListener(_POPUP_MENU_LISTENER);
            this.invalidate();
        } else {
            this._popup.removeAll();
        }
        return this._popup;
    }

    protected void releasePopupMenu() {
        if (this._popup != null) {
            this._popup.removePopupMenuListener(_POPUP_MENU_LISTENER);
            this._popup.removeAll();
            this._popup = null;
            this.invalidate();
        }
    }

    protected boolean hasPopup() {
        return this._popup != null;
    }

    protected boolean isPopupVisible() {
        return this._popup != null && this._popup.isVisible();
    }

    void setStepSelected(boolean select) {
        this._stepSelected = select;
    }

    private static void _sShowPopupMenu(StatusButton b) {
        if (b.hasPopup() && b.isEnabled()) {
            MenuUtils.showPopupMenu((JPopupMenu)b._popup, (Component)b, (int)0, (int)b.getHeight());
        }
    }

    private void _updateBorder() {
        JToolBar tool = new JToolBar();
        JToggleButton t = new JToggleButton();
        tool.add(t);
        this.setBorder(t.getBorder());
    }

    private void _createKeyBindings() {
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), _ACTION_SHOW_POPUP_MENU);
        this.getActionMap().put(_ACTION_SHOW_POPUP_MENU, _POP_ACTION);
    }

    private static class ButtonPopupMenuListener
    implements PopupMenuListener {
        private ButtonPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            JPopupMenu popup = (JPopupMenu)e.getSource();
            AbstractButton b = (AbstractButton)popup.getInvoker();
            b.getModel().setArmed(false);
            b.setSelected(false);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            Component[] comps;
            JPopupMenu popup = (JPopupMenu)e.getSource();
            for (Component comp : comps = popup.getComponents()) {
                JMenuItem item;
                if (!(comp instanceof JMenuItem)) continue;
                Action a = (item = (JMenuItem)comp).getAction();
                item.setEnabled(a != null ? item.getAction().isEnabled() : true);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private static final class PopupIndicator
    extends Polygon
    implements Icon {
        private static final int SIZE = 4;

        public PopupIndicator() {
            this.addPoint(0, 0);
            this.addPoint(2, 2);
            this.addPoint(4, 0);
        }

        @Override
        public int getIconHeight() {
            return this.getBounds().height;
        }

        @Override
        public int getIconWidth() {
            return this.getBounds().width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.isEnabled()) {
                this.paint(g, x, y, c.getForeground());
            } else {
                this.paint(g, x, y, c.getBackground().darker());
            }
        }

        private void paint(Graphics g, int x, int y, Color color) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(color);
            g.fillPolygon(this);
            g.drawPolygon(this);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private static class ShowPopupAction
    extends AbstractAction {
        private ShowPopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StatusButton._sShowPopupMenu((StatusButton)e.getSource());
        }
    }

    private static class ShowPopupListener
    extends MouseAdapter {
        private ShowPopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            StatusButton._sShowPopupMenu((StatusButton)e.getComponent());
        }
    }
}

