/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.util.Calendar;
import java.util.Date;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.javatools.ui.calendar.DayComponent;

final class YearComponent
extends JSpinner
implements ChangeListener {
    private Calendar _cal;
    private DayComponent _dp;
    private final int _MAX_ALLOWED_YEAR = 9999;
    private final int _MIN_ALLOWED_YEAR = 1;

    public YearComponent(Calendar cal, DayComponent dp) {
        this._cal = cal;
        this._dp = dp;
        this._init();
    }

    private void _init() {
        SpinnerDateModel dateModel = new SpinnerDateModel();
        dateModel.setCalendarField(1);
        this.setModel(dateModel);
        Calendar cloneCal = (Calendar)this._cal.clone();
        cloneCal.set(1, 0, 1);
        dateModel.setStart(cloneCal.getTime());
        cloneCal.set(9999, 1, 1);
        dateModel.setEnd(cloneCal.getTime());
        this.setEditor(new JSpinner.DateEditor((JSpinner)this, "yyyy"));
        this.setValue(this._cal.getTime());
        this.setOpaque(false);
        this.addChangeListener(this);
    }

    public void updateDisplay() {
        this.setValue(this._cal.getTime());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Date date = (Date)this.getValue();
        Calendar cal = (Calendar)this._cal.clone();
        cal.setTime(date);
        int year = cal.get(1);
        this._cal.set(5, 1);
        this._cal.set(1, year);
        this._dp.rebuild();
    }

    public void cleanUp() {
        this._cal = null;
        this._dp = null;
    }
}

