/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import oracle.javatools.ui.calendar.CalendarPanel;

final class TimeEditPanel
extends JPanel {
    private Locale _locale;
    private JSpinner _timeSpinner;
    private JComboBox _timeZoneCombo;
    private CalendarPanel _calendarPanel;

    public TimeEditPanel(Locale locale, CalendarPanel calendarPanel) {
        this._locale = locale;
        this._calendarPanel = calendarPanel;
        this._init();
    }

    private void _init() {
        this._timeSpinner = new JSpinner(new SpinnerDateModel(this._calendarPanel.getCalendar().getTime(), null, null, 11));
        this._updateTimeSpinnerFormat();
        this._timeZoneCombo = new JComboBox<TimeZone>(this._getTimeZoneIDs());
        this._timeZoneCombo.setRenderer(new TimeZoneRenderer());
        this._timeZoneCombo.setBackground(UIManager.getColor("TextArea.background"));
        this._timeZoneCombo.setFont(UIManager.getFont("Label.font"));
        this._timeZoneCombo.setPrototypeDisplayValue("WWWWWWWWWWWWWWW");
        this._timeZoneCombo.setBorder(null);
        this._timeSpinner.setAlignmentX(0.5f);
        this._timeZoneCombo.setAlignmentX(0.5f);
        this.setOpaque(false);
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 2, 0);
        gbl.setConstraints(this._timeSpinner, c);
        gbl.setConstraints(this._timeZoneCombo, c);
        this.add(this._timeSpinner);
        this.add(this._timeZoneCombo);
        this.updateTimeDisplay();
        this.updateTimeZoneDisplay();
        TimeChangeListener timeListener = new TimeChangeListener();
        this._timeSpinner.addChangeListener(timeListener);
        this._timeZoneCombo.addItemListener(timeListener);
    }

    public void updateDisplay() {
        this.updateTimeDisplay();
        this.updateTimeZoneDisplay();
    }

    public void updateTimeDisplay() {
        this._timeSpinner.setValue(this._calendarPanel.getCalendar().getTime());
        this._updateTimeSpinnerFormat();
    }

    public void updateTimeZoneDisplay() {
        TimeZone tz = this._calendarPanel.getCalendar().getTimeZone();
        tz = this.getNearestTimeZoneMatch(tz);
        this._timeZoneCombo.setSelectedItem(tz);
    }

    public TimeZone getNearestTimeZone(TimeZone timeZone) {
        TimeZone timeZoneFromList = null;
        long rawOffset = timeZone.getRawOffset();
        long minDifference = Long.MAX_VALUE;
        for (int i = 0; i < this._timeZoneCombo.getItemCount(); ++i) {
            TimeZone aTz = (TimeZone)this._timeZoneCombo.getItemAt(i);
            long aRawOffset = aTz.getRawOffset();
            long diff = Math.abs(aRawOffset - rawOffset);
            if (minDifference < diff) continue;
            minDifference = diff;
            timeZoneFromList = aTz;
        }
        return timeZoneFromList;
    }

    public TimeZone getNearestTimeZoneMatch(TimeZone tz) {
        String tzName = tz.getDisplayName(true, 1, this._locale);
        for (int i = 0; i < this._timeZoneCombo.getItemCount(); ++i) {
            TimeZone aTz = (TimeZone)this._timeZoneCombo.getItemAt(i);
            if (!aTz.getDisplayName(true, 1, this._locale).equals(tzName)) continue;
            return aTz;
        }
        return null;
    }

    private void _updateTimeSpinnerFormat() {
        JSpinner.DateEditor de = (JSpinner.DateEditor)this._timeSpinner.getEditor();
        de.getTextField().setHorizontalAlignment(0);
        DateFormat df = SimpleDateFormat.getTimeInstance(2, this._locale);
        df.setTimeZone(this._calendarPanel.getCalendar().getTimeZone());
        DateFormatter dfer = new DateFormatter(df);
        DefaultFormatterFactory ff = new DefaultFormatterFactory(dfer);
        de.getTextField().setFormatterFactory(ff);
    }

    private TimeZone[] _getTimeZoneIDs() {
        HashSet<String> zoneNames = new HashSet<String>();
        LinkedList<TimeZone> zones = new LinkedList<TimeZone>();
        int gmt030704 = 11224000;
        for (String zoneID : TimeZone.getAvailableIDs()) {
            try {
                String displayName;
                TimeZone tz = TimeZone.getTimeZone(zoneID);
                long rawOffset = tz.getRawOffset();
                if (rawOffset == (long)gmt030704 || zoneNames.contains(displayName = tz.getDisplayName(true, 1, this._locale))) continue;
                zoneNames.add(displayName);
                zones.add(tz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return zones.toArray(new TimeZone[0]);
    }

    public void setShowTimeZone(boolean showTimeZone) {
        this._timeZoneCombo.setVisible(showTimeZone);
    }

    public boolean getShowTimeZone() {
        return this._timeZoneCombo.isVisible();
    }

    public void setShowTime(boolean showTimeZone) {
        this._timeSpinner.setVisible(showTimeZone);
    }

    public boolean getShowTime() {
        return this._timeSpinner.isVisible();
    }

    private class TimeChangeListener
    implements ChangeListener,
    ItemListener {
        private TimeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Date time = (Date)TimeEditPanel.this._timeSpinner.getValue();
            Calendar timeCal = (Calendar)TimeEditPanel.this._calendarPanel.getCalendar().clone();
            timeCal.setTime(time);
            TimeEditPanel.this._calendarPanel.getCalendar().set(11, timeCal.get(11));
            TimeEditPanel.this._calendarPanel.getCalendar().set(12, timeCal.get(12));
            TimeEditPanel.this._calendarPanel.getCalendar().set(13, timeCal.get(13));
            TimeEditPanel.this._calendarPanel.fireSelectionAction();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            TimeEditPanel.this._calendarPanel.getCalendar().setTimeZone((TimeZone)TimeEditPanel.this._timeZoneCombo.getSelectedItem());
            TimeEditPanel.this.updateTimeDisplay();
            TimeEditPanel.this._calendarPanel.fireSelectionAction();
        }
    }

    private class TimeZoneRenderer
    extends DefaultListCellRenderer {
        private TimeZoneRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TimeZone) {
                TimeZone tz = (TimeZone)value;
                label.setText(tz.getDisplayName(true, 1, TimeEditPanel.this._locale));
            } else if (value instanceof String) {
                label.setText((String)value);
            }
            label.setHorizontalAlignment(index == -1 ? 0 : 10);
            label.setAlignmentX(index == -1 ? 0.5f : 0.0f);
            return label;
        }
    }
}

