/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.breadcrumbs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import oracle.javatools.ui.breadcrumbs.AttributedBreadcrumb;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.simplestyle.StyledTextModel;
import oracle.javatools.ui.simplestyle.StyledTextRenderer;

class BreadcrumbsButton
extends JButton {
    private Breadcrumb breadcrumb;
    private int index = -1;
    private StyledTextModel styledModel;
    private static Color highlightOverlayColor = new Color(255, 255, 255, 50);
    private static int firstOverlapMargin = 4;
    private static int overlapMargin = 14;
    private static int noPeersMargin = 12;
    private static int peersMargin = 23;
    private static int peersSize = 8;
    private JComponent peersComponent;
    private boolean hasPeers;
    private Stroke lineStroke = new BasicStroke(0.75f, 1, 1);

    public BreadcrumbsButton(Breadcrumb breadcrumb, StyledTextModel styledModel, int index) {
        this(breadcrumb, styledModel, index, false);
    }

    public BreadcrumbsButton(Breadcrumb breadcrumb, StyledTextModel styledModel, int index, boolean hasPeers) {
        this.breadcrumb = breadcrumb;
        this.index = index;
        this.styledModel = styledModel;
        this.hasPeers = hasPeers;
        this.setRolloverEnabled(true);
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setBorder(BorderFactory.createEmptyBorder(0, index == 0 ? firstOverlapMargin : overlapMargin, 1, hasPeers ? peersMargin : noPeersMargin));
        this.setOpaque(false);
        this.setLayout(null);
        this.setForeground(UIManager.getColor("TextArea.foreground"));
        if (hasPeers) {
            this.addPeersComponent();
        }
    }

    public boolean hasPeers() {
        return this.hasPeers;
    }

    public int getIndex() {
        return this.index;
    }

    public void setText(StyledTextModel styledModel) {
        this.styledModel = styledModel;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.peersComponent != null) {
            this.peersComponent.setLocation(this.getWidth() - 1 - peersSize - 8, (this.getHeight() - 1) / 2 - peersSize / 2);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int h = (this.getHeight() - 1) / 2;
        int x = this.index == 0 ? 0 : 4;
        int w = this.getWidth() - 1;
        g2.setStroke(this.lineStroke);
        GeneralPath boundsPath = new GeneralPath();
        boundsPath.moveTo(x, 0.0f);
        boundsPath.lineTo(w - h, 0.0f);
        boundsPath.lineTo(w, h);
        boundsPath.lineTo(w - h, this.getHeight() - 1);
        boundsPath.lineTo(x, this.getHeight() - 1);
        if (this.index > 0) {
            boundsPath.lineTo(x + h, h);
        }
        boundsPath.lineTo(x, 0.0f);
        AttributedBreadcrumb attributedBreadcrumb = this.breadcrumb instanceof AttributedBreadcrumb ? (AttributedBreadcrumb)((Object)this.breadcrumb) : null;
        Color bgColor = this.getBackground();
        if (attributedBreadcrumb != null && attributedBreadcrumb.hasAttribute(AttributedBreadcrumb.Attribute.BACKGROUND_COLOR)) {
            bgColor = (Color)attributedBreadcrumb.getAttribute(AttributedBreadcrumb.Attribute.BACKGROUND_COLOR);
        }
        g2.setColor(bgColor);
        g2.fill(boundsPath);
        if (this.model.isRollover()) {
            g2.setColor(UIManager.getColor("TextArea.selectionBackground"));
            g2.fill(boundsPath);
        }
        if (this.hasFocus()) {
            g2.setColor(highlightOverlayColor);
            g2.fill(boundsPath);
        }
        g2.setColor(UIManager.getColor("ScrollBar.thumbShadow"));
        g2.draw(boundsPath);
        if (this.model.isRollover()) {
            g2.setColor(UIManager.getColor("TextField.selectionForeground"));
        } else if (attributedBreadcrumb != null && attributedBreadcrumb.hasAttribute(AttributedBreadcrumb.Attribute.FOREGROUND_COLOR)) {
            g2.setColor((Color)attributedBreadcrumb.getAttribute(AttributedBreadcrumb.Attribute.FOREGROUND_COLOR));
        } else {
            g2.setColor(UIManager.getColor("TextField.foreground"));
        }
        StyledTextRenderer.renderText(this, g2, this.styledModel, this.getInsets().left + 2, this.getInsets().top);
        g2.dispose();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = StyledTextRenderer.getPreferredSize(this, this.styledModel);
        Insets insets = this.getInsets();
        d.width += insets.left + insets.right;
        d.height += insets.top + insets.bottom;
        return d;
    }

    private void addPeersComponent() {
        this.peersComponent = new JLabel(new DownIcon());
        this.peersComponent.setSize(peersSize, peersSize);
        this.peersComponent.setOpaque(false);
        this.add(this.peersComponent);
    }

    Rectangle getPeersComponentRectangle() {
        return this.peersComponent.getBounds();
    }

    private static class DownIcon
    implements Icon {
        private DownIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(x, y + 1);
            g.setColor(UIManager.getColor("Label.foreground"));
            GeneralPath path = new GeneralPath();
            path.moveTo(0.0f, 2.0f);
            path.lineTo(7.0f, 2.0f);
            path.lineTo(3.0f, 6.0f);
            g2.fill(path);
            g2.translate(-x, -y - 1);
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }
    }
}

