/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.balloon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Components;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.balloon.Balloon;
import oracle.javatools.ui.balloon.BalloonBorder;
import oracle.javatools.ui.balloon.BalloonConstraint;

public final class BalloonManager {
    public static final int TTL_ACTION_SUCCESS = 15000;
    public static final int TTL_ACTION_FAILURE = 20000;
    public static final int TTL_OPTIONAL_USER_TASK = 25000;
    private static final int BALLOON_LAYER = JLayeredPane.MODAL_LAYER + 20;
    private static final Object CP_BALLOON = "oracle.javatools.ui.balloon.balloonClientProperty";
    private static final Object CP_TARGET = "oracle.javatools.ui.balloon.targetClientProperty";
    private static final Object CP_MANAGER = "oracle.javatools.ui.balloon.balloonManager";
    private final JComponent targetComponent;
    private final ComponentListener componentListener = new BMComponentListener();
    private final BMContainerListener containerListener = new BMContainerListener();
    private static final Map<Component, BMRootListener> _rootListener = new HashMap<Component, BMRootListener>();

    private BalloonManager(JComponent targetComponent) {
        this.targetComponent = targetComponent;
    }

    public static BalloonManager forTarget(JComponent target) {
        if (target == null) {
            throw new NullPointerException("targetComponent must not be null");
        }
        BalloonManager mgr = (BalloonManager)target.getClientProperty(CP_MANAGER);
        if (mgr != null) {
            return mgr;
        }
        mgr = new BalloonManager(target);
        target.putClientProperty(CP_MANAGER, mgr);
        return mgr;
    }

    public Balloon balloon() {
        return BalloonManager.balloon(this.targetComponent);
    }

    private static Balloon balloon(JComponent targetComponent) {
        return (Balloon)targetComponent.getClientProperty(CP_BALLOON);
    }

    public void show(final Balloon balloon, int timeToLive) {
        BalloonManager.mustNotBeNull(balloon);
        if (timeToLive < 0) {
            throw new IllegalArgumentException("timeToLive must be >= 0: " + timeToLive);
        }
        if (BalloonManager.timerIsDisabled()) {
            this.show(balloon);
        }
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Timer timer = (Timer)ae.getSource();
                timer.removeActionListener(this);
                timer.stop();
                if (balloon.getParent() == null || BalloonManager.this.targetComponent.getParent() == null) {
                    return;
                }
                BalloonManager.this.hide(balloon);
            }
        };
        Timer t = new Timer(timeToLive, al);
        t.setRepeats(false);
        this.show(balloon);
        t.start();
    }

    private static void mustNotBeNull(Balloon balloon) {
        if (balloon == null) {
            throw new NullPointerException("balloon must not be null");
        }
    }

    private static boolean timerIsDisabled() {
        return Boolean.getBoolean("ide.balloons.disableTimer");
    }

    public void show(Balloon balloon) {
        BalloonManager.mustNotBeNull(balloon);
        JLayeredPane layeredPane = Components.findLayeredPane(this.targetComponent);
        if (layeredPane == null) {
            throw new IllegalStateException("targetComponent is not in a JFrame or JDialog: " + this.targetComponent);
        }
        if (!this.targetComponent.isVisible()) {
            throw new IllegalStateException("Target must be visible");
        }
        if (this.balloon() != null) {
            throw new IllegalStateException("Balloon is already showing for target component " + this.targetComponent);
        }
        this.maybeInstallCloseButton(balloon);
        layeredPane.add((Component)balloon, (Object)BALLOON_LAYER);
        balloon.setSize(balloon.getPreferredSize());
        BalloonManager.centerOnComponent(balloon, this.targetComponent);
        balloon.setVisible(true);
        balloon.validate();
        this.registerTarget(balloon);
    }

    public void hide(Balloon balloon) {
        this.unregisterTarget(this.targetComponent, null);
    }

    private void maybeInstallCloseButton(Balloon balloon) {
        if (balloon.component(BalloonConstraint.CLOSE_BUTTON) != null) {
            return;
        }
        balloon.add((Component)this.createCloseButton(balloon), (Object)BalloonConstraint.CLOSE_BUTTON);
    }

    private AbstractButton createCloseButton(Balloon balloon) {
        JButton button = new JButton(this.createCloseAction(balloon));
        button.setToolTipText(UIBundle.get("BALLOON_CLOSE"));
        LookAndFeel.installBorder(button, "Balloon.closeButtonBorder");
        button.setIcon(OracleIcons.getIcon((String)"extras/small_close.gif"));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setFocusPainted(false);
        button.setPreferredSize(new Dimension(14, 14));
        button.setContentAreaFilled(false);
        button.setOpaque(false);
        return button;
    }

    private Action createCloseAction(final Balloon balloon) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BalloonManager.this.hide(balloon);
            }
        };
    }

    private static void centerOnComponent(Balloon balloon, Component target) {
        Point targetLocationInWindow = BalloonManager.positionInLayeredPane(target);
        int posX = targetLocationInWindow.x + target.getWidth() / 2;
        int posY = targetLocationInWindow.y;
        BalloonBorder border = (BalloonBorder)balloon.getBorder();
        Point balloonPointerLocation = border.getPointerLocation(balloon);
        int balloonTopLeftX = posX - balloonPointerLocation.x;
        int balloonTopLeftY = posY - balloonPointerLocation.y;
        balloon.setLocation(balloonTopLeftX, balloonTopLeftY);
    }

    private static Point positionInLayeredPane(Component c) {
        Point p = new Point();
        p.x = c.getLocation().x;
        p.y = c.getLocation().y;
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            Point parentLoc = parent.getLocation();
            p.x += parentLoc.x;
            p.y += parentLoc.y;
            if (parent instanceof JLayeredPane) break;
        }
        return p;
    }

    private void registerTarget(Balloon balloon) {
        this.targetComponent.addComponentListener(this.componentListener);
        this.targetComponent.putClientProperty(CP_BALLOON, balloon);
        balloon.putClientProperty(CP_TARGET, this.targetComponent);
        this.targetComponent.getParent().addContainerListener(this.containerListener);
        Component root = SwingUtilities.getRoot(this.targetComponent);
        BMRootListener l = _rootListener.get(root);
        if (l == null) {
            l = new BMRootListener(root);
            _rootListener.put(root, l);
        }
        l.addTrackedComponent(this.targetComponent);
    }

    private void unregisterTarget(final JComponent target, Container parent) {
        if (parent == null) {
            parent = target.getParent();
        }
        if (parent == null || this.balloon() == null) {
            return;
        }
        target.removeComponentListener(this.componentListener);
        parent.removeContainerListener(this.containerListener);
        Component root = SwingUtilities.getRoot(parent);
        BMRootListener l = _rootListener.get(root);
        if (l != null) {
            l.removeTrackedComponent(target);
        }
        this.balloon().setVisible(false);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BalloonManager.this.balloon() != null) {
                    BalloonManager.this.balloon().getParent().remove(BalloonManager.this.balloon());
                    BalloonManager.this.balloon().putClientProperty(CP_TARGET, null);
                    target.putClientProperty(CP_BALLOON, null);
                }
            }
        });
    }

    private static class BMRootListener
    extends ComponentAdapter {
        private Component _root = null;
        private Set<JComponent> _trackedComponents = new HashSet<JComponent>();

        BMRootListener(Component root) {
            root.addComponentListener(this);
            this._root = root;
        }

        public void addTrackedComponent(JComponent c) {
            this._trackedComponents.add(c);
        }

        public void removeTrackedComponent(JComponent c) {
            this._trackedComponents.remove(c);
            if (this._trackedComponents.isEmpty()) {
                this._root.removeComponentListener(this);
                _rootListener.remove(this._root);
                this._root = null;
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            for (JComponent c : this._trackedComponents) {
                Balloon b = BalloonManager.balloon(c);
                if (b == null) continue;
                BalloonManager.centerOnComponent(b, c);
            }
        }
    }

    private class BMContainerListener
    extends ContainerAdapter
    implements ComponentListener {
        private BMContainerListener() {
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            Component target = e.getChild();
            if (target != BalloonManager.this.targetComponent) {
                return;
            }
            BalloonManager.this.unregisterTarget((JComponent)target, e.getContainer());
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.updateChildren(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.updateChildren(e);
        }

        private void updateChildren(ComponentEvent e) {
            BalloonManager.centerOnComponent(BalloonManager.this.balloon(), BalloonManager.this.targetComponent);
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    private class BMComponentListener
    extends ComponentAdapter {
        private BMComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            BalloonManager.this.unregisterTarget((JComponent)e.getSource(), null);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.centerBalloon(e);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.centerBalloon(e);
        }

        private void centerBalloon(ComponentEvent e) {
            JComponent sourceComponent = (JComponent)e.getSource();
            BalloonManager.centerOnComponent(BalloonManager.this.balloon(), sourceComponent);
        }
    }
}

