/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

public class TextLayer<V extends JComponent>
extends AbstractLayerUI<V> {
    private String text = "";
    private boolean displayText = true;
    private Color foreground = UIManager.getColor("TextArea.inactiveForeground");
    private Font font = REGULAR_FONT;
    public static final Font REGULAR_FONT = UIManager.getFont("Label.font").deriveFont(1, 12.0f);
    public static final Font LARGE_FONT = UIManager.getFont("Label.font").deriveFont(1, 16.0f);

    public TextLayer(String text) {
        this.setText(text);
    }

    public final void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Text cannot be null");
        }
        this.text = text;
    }

    public final String getText() {
        return this.text;
    }

    public final void setTextVisible(boolean displayText) {
        this.displayText = displayText;
    }

    public final boolean isTextVisible() {
        return this.displayText;
    }

    public final void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public final Color getForeground() {
        return this.foreground;
    }

    protected void paintLayer(Graphics2D g2, JXLayer<? extends V> l) {
        l.paint((Graphics)g2);
        if (this.displayText) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AttributedString string = new AttributedString(this.text, this.font.getAttributes());
            LineBreakMeasurer lbMeasurer = new LineBreakMeasurer(string.getIterator(), g2.getFontRenderContext());
            ArrayList<TextLayout> layouts = new ArrayList<TextLayout>();
            TextLayout textLayout = lbMeasurer.nextLayout(l.getWidth());
            while (textLayout != null) {
                layouts.add(textLayout);
                textLayout = lbMeasurer.nextLayout(l.getWidth());
            }
            int h = 0;
            for (TextLayout layout : layouts) {
                h = (int)((double)h + layout.getBounds().getHeight());
            }
            int interlineGap = h / layouts.size() / 2;
            int y = l.getHeight() / 2 - (h += interlineGap * (layouts.size() - 1)) / 2;
            for (TextLayout layout : layouts) {
                Rectangle2D textBounds = layout.getBounds();
                y = (int)((float)y + layout.getAscent());
                int x = (int)((double)(l.getWidth() / 2) - textBounds.getWidth() / 2.0);
                g2.setColor(UIManager.getColor("TextArea.background"));
                layout.draw(g2, (float)x + 0.75f, (float)y + 0.75f);
                g2.setColor(this.foreground);
                layout.draw(g2, x, y);
                y += interlineGap;
            }
        }
    }

    public final void setFont(Font font) {
        this.font = font;
    }

    public final Font getFont() {
        return this.font;
    }
}

