/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import oracle.javatools.annotations.NotNull;
import oracle.javatools.ui.UnknownActionException;
import oracle.javatools.ui.ghost.UIConstants;

public final class RichHintLabel
extends JEditorPane {
    private final Map<String, Action> _actions = new HashMap<String, Action>();

    public RichHintLabel() {
        this.configureTextPane();
    }

    private JEditorPane pane() {
        return this;
    }

    public void registerAction(@NotNull String id, @NotNull Action action) {
        if (id == null) {
            throw new NullPointerException("action is null");
        }
        if (action == null) {
            throw new NullPointerException("action is null");
        }
        this._actions.put(id, action);
    }

    public void unregisterAction(String id) {
        this._actions.remove(id);
    }

    public void setHtmlText(@NotNull String htmlText) {
        if (htmlText == null) {
            throw new NullPointerException("htmlText is null");
        }
        this.pane().setText(this.adjustHtml(htmlText));
    }

    @NotNull
    public String getHtmlText() {
        return this.pane().getText();
    }

    private String adjustHtml(String originalHtml) {
        return this.surroundWithHtml(originalHtml);
    }

    private String surroundWithHtml(String text) {
        return "<html><p>" + text + "</p></html>";
    }

    private void configureTextPane() {
        this.pane().putClientProperty(UIConstants.VETO_CONVERSION, true);
        this.pane().setEditorKit(new RichHintLabelEditorKit());
        this.pane().setBorder(BorderFactory.createEmptyBorder());
        this.pane().setEditable(false);
        this.pane().setFocusable(false);
        this.pane().setHighlighter(null);
        this.pane().setOpaque(false);
        this.pane().addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                String actionId = null;
                Action action = null;
                if (e.getURL() != null) {
                    URL url = e.getURL();
                    actionId = url.getPath();
                    action = (Action)RichHintLabel.this._actions.get(url.getPath());
                } else {
                    actionId = e.getDescription();
                    action = (Action)RichHintLabel.this._actions.get(e.getDescription());
                }
                if (action == null) {
                    throw new UnknownActionException(actionId);
                }
                action.actionPerformed(new ActionEvent(RichHintLabel.this, 1001, actionId));
            }
        });
    }

    private static String displayPropertiesToCSS(Font font) {
        StringBuilder rule = new StringBuilder("body {");
        if (font != null) {
            rule.append(" font-family: ");
            rule.append(font.getFamily());
            rule.append(" ; ");
            rule.append(" font-size: ");
            rule.append(font.getSize());
            rule.append("pt ;");
            if (font.isBold()) {
                rule.append(" font-weight: 700 ; ");
            }
            if (font.isItalic()) {
                rule.append(" font-style: italic ; ");
            }
        }
        rule.append(" color: #5A5A5A; ");
        rule.append(" }");
        return rule.toString();
    }

    private static class RichHintLabelEditorKit
    extends HTMLEditorKit {
        private static StyleSheet _defaultStyles;

        private RichHintLabelEditorKit() {
        }

        @Override
        public StyleSheet getStyleSheet() {
            if (_defaultStyles == null) {
                _defaultStyles = new StyleSheet();
                _defaultStyles.addStyleSheet(super.getStyleSheet());
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString("p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }"));
                _defaultStyles.addStyleSheet(this.createStyleSheetFromString(RichHintLabel.displayPropertiesToCSS(new JLabel().getFont())));
            }
            return _defaultStyles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StyleSheet createStyleSheetFromString(String s) {
            StyleSheet ss = new StyleSheet();
            StringReader r = null;
            try {
                r = new StringReader(s);
                ss.loadRules(r, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
            return ss;
        }

        @Override
        public Document createDefaultDocument() {
            StyleSheet styles = this.getStyleSheet();
            StyleSheet ss = new StyleSheet();
            ss.addStyleSheet(styles);
            return new MyDocument(ss);
        }
    }

    private static class MyDocument
    extends HTMLDocument {
        MyDocument(StyleSheet s) {
            super(s);
            this.setAsynchronousLoadPriority(Integer.MAX_VALUE);
        }
    }
}

