/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.HeaderEvent;
import oracle.javatools.ui.HeaderListener;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.internal.StretchIcon;
import oracle.javatools.ui.plaf.IconicButtonUI;

public final class Header
extends JComponent
implements Accessible {
    private static final StretchIcon _subsubBackgroundH = new StretchIcon(new ImageIcon(Header.class.getResource("/oracle/javatools/ui/images/headerbg.png")), new Insets(3, 3, 3, 3));
    private static final StretchIcon _subsubBackgroundV = new StretchIcon(new ImageIcon(Header.class.getResource("/oracle/javatools/ui/images/headerbgv.png")), new Insets(3, 3, 3, 3));
    private final ControlBar _toolbar = new ControlBar();
    private final JButton _disclosureIcon = new JButton();
    private final RotatingLabel _labelAndIcon = new RotatingLabel();
    private final RotatingLabel _rollupTextLabel = new RotatingLabel();
    private final JButton _helpIcon = new JButton();
    private String _helpTopicId;
    private Level _level;
    private boolean _expanded = true;
    private Orientation _orientation = Orientation.HORIZONTAL;
    private final Collection<HeaderListener> _listeners = new CopyOnWriteArrayList<HeaderListener>();
    private boolean _expandable = true;
    private AccessibleContext _ac;
    private static int _approximateButtonSize = -1;
    private static final Dimension ZERO_DIM = new Dimension(0, 0);
    private static final int BASE_PADDING = 3;
    private static final int MIN_ACTION_GAP = 15;

    @Override
    public void setForeground(Color c) {
        this._labelAndIcon.setForeground(c);
    }

    @Override
    public Color getForeground() {
        return this._labelAndIcon.getForeground();
    }

    public Header() {
        this.setExpanded(true);
        this.setLevel(Level.PAGE);
        this.setOrientation(Orientation.HORIZONTAL);
        this._toolbar.setBorder(BorderFactory.createEmptyBorder());
        this._toolbar.setOpaque(false);
        this._toolbar.setRollover(true);
        this._toolbar.setAlignment(4);
        this._disclosureIcon.setIcon(this.getExpansionIcon(true));
        this._disclosureIcon.addFocusListener(new FocusListener(){

            private void update() {
                Header.this._labelAndIcon.setSimulatedFocusPainted(Header.this._disclosureIcon.isEnabled() && Header.this._disclosureIcon.isVisible() && Header.this._disclosureIcon.hasFocus());
            }

            @Override
            public void focusGained(FocusEvent e) {
                this.update();
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.update();
            }
        });
        this.add(this._disclosureIcon);
        this.add(this._labelAndIcon);
        this.add(this._helpIcon);
        this.add(this._rollupTextLabel);
        this.add(this._toolbar);
        this.configureExpandAndCollapseActions();
        this.setOpaque(false);
        this._helpIcon.setIcon(OracleIcons.getIcon((String)"help.png"));
        this._helpIcon.setVisible(false);
        this._helpIcon.setToolTipText(UIBundle.get("HELP"));
        this.configureButton(this._disclosureIcon);
        this._disclosureIcon.setFocusPainted(false);
        this._disclosureIcon.setContentAreaFilled(false);
        this._disclosureIcon.setBorder(null);
        this.configureButton(this._helpIcon);
        this._toolbar.setVisible(false);
        this._rollupTextLabel.setForeground(new Color(96, 96, 96));
    }

    public JButton disclosureIcon() {
        return this._disclosureIcon;
    }

    private void configureExpandAndCollapseActions() {
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                if (SwingUtilities.isLeftMouseButton(me) && Header.this.isExpandable()) {
                    Header.this._disclosureIcon.doClick();
                    Header.this._disclosureIcon.requestFocus();
                }
            }
        };
        this._labelAndIcon.addMouseListener(ml);
        this._disclosureIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Header.this.setExpanded(!Header.this.isExpanded());
            }
        });
        AbstractAction expandAction = new AbstractAction("expand"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Header.this.setExpanded(true);
            }
        };
        AbstractAction collapseAction = new AbstractAction("collapse"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Header.this.setExpanded(false);
            }
        };
        this.getActionMap().put("expand", expandAction);
        this.getActionMap().put("collapse", collapseAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(37, 0), "collapse");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(39, 0), "expand");
    }

    public void setMinimumChars(int minimumChars) {
        if (minimumChars < 0) {
            throw new IllegalArgumentException("minimumChars is " + minimumChars + ". Must not be less than zero.");
        }
        if (minimumChars != this._labelAndIcon._minimumChars) {
            int old = this._labelAndIcon._minimumChars;
            this._labelAndIcon._minimumChars = minimumChars;
            this.invalidate();
            this.validate();
            this.repaint();
            this.firePropertyChange("minimumChars", old, minimumChars);
        }
    }

    public int getMinimumChars() {
        return this._labelAndIcon._minimumChars;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new NullPointerException("orientation is null");
        }
        Orientation old = this._orientation;
        if (old != orientation) {
            this._orientation = orientation;
            this._labelAndIcon.setOrientation(orientation);
            this._rollupTextLabel.setOrientation(orientation);
            this._toolbar.setOrientation(orientation == Orientation.HORIZONTAL ? 0 : 1);
            this._toolbar.setAlignment(orientation == Orientation.HORIZONTAL ? 4 : 3);
            this.resetInsets(this.getLevel());
            this.invalidate();
            this.validate();
            this.firePropertyChange("orientation", (Object)old, (Object)orientation);
        }
    }

    public Orientation getOrientation() {
        return this._orientation;
    }

    public void setHelpTopicId(String helpTopicId) {
        String oldTopic = this._helpTopicId;
        this._helpTopicId = helpTopicId;
        this._helpIcon.setVisible(helpTopicId != null);
        this.firePropertyChange("helpTopicId", oldTopic, helpTopicId);
    }

    public String getHelpTopicId() {
        return this._helpTopicId;
    }

    public void addActionControl(Component actionControl) {
        if (actionControl == null) {
            throw new NullPointerException("actionControl is null");
        }
        this._toolbar.add(actionControl);
        this._toolbar.setVisible(true);
    }

    public void addActionControl(Action action) {
        if (action == null) {
            throw new NullPointerException("action is null");
        }
        this.addActionControl(new JButton(action));
    }

    public void removeActionControl(Action action) {
        for (int i = 0; i < this._toolbar.getComponentCount(); ++i) {
            Component c = this._toolbar.getComponent(i);
            if (!(c instanceof AbstractButton) || ((AbstractButton)c).getAction() != action) continue;
            this.removeActionControl(c);
        }
    }

    public void removeActionControl(Component actionControl) {
        int index = Header.indexOfComponent(this._toolbar, actionControl);
        if (index >= 0) {
            this._toolbar.remove(index);
        }
        this._toolbar.setVisible(this._toolbar.getComponentCount() > 0);
    }

    private static int indexOfComponent(Container container, Component component) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            if (container.getComponent(i) != component) continue;
            return i;
        }
        return -1;
    }

    public void setText(String text) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        String oldLabel = this._labelAndIcon.getText();
        this._labelAndIcon.setText(text);
        this.updateAccessibleDescription();
        if (!oldLabel.equals(text)) {
            this.firePropertyChange("text", oldLabel, text);
            this.revalidate();
            this.repaint();
        }
    }

    private void updateAccessibleDescription() {
        String tooltip = this._labelAndIcon.getText();
        if (tooltip == null) {
            tooltip = "";
        }
        tooltip = tooltip + " (" + (this._expanded ? UIBundle.get("DISCLOSE_HIDE_CONTENTS") : UIBundle.get("DISCLOSE_SHOW_CONTENTS")) + ")";
        this._disclosureIcon.setToolTipText(tooltip);
    }

    public String getText() {
        return this._labelAndIcon.getText();
    }

    public void setRollupStatusText(String rollupStatusText) {
        String oldLabel = this._rollupTextLabel.getText();
        this._rollupTextLabel.setText(rollupStatusText == null ? "" : rollupStatusText);
        this._rollupTextLabel.setVisible(!this.isExpanded() && rollupStatusText != null && rollupStatusText.length() != 0);
        this.firePropertyChange("rollupStatusText", oldLabel, rollupStatusText);
        this.revalidate();
        this.repaint();
    }

    public String getRollupStatusText() {
        return this._rollupTextLabel.getText();
    }

    public void setExpandable(boolean expandable) {
        if (this._expandable != expandable) {
            this._disclosureIcon.setVisible(expandable);
            if (!expandable) {
                this.setExpanded(true);
            }
            this._expandable = expandable;
            this.firePropertyChange("expandable", !expandable, expandable);
        }
    }

    public boolean isExpandable() {
        return this._expandable;
    }

    public void setIcon(Icon icon) {
        Icon oldIcon = this._labelAndIcon.getIcon();
        if (oldIcon != icon) {
            this._labelAndIcon.setIcon(icon);
            this.firePropertyChange("icon", oldIcon, icon);
            this.repaint();
        }
    }

    public Icon getIcon() {
        return this._labelAndIcon.getIcon();
    }

    public void setExpanded(boolean expanded) {
        if (!this.isExpandable()) {
            return;
        }
        if (this._expanded != expanded) {
            this._expanded = expanded;
            this._disclosureIcon.setIcon(this.getExpansionIcon(expanded));
            if (expanded) {
                this.fireHeaderExpanded();
            } else {
                this.fireHeaderCollapsed();
            }
            this.updateAccessibleDescription();
            this._rollupTextLabel.setVisible(!expanded);
            this.repaint();
            this.firePropertyChange("expanded", !expanded, expanded);
        }
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void addHeaderListener(HeaderListener headerListener) {
        if (headerListener == null) {
            throw new NullPointerException("headerListener is null");
        }
        this._listeners.add(headerListener);
    }

    public void removeHeaderListener(HeaderListener headerListener) {
        this._listeners.remove(headerListener);
    }

    protected final void fireHeaderExpanded() {
        HeaderEvent event = new HeaderEvent(this);
        for (HeaderListener l : this._listeners) {
            l.headerExpanded(event);
        }
    }

    protected final void fireHeaderCollapsed() {
        HeaderEvent event = new HeaderEvent(this);
        for (HeaderListener l : this._listeners) {
            l.headerCollapsed(event);
        }
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException("level is null");
        }
        if (level != this._level) {
            Level oldSize = this._level;
            this._level = level;
            this.setExpandable(level != Level.PAGE);
            this._labelAndIcon.setFont(this.getTitleFont(level));
            this.resetInsets(level);
            this.firePropertyChange("headerSize", (Object)oldSize, (Object)level);
            this.revalidate();
            this.repaint();
        }
    }

    private void resetInsets(Level level) {
        Insets insets = level.getInsets();
        if (this.getOrientation() == Orientation.VERTICAL) {
            insets = new Insets(insets.left, insets.bottom, insets.right, insets.top);
        }
        this.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
    }

    public Level getLevel() {
        return this._level;
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.paintBackground(g);
        super.paintComponent(g);
    }

    @Override
    public Dimension getMinimumSize() {
        int disclosureWidth = this.isExpandable() ? this._disclosureIcon.getMinimumSize().width : 0;
        int disclosureHeight = this.isExpandable() ? this._disclosureIcon.getMinimumSize().width : 0;
        Dimension labelMs = this._labelAndIcon.getMinimumSize();
        Dimension helpMs = this._helpIcon.getMinimumSize();
        Dimension rollupMs = this._rollupTextLabel.getMinimumSize();
        Dimension cbMs = this._toolbar.getMinimumSize();
        return this.calculateSize(disclosureWidth, disclosureHeight, labelMs, helpMs, rollupMs, cbMs);
    }

    private Dimension calculateSize(int disclosureWidth, int disclosureHeight, Dimension labelPs, Dimension helpPs, Dimension rollupPs, Dimension cbPs) {
        boolean horizontal = this.getOrientation() == Orientation.HORIZONTAL;
        Dimension size = new Dimension();
        Insets insets = this.getInsets();
        size.width = insets.left + insets.right;
        size.height = insets.top + insets.bottom;
        if (horizontal) {
            size.width += disclosureWidth;
        } else {
            size.height += disclosureHeight;
        }
        if (horizontal) {
            if (this.isExpandable()) {
                size.width += 3;
            }
            size.width += labelPs.width;
        } else {
            if (this.isExpandable()) {
                size.height += 3;
            }
            size.height += labelPs.height;
        }
        if (this.getHelpTopicId() != null) {
            if (horizontal) {
                size.width += 3;
                size.width += helpPs.width;
            } else {
                size.height += 3;
                size.height += helpPs.height;
            }
        }
        if (this.isRollupTextVisible()) {
            if (horizontal) {
                size.width += 3;
                size.width += rollupPs.width;
            } else {
                size.height += 3;
                size.height += rollupPs.height;
            }
        }
        if (this._toolbar.isVisible()) {
            if (horizontal) {
                size.width += 15;
            } else {
                size.height += 15;
            }
        }
        if (this._toolbar.isVisible()) {
            if (horizontal) {
                size.width += cbPs.width;
            } else {
                size.height += cbPs.height;
            }
        }
        if (horizontal) {
            size.height = size.height + Header.max(size.height, disclosureHeight, labelPs.height, this.getHelpTopicId() == null ? 0 : helpPs.height, !this.isRollupTextVisible() ? 0 : rollupPs.height, !this._toolbar.isVisible() ? 0 : cbPs.height);
        } else {
            size.width = size.width + Header.max(size.width, disclosureWidth, labelPs.width, this.getHelpTopicId() == null ? 0 : helpPs.width, !this.isRollupTextVisible() ? 0 : rollupPs.width, !this._toolbar.isVisible() ? 0 : cbPs.width);
        }
        if (this.getLevel() == Level.SUBSUB) {
            if (horizontal) {
                size.height = Math.max(size.height, Header.getApproximateButtonSize());
            } else {
                size.width = Math.max(size.width, Header.getApproximateButtonSize());
            }
        }
        return size;
    }

    private static int getApproximateButtonSize() {
        if (_approximateButtonSize >= 0) {
            return _approximateButtonSize;
        }
        JToolBar tb = new JToolBar();
        JButton b = new JButton();
        b.setIcon(OracleIcons.getIcon((String)"add.png"));
        tb.add(b);
        Dimension preferredSize = b.getPreferredSize();
        _approximateButtonSize = Math.max(preferredSize.width, preferredSize.height);
        return _approximateButtonSize += 3;
    }

    private boolean isRollupTextVisible() {
        return this._rollupTextLabel.isVisible() && this._rollupTextLabel.getText() != "";
    }

    @Override
    public Dimension getPreferredSize() {
        int disclosureWidth = this.isExpandable() ? this._disclosureIcon.getPreferredSize().width : 0;
        int disclosureHeight = this.isExpandable() ? this._disclosureIcon.getPreferredSize().width : 0;
        Dimension labelPs = this._labelAndIcon.getPreferredSize();
        Dimension helpPs = this._helpIcon.getPreferredSize();
        Dimension rollupPs = this._rollupTextLabel.getPreferredSize();
        Dimension cbPs = this._toolbar.getPreferredSize();
        return this.calculateSize(disclosureWidth, disclosureHeight, labelPs, helpPs, rollupPs, cbPs);
    }

    @Override
    public void doLayout() {
        int spaceForLabelAndToolbar;
        int disclosureWidth;
        boolean horizontal;
        Insets insets = this.getInsets();
        int pw = this.getWidth() - (insets.left + insets.right);
        int ph = this.getHeight() - (insets.top + insets.bottom);
        boolean bl = horizontal = this.getOrientation() == Orientation.HORIZONTAL;
        int n = this.isExpandable() ? (horizontal ? this._disclosureIcon.getPreferredSize().width : pw) : (disclosureWidth = 0);
        int disclosureHeight = this.isExpandable() ? (horizontal ? ph : this._disclosureIcon.getPreferredSize().height) : 0;
        Dimension labelPs = this._labelAndIcon.getPreferredSize();
        Dimension labelMs = this._labelAndIcon.getMinimumSize();
        Dimension rollupMs = this.isRollupTextVisible() ? this._rollupTextLabel.getMinimumSize() : ZERO_DIM;
        Dimension rollupPs = this.isRollupTextVisible() ? this._rollupTextLabel.getPreferredSize() : ZERO_DIM;
        Dimension helpPs = this._helpIcon.getPreferredSize();
        Dimension cbPs = this._toolbar.isVisible() ? this._toolbar.getPreferredSize() : ZERO_DIM;
        Dimension cbMs = this._toolbar.isVisible() ? this._toolbar.getMinimumSize() : ZERO_DIM;
        int x = insets.left;
        int y = insets.top;
        if (this.isExpandable()) {
            if (horizontal) {
                this._disclosureIcon.setBounds(x, insets.top + (ph - disclosureHeight) / 2, disclosureWidth, disclosureHeight);
                x += disclosureWidth + 3;
            } else {
                this._disclosureIcon.setBounds(insets.left + (pw - disclosureWidth) / 2, y, disclosureWidth, disclosureHeight);
                y += disclosureHeight + 3;
            }
        }
        int toolbarSize = 0;
        int titleSize = 0;
        int rollupSize = 0;
        int n2 = spaceForLabelAndToolbar = horizontal ? pw - this._disclosureIcon.getWidth() : ph - this._disclosureIcon.getHeight();
        if (this.getHelpTopicId() != null) {
            spaceForLabelAndToolbar -= 3;
            spaceForLabelAndToolbar -= horizontal ? helpPs.width : helpPs.height;
        }
        if (this._toolbar.isVisible()) {
            spaceForLabelAndToolbar -= 3;
        }
        if (this.isRollupTextVisible()) {
            spaceForLabelAndToolbar -= 3;
        }
        int[] minSpans = new int[]{horizontal ? cbMs.width : cbMs.height, horizontal ? labelMs.width : labelMs.height, horizontal ? rollupMs.width : rollupMs.height};
        int[] prefSpans = new int[]{horizontal ? cbPs.width : cbPs.height, horizontal ? labelPs.width : labelPs.height, horizontal ? rollupPs.width : rollupPs.height};
        int[] allocations = new int[3];
        Header.allocateSpanSpace(minSpans, prefSpans, spaceForLabelAndToolbar, allocations);
        toolbarSize = allocations[0];
        titleSize = allocations[1];
        rollupSize = allocations[2];
        this._labelAndIcon.setBounds(horizontal ? x : insets.left + (pw - labelPs.width) / 2, horizontal ? insets.top + (ph - labelPs.height) / 2 : y, horizontal ? titleSize : labelPs.width, horizontal ? labelPs.height : titleSize);
        if (horizontal) {
            x += titleSize;
        } else {
            y += titleSize;
        }
        if (this.getHelpTopicId() != null) {
            if (horizontal) {
                x += 3;
            } else {
                y += 3;
            }
            this._helpIcon.setBounds(horizontal ? x : insets.left + (pw - helpPs.width) / 2, horizontal ? insets.top + (pw - helpPs.height) / 2 : y, helpPs.width, helpPs.height);
            if (horizontal) {
                x += helpPs.width;
            } else {
                y += helpPs.height;
            }
        }
        if (this.isRollupTextVisible()) {
            if (horizontal) {
                x += 3;
            } else {
                y += 3;
            }
            this._rollupTextLabel.setBounds(horizontal ? x : insets.left + (pw - rollupPs.width) / 2, horizontal ? insets.top + (ph - rollupPs.height) / 2 : y, horizontal ? rollupSize : rollupPs.width, horizontal ? rollupPs.height : rollupSize);
            if (horizontal) {
                x += rollupSize;
            } else {
                y += rollupSize;
            }
        }
        if (this._toolbar.isVisible()) {
            if (horizontal) {
                x += 3;
            } else {
                y += 3;
            }
            this._toolbar.setBounds(horizontal ? x : insets.left + (pw - cbPs.width) / 2, horizontal ? insets.top + (ph - cbPs.height) / 2 : y, horizontal ? toolbarSize : cbPs.width, horizontal ? cbPs.height : toolbarSize);
        }
    }

    private static void allocateSpanSpace(int[] inMinimumSpans, int[] inPreferredSpans, int inSpanSize, int[] outAllocatedSpans) {
        int count = inMinimumSpans.length;
        if (inPreferredSpans.length != count || outAllocatedSpans.length != count) {
            throw new IllegalArgumentException("inMinimumSpans, inPreferredSpans, and outAllocatedSpans must all be the same length");
        }
        int preferredSpan = Header.sum(inPreferredSpans);
        int preferredSpanDelta = inSpanSize - preferredSpan;
        if (preferredSpanDelta >= 0) {
            for (int i = 0; i < count; ++i) {
                outAllocatedSpans[i] = inPreferredSpans[i];
            }
            outAllocatedSpans[0] = outAllocatedSpans[0] + preferredSpanDelta;
        } else {
            int minimumSpan = Header.sum(inMinimumSpans);
            int minimumSpanDelta = inSpanSize - minimumSpan;
            if (minimumSpanDelta < 0) {
                minimumSpanDelta = 0;
            }
            for (int i = 0; i < count; ++i) {
                int spaceAllocation = Math.min(minimumSpanDelta, inPreferredSpans[i] - inMinimumSpans[i]);
                outAllocatedSpans[i] = inMinimumSpans[i] + spaceAllocation;
                if ((minimumSpanDelta -= spaceAllocation) >= 0) continue;
                minimumSpanDelta = 0;
            }
        }
    }

    private static int sum(int[] ints) {
        int result = 0;
        for (int i = 0; i < ints.length; ++i) {
            result += ints[i];
        }
        return result;
    }

    private static int max(int ... ints) {
        if (ints.length == 0) {
            throw new IllegalArgumentException("Need at least one int");
        }
        int cMax = Integer.MIN_VALUE;
        for (int i : ints) {
            if (i <= cMax) continue;
            cMax = i;
        }
        return cMax;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this._ac == null) {
            this._ac = new HeaderAccessibleContext();
        }
        return this._ac;
    }

    private void configureButton(AbstractButton button) {
        if (button.getIcon() != null) {
            IconicButtonUI.install(button);
        }
    }

    private Font getTitleFont(Level size) {
        Font labelFont = UIManager.getFont("Label.font");
        if (size == Level.SUBSUB || size == Level.DIALOG || size == Level.SIMPLE) {
            return labelFont;
        }
        Font newFont = labelFont.deriveFont(1);
        return newFont;
    }

    private Icon getExpansionIcon(boolean expanded) {
        return expanded ? OracleIcons.getIcon((String)"blafplus/disclosure_expanded.png") : OracleIcons.getIcon((String)"blafplus/disclosure_collapsed.png");
    }

    @Override
    public String toString() {
        return String.format("%s [text=%s, level=%s, expanded=%s, icon=%s, helpTopicId=%s]", new Object[]{Header.class.getName(), this.getText(), this.getLevel(), this.isExpanded(), this.getIcon(), this.getHelpTopicId()});
    }

    private void paintBackground(Graphics g) {
        this.getLevel().getBackgroundPainter().paint(g, this);
    }

    private class HeaderAccessibleContext
    extends JComponent.AccessibleJComponent {
        private HeaderAccessibleContext() {
            super(Header.this);
        }

        @Override
        public String getAccessibleName() {
            return Header.this._disclosureIcon.getAccessibleContext().getAccessibleName();
        }

        @Override
        public String getAccessibleDescription() {
            return Header.this._disclosureIcon.getAccessibleContext().getAccessibleDescription();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return Header.this._disclosureIcon.getAccessibleContext().getAccessibleRole();
        }
    }

    private static class RotatingLabel
    extends JComponent {
        private int _minimumChars = 15;
        private Icon _icon;
        private String _text = "";
        private Orientation _orientation = Orientation.HORIZONTAL;
        private Border _focusBorder = null;
        private boolean _simulatedFocus = false;

        RotatingLabel() {
            ToolTipManager.sharedInstance().registerComponent(this);
            JLabel reference = new JLabel();
            this.setFont(reference.getFont());
            this.setForeground(reference.getForeground());
            this.setBackground(reference.getBackground());
            this.setOpaque(false);
            this.updateUI();
        }

        public void setSimulatedFocusPainted(boolean focusPainted) {
            if (focusPainted != this._simulatedFocus) {
                this._simulatedFocus = focusPainted;
                this.repaint();
            }
        }

        public boolean isSimulatedFocusPainted() {
            return this._simulatedFocus;
        }

        @Override
        public void updateUI() {
            this._focusBorder = UIManager.getBorder("List.focusCellHighlightBorder");
        }

        @Override
        public String getToolTipText(MouseEvent me) {
            boolean horizontal;
            Dimension ps = this.getPreferredSize();
            boolean bl = horizontal = this._orientation == Orientation.HORIZONTAL;
            if (horizontal && this.getWidth() < ps.width || !horizontal && this.getHeight() < ps.height) {
                return this.getText();
            }
            return super.getToolTipText(me);
        }

        public void setIcon(Icon icon) {
            this._icon = icon;
        }

        public Icon getIcon() {
            return this._icon;
        }

        public void setText(String text) {
            this._text = text;
        }

        public String getText() {
            return this._text;
        }

        public void setOrientation(Orientation orientation) {
            this._orientation = orientation;
        }

        public Orientation getOrientation() {
            return this._orientation;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension sz = this.calculatePreferredSize(this._minimumChars);
            Dimension ps = this.getPreferredSize();
            return new Dimension(Math.min(sz.width, ps.width), Math.min(sz.height, ps.height));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.calculatePreferredSize(-1);
        }

        private Dimension calculatePreferredSize(int visibleCharCount) {
            int iconWidth;
            Insets insets = this.getInsets();
            Dimension size = new Dimension();
            size.width = insets.left + insets.right;
            size.height = insets.top + insets.bottom;
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int textHeight = this.getText() == null || this.getText() == "" ? 0 : fm.getHeight();
            int textWidth = 0;
            if (this.getText() != null && this.getText() != "") {
                if (visibleCharCount == -1) {
                    textWidth = fm.stringWidth(this.getText());
                } else {
                    int ellipsisWidth = fm.stringWidth("...");
                    String truncated = this.getText().length() < visibleCharCount ? this.getText() : this.getText().substring(0, visibleCharCount);
                    textWidth = ellipsisWidth + fm.stringWidth(truncated);
                }
            }
            boolean horizontal = this.getOrientation() == Orientation.HORIZONTAL;
            int iconHeight = this.getIcon() == null ? 0 : this.getIcon().getIconHeight();
            int n = iconWidth = this.getIcon() == null ? 0 : this.getIcon().getIconWidth();
            if (horizontal) {
                size.height = Math.max(size.height, Math.max(iconHeight, textHeight));
                size.width = size.width + iconWidth + (iconWidth != 0 && textWidth != 0 ? 3 : 0) + textWidth;
            } else {
                size.width = Math.max(size.width, Math.max(iconWidth, textHeight));
                size.height = size.height + iconHeight + (iconHeight != 0 && textHeight != 0 ? 3 : 0) + textWidth;
            }
            return size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            Insets insets = this.getInsets();
            Dimension size = this.getSize();
            int pw = size.width - (insets.left + insets.right);
            int ph = size.height - (insets.top + insets.bottom);
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int textWidth = this.getText() == null ? 0 : fm.stringWidth(this.getText());
            int textHeight = fm.getHeight();
            boolean horizontal = this.getOrientation() == Orientation.HORIZONTAL;
            int iconWidth = this.getIcon() == null ? 0 : this.getIcon().getIconWidth();
            int iconHeight = this.getIcon() == null ? 0 : this.getIcon().getIconHeight();
            int remainingSpace = horizontal ? pw : ph;
            g.setColor(this.getForeground());
            g.setFont(this.getFont());
            if (this.getIcon() != null) {
                int iconX = horizontal ? insets.left : pw / 2 - iconWidth / 2;
                int iconY = horizontal ? ph / 2 - iconHeight / 2 : insets.top;
                this.getIcon().paintIcon(this, g, iconX, iconY);
                remainingSpace -= horizontal ? iconWidth : iconHeight;
                remainingSpace -= 3;
            }
            int textX = horizontal ? insets.left + iconWidth + (iconWidth == 0 ? 0 : 3) : insets.top + iconHeight + (iconHeight == 0 ? 0 : 3);
            int textY = horizontal ? ph / 2 - textHeight / 2 : pw / 2 - textHeight / 2;
            String s = this.getText();
            if (textWidth > remainingSpace) {
                int elipsisWidth = fm.stringWidth("...");
                if (elipsisWidth <= remainingSpace) {
                    int nChars;
                    int sw = elipsisWidth;
                    int max = this.getText().length();
                    for (nChars = 0; nChars < max && (sw += fm.charWidth(this.getText().charAt(nChars))) <= remainingSpace; ++nChars) {
                    }
                    s = this.getText().substring(0, nChars) + "...";
                } else {
                    return;
                }
            }
            int actualStringWidth = fm.stringWidth(s);
            if (horizontal) {
                GraphicUtils.drawString((Graphics)g, (String)s, (int)textX, (int)(textY + fm.getAscent()));
                if (this._focusBorder != null && this.isSimulatedFocusPainted()) {
                    this._focusBorder.paintBorder(this, g, textX, textY, actualStringWidth, textHeight);
                }
            } else {
                AffineTransform transformDefault = ((Graphics2D)g).getTransform();
                Object aaDefault = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                try {
                    AffineTransform at = new AffineTransform();
                    at.rotate(1.5707963267948966);
                    at.translate(0.0, -(textY + (pw / 2 + textHeight / 2)));
                    ((Graphics2D)g).transform(at);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.drawString(s, textX, textY + fm.getAscent());
                    if (this._focusBorder != null && this.isSimulatedFocusPainted()) {
                        this._focusBorder.paintBorder(this, g, textX, textY + 1, actualStringWidth, textHeight);
                    }
                }
                finally {
                    ((Graphics2D)g).setTransform(transformDefault);
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaDefault);
                }
            }
        }
    }

    private static class SimpleBackgroundPainter
    extends BackgroundPainter {
        private SimpleBackgroundPainter() {
        }
    }

    private static class SubBackgroundPainter
    extends BackgroundPainter {
        private static final Color LINE_COLOR = new Color(169, 173, 181);

        private SubBackgroundPainter() {
        }

        @Override
        public void paint(Graphics g, Header c) {
            int ox = c.getInsets().left;
            int oy = c.getInsets().top;
            int owidth = c.getWidth() - ox - c.getInsets().right;
            int oheight = c.getHeight() - oy - c.getInsets().bottom;
            g.setColor(LINE_COLOR);
            g.drawLine(ox, oy + oheight, ox + owidth, oy + oheight);
            super.paint(g, c);
        }
    }

    private static class SubSubBackgroundPainter
    extends BackgroundPainter {
        private SubSubBackgroundPainter() {
        }

        @Override
        public void paint(Graphics g, Header c) {
            if (c.getOrientation() == Orientation.HORIZONTAL) {
                _subsubBackgroundH.paintIcon(c, g, 0, 0, c.getWidth(), c.getHeight());
            } else {
                _subsubBackgroundV.paintIcon(c, g, 0, 0, c.getWidth(), c.getHeight());
            }
            super.paint(g, c);
        }
    }

    private static class PageBackgroundPainter
    extends BackgroundPainter {
        private PageBackgroundPainter() {
        }
    }

    private static abstract class BackgroundPainter {
        private BackgroundPainter() {
        }

        public void paint(Graphics g, Header header) {
        }
    }

    public static enum Level {
        PAGE(new PageBackgroundPainter(), new Insets(2, 5, 10, 5)),
        SUB(new SubBackgroundPainter(), new Insets(3, 5, 3, 5)),
        SUBSUB(new SubSubBackgroundPainter(), new Insets(2, 5, 2, 8)),
        DIALOG(new SubBackgroundPainter(), new Insets(3, 0, 3, 0)),
        SIMPLE(new SimpleBackgroundPainter(), new Insets(3, 5, 3, 5));

        private BackgroundPainter _painter;
        private Insets _insets;

        private Level(BackgroundPainter painter, Insets insets) {
            this._painter = painter;
            this._insets = insets;
        }

        private BackgroundPainter getBackgroundPainter() {
            return this._painter;
        }

        private Insets getInsets() {
            return this._insets;
        }
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

