/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Utilities;
import oracle.javatools.ui.internal.Exceptions;
import oracle.javatools.ui.search.PromptedTextField;

public final class ExtendedTextField
extends PromptedTextField {
    private LargerTextArea _textArea;
    private JScrollPane _textAreaScrollPane;
    private JDialog _dialog;
    private boolean _allowTabs = false;
    private boolean _allowBreaks = false;
    private boolean _updatingCaret = false;
    private boolean _isNotified = false;
    private int _rowHeight;
    private static final String ELLIPSES = "...";
    private static final int DIALOG_BORDER_GAP = 2;
    private static int TEMPORARY_INSTANCE_COUNTER = 0;
    private List _allowedFocusComponents;

    public ExtendedTextField() {
        this.jbInit();
    }

    public ExtendedTextField(boolean allowTabs) {
        this._allowTabs = allowTabs;
        this.jbInit();
    }

    public void addAllowedFocusComponent(Component component) {
        if (this._allowedFocusComponents == null) {
            this._allowedFocusComponents = new ArrayList();
        }
        if (component != null) {
            this._allowedFocusComponents.add(component);
        }
    }

    public List getAllowedFocusComponents() {
        return this._allowedFocusComponents;
    }

    public void removeAllowedFocusComponent(JComponent component) {
        this._allowedFocusComponents.remove(component);
    }

    private void jbInit() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent() != ExtendedTextField.this._textArea && ExtendedTextField.this._shouldShowLargerEditor()) {
                    ExtendedTextField.this._updateLargerEditorVisibility();
                }
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (ExtendedTextField.this._updatingCaret) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedTextField.this._updateLargerEditorVisibility();
                    }
                });
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (ExtendedTextField.this._updatingCaret) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedTextField.this._updateLargerEditorVisibility();
                    }
                });
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (ExtendedTextField.this._updatingCaret) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtendedTextField.this._updateLargerEditorVisibility();
                    }
                });
            }
        });
        this.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ExtendedTextField.this._updateLargerEditorVisibility();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ExtendedTextField.this._hideLargerEditor();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                ExtendedTextField.this._hideLargerEditor();
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    ExtendedTextField.this._hideLargerEditor();
                }
            }
        });
        this._allowedFocusComponents = new ArrayList();
        if (!this._allowTabs) {
            this.setFocusTraversalKeys(0, null);
            this.setFocusTraversalKeys(1, null);
        }
        this._initLargerEditor();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._isNotified = true;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._dialog != null) {
            this._dialog.dispose();
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getOppositeComponent() != this._textArea) {
            super.processFocusEvent(e);
        }
    }

    private void _verifyDialogAvaliable() {
        if (this._dialog != null || !this._isNotified) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof Frame) {
            this._dialog = new JDialog((Frame)window, false);
        } else if (window instanceof Dialog) {
            this._dialog = new JDialog((Dialog)window, false);
        } else {
            throw new UnsupportedOperationException("Extended TextField must be displayed in a Frame or a Dialog");
        }
        this._dialog.setName("ExtendedTextField " + TEMPORARY_INSTANCE_COUNTER++);
        this._dialog.setUndecorated(true);
        this._dialog.getLayeredPane().putClientProperty("feedback.nofeedback", true);
        JPanel content = new JPanel(new BorderLayout());
        content.setOpaque(true);
        content.setBackground(UIManager.getColor("EditorPane.selectionBackground"));
        this._dialog.getContentPane().setLayout(new BorderLayout());
        this._dialog.getContentPane().add(content);
        content.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._textAreaScrollPane = new JScrollPane(this._textArea);
        this._textAreaScrollPane.setBorder(null);
        content.add(this._textAreaScrollPane);
        this._textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component oppComp = e.getOppositeComponent();
                if (!ExtendedTextField.this._allowedFocusComponents.contains(oppComp) && oppComp != null && SwingUtilities.getWindowAncestor(oppComp) != SwingUtilities.getWindowAncestor(ExtendedTextField.this._textArea)) {
                    ExtendedTextField.this._hideLargerEditor();
                }
            }
        });
    }

    @Override
    public void setDocument(Document doc) {
        super.setDocument(doc);
        if (doc != null) {
            doc.putProperty("filterNewlines", !this._allowBreaks);
        }
    }

    private void _initLargerEditor() {
        this._textArea = new LargerTextArea();
        this._textArea.setLineWrap(true);
        this._textArea.setFont(this.getFont());
        this._textArea.setDocument(this.getDocument());
        this._textArea.setTabSize(0);
        if (this.getBorder() != null) {
            Insets in = this.getBorder().getBorderInsets(this);
            this._textArea.setBorder(BorderFactory.createEmptyBorder(in.top, in.left, in.bottom, in.right));
        } else {
            this._textArea.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
    }

    private void _updateLargerEditorVisibility() {
        if (this._updatingCaret || !this.isShowing()) {
            return;
        }
        if (this._dialog != null && this._dialog.isVisible()) {
            if (this._shouldShowLargerEditor()) {
                this._verifyDialogAvaliable();
                this._updateLargerEditorSize();
            } else {
                this._hideLargerEditor();
            }
        } else if (this._shouldShowLargerEditor()) {
            this._showLargerEditor();
        }
    }

    private boolean _shouldShowLargerEditor() {
        String text = this.getText();
        if (text.indexOf(10) > -1) {
            return true;
        }
        int fullWidth = this.getFontMetrics(this.getFont()).stringWidth(text);
        return fullWidth > this.getTextWidth();
    }

    private int getTextWidth() {
        int width = this.getWidth();
        Border b = this.getBorder();
        if (b != null) {
            Insets i = b.getBorderInsets(this);
            width -= i.left + i.right;
        }
        return width;
    }

    private void _showLargerEditor() {
        this._verifyDialogAvaliable();
        this._textAreaScrollPane.setVerticalScrollBarPolicy(21);
        this._textArea.setCaretPosition(this.getCaretPosition());
        this._textArea.setSelectionStart(this.getSelectionStart());
        this._textArea.setSelectionEnd(this.getSelectionEnd());
        this._textArea.setForeground(this.getForeground());
        this._textArea.setBackground(this.getBackground());
        this._textArea.setFont(this.getFont());
        this._textArea.setEditable(this.isEditable());
        this._textArea.setEnabled(this.isEnabled());
        this._dialog.setBounds((int)this.getLocationOnScreen().getX(), (int)this.getLocationOnScreen().getY(), this.getWidth(), this.getHeight());
        this._dialog.setVisible(true);
        this._textArea.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExtendedTextField.this._updateLargerEditorSize();
                ExtendedTextField.this._textAreaScrollPane.setVerticalScrollBarPolicy(20);
            }
        });
    }

    private void _updateLargerEditorSize() {
        if (this._dialog == null || !this.isShowing()) {
            return;
        }
        if (!this._textAreaScrollPane.getVerticalScrollBar().isVisible()) {
            this._textAreaScrollPane.setVerticalScrollBarPolicy(21);
        }
        int rows = Math.min(6, this._textArea.getWrappedLineCount());
        int height = this._textArea.getInsets().top + this._textArea.getInsets().bottom + this._textArea.getMargin().top + this._textArea.getMargin().bottom + 2 + 2;
        int y = (int)this.getLocationOnScreen().getY() - this._textAreaScrollPane.getLocation().y;
        int x = (int)this.getLocationOnScreen().getX() - this._textAreaScrollPane.getLocation().x;
        this._dialog.setBounds(x, y, this.getWidth() + 2, height += rows * this._textArea.getRowHeight());
        this._dialog.getRootPane().setSize(this._dialog.getWidth(), this._dialog.getHeight());
        this._dialog.getLayeredPane().setSize(this._dialog.getWidth(), this._dialog.getHeight());
        this._dialog.getContentPane().setSize(this._dialog.getWidth(), this._dialog.getHeight());
        this._textAreaScrollPane.setSize(this._dialog.getWidth() - 2 - 2, this._dialog.getHeight() - 2 - 2);
        this._dialog.getContentPane().doLayout();
        this._textAreaScrollPane.setVerticalScrollBarPolicy(20);
    }

    public void setLargerAreaVisible(boolean visible) {
        if (visible) {
            this._showLargerEditor();
        } else {
            this._hideLargerEditor();
        }
    }

    private void _hideLargerEditor() {
        this._updatingCaret = true;
        if (this._dialog != null) {
            this.setCaretPosition(this._textArea.getCaretPosition());
            this._dialog.setVisible(false);
            this._dialog.dispose();
        }
        this._updatingCaret = false;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._textArea != null) {
            this._textArea.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._textArea != null) {
            this._textArea.setBackground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this._rowHeight = 0;
        if (this._textArea != null) {
            this._textArea.setFont(font);
        }
    }

    @Override
    public void setText(String text) {
        this._updatingCaret = true;
        super.setText(text);
        this.setCaretPosition(0);
        this._updatingCaret = false;
    }

    public JTextArea getLargerTextArea() {
        return this._textArea;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        Insets insets = this.getInsets();
        size.height = this.getRowHeight() + insets.top + insets.bottom;
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        Insets insets = this.getInsets();
        size.height = this.getRowHeight() + insets.top + insets.bottom;
        return size;
    }

    protected int getRowHeight() {
        if (this._rowHeight == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this._rowHeight = metrics.getHeight();
        }
        return this._rowHeight;
    }

    @Override
    public BoundedRangeModel getHorizontalVisibility() {
        BoundedRangeModel visibility = super.getHorizontalVisibility();
        visibility.setValue(visibility.getMinimum());
        return visibility;
    }

    @Override
    public void setScrollOffset(int scrollOffset) {
    }

    @Override
    public void scrollRectToVisible(Rectangle r) {
    }

    public void setAllowBreaks(boolean allowBreaks) {
        this._allowBreaks = allowBreaks;
        if (this._allowBreaks) {
            this.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "insert-break");
            this.getLargerTextArea().getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "insert-break");
        } else {
            this.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "notify-field-accept");
            this.getLargerTextArea().getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "hideAction");
        }
        this.getDocument().putProperty("filterNewlines", !this._allowBreaks);
    }

    public boolean canAllowBreaks() {
        return this._allowBreaks;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this._shouldShowLargerEditor()) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.setColor(this.isEnabled() ? this.getForeground() : this.getDisabledTextColor());
            FontMetrics fm = g.getFontMetrics();
            int ascent = fm.getMaxAscent();
            int descent = fm.getMaxDescent();
            int left = 0;
            if (this.getBorder() != null) {
                left += this.getBorder().getBorderInsets((Component)this).left;
            }
            int baseline = this.getSize().height / 2 - descent / 2 + ascent / 2;
            String clipString = ExtendedTextField.getClipString(g.getFontMetrics(), this.getText(), this.getTextWidth());
            g.drawString(clipString, left, baseline);
        } else {
            super.paintComponent(g);
        }
    }

    public static String getClipString(FontMetrics fm, String string, int availTextWidth) {
        char c;
        int nChars;
        int fullWidth = fm.stringWidth(string);
        if (fullWidth <= availTextWidth && string.indexOf(10) < 0) {
            return string;
        }
        int width = fm.stringWidth(ELLIPSES);
        int max = string.length();
        for (nChars = 0; nChars < max && (width += fm.charWidth(c = string.charAt(nChars))) <= availTextWidth && c != '\n'; ++nChars) {
        }
        string = string.substring(0, nChars) + ELLIPSES;
        return string;
    }

    private class LargerTextArea
    extends JTextArea {
        public static final String hideActionString = "hideAction";
        private AbstractAction hideAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedTextField.this.requestFocus();
            }
        };

        public LargerTextArea() {
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), hideActionString);
            this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), hideActionString);
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 64), hideActionString);
            this.getInputMap().put(KeyStroke.getKeyStroke(27, 64), hideActionString);
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 128), hideActionString);
            this.getInputMap().put(KeyStroke.getKeyStroke(27, 128), hideActionString);
            this.getInputMap().put(KeyStroke.getKeyStroke(9, 512), hideActionString);
            this.getInputMap().put(KeyStroke.getKeyStroke(27, 512), hideActionString);
            this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), hideActionString);
            this.getActionMap().put(hideActionString, this.hideAction);
        }

        @Override
        public int getRowHeight() {
            return super.getRowHeight();
        }

        public int getWrappedLineCount() {
            try {
                int rowStart = Utilities.getRowStart(this, this.getLineEndOffset(this.getLineCount() - 1));
                int rowY = this.modelToView((int)rowStart).y;
                int wrappedRowCount = rowY / this.getRowHeight();
                return wrappedRowCount + 1;
            }
            catch (BadLocationException e) {
                Exceptions.swallow(e);
            }
            catch (NullPointerException e) {
                Exceptions.swallow(e);
            }
            return 1;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExtendedTextArea();
            }
            return this.accessibleContext;
        }

        protected class AccessibleExtendedTextArea
        extends JTextArea.AccessibleJTextArea {
            protected AccessibleExtendedTextArea() {
                super(LargerTextArea.this);
            }

            @Override
            public String getAccessibleName() {
                return ExtendedTextField.this.getAccessibleContext().getAccessibleName();
            }
        }
    }
}

