/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.udb;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.udb.UDBBasicPanel;
import oracle.ide.util.ResourceUtils;

public class UDBConnectionPanel
extends IConnectionPanel {
    public static String SUBTYPE_UDB = "UDB";
    public static String CONNECTION_TYPE = "UDB";
    private static final long serialVersionUID = -9116356172775367840L;
    private UDBBasicPanel m_basicPanel;
    private JPanel m_panel;
    private CardLayout m_layout;
    public static final String HOST = "localhost";
    public static final String PORT = "50000";

    public UDBConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this.m_basicPanel = new UDBBasicPanel(this);
        this.m_layout = new CardLayout(0, 0);
        this.m_panel = new JPanel(this.m_layout);
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, null, (String)ConnectionDialogArb.getString((String)"CONNECTION_TYPE"));
        this.m_panel.add((Component)this.m_basicPanel, "Basic");
        this.add(this.m_panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.m_layout.show(this.m_panel, "Basic");
    }

    private CDComponentView getPanel() {
        return this.m_basicPanel;
    }

    public void clear() {
        this.m_basicPanel.clear();
    }

    public Properties getConnectionProperties() {
        return this.getInput(this.m_props);
    }

    public String getConnectionType() {
        return CONNECTION_TYPE;
    }

    public String getDriver() {
        return this.m_basicPanel.getDriver();
    }

    public String[] getSupportedDrivers() {
        return new String[]{this.getDriver()};
    }

    public void setDefaultPrompts() {
        this.m_basicPanel.setDefaultPrompts();
    }

    public void updatePrompts(Properties properties) {
        String string = properties.getProperty("hostname");
        this.m_basicPanel.m_tfdHost.setText(string);
        String string2 = properties.getProperty("port");
        this.m_basicPanel.m_tfdPort.setText(string2 != null ? string2 : PORT);
        String string3 = properties.getProperty("dataSourceName");
        if (string3 != null) {
            this.m_basicPanel.m_db2DataSource.setText(string3);
        }
        properties.setProperty("ConnName", this.getConnectionName());
        properties.setProperty("dataSourceName", this.m_basicPanel.m_db2DataSource.getText());
    }

    private Properties getInput(Properties properties) {
        properties.setProperty("subtype", SUBTYPE_UDB);
        properties.setProperty("RaptorConnectionType", CONNECTION_TYPE);
        properties.setProperty("dataSourceName", this.m_basicPanel.m_db2DataSource.getText());
        CDComponentView cDComponentView = this.getPanel();
        cDComponentView.populateComponent(properties);
        return properties;
    }
}

