/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.sqlserver;

import java.net.ConnectException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.thirdparty.sqlserver.SQLServerConnectionPanel;
import oracle.jdbc.OracleDriver;
import oracle.jdeveloper.db.adapter.CustomConnectionCreator;

public class SQLServerConnectionCreator
extends CustomConnectionCreator {
    private static boolean canHaveNullPassword = false;

    protected boolean allowNullPassword() {
        return canHaveNullPassword;
    }

    public Connection getConnection(Properties properties) throws SQLException {
        properties.setProperty("NoPasswordConnection", "TRUE");
        canHaveNullPassword = true;
        try {
            Connection connection;
            block26: {
                Object object;
                Object object2;
                String string = properties.getProperty("user");
                String string2 = properties.getProperty("password");
                if (!this.hasLength(string2) && !this.allowNullPassword()) {
                    throw new SQLException(this.getBundle().getString("ERROR_MISSING_PASS"), "");
                }
                String string3 = properties.getProperty("customUrl");
                if (!this.hasLength(string3)) {
                    string3 = this.getConnectionURL(properties);
                }
                Driver driver = null;
                boolean bl = false;
                try {
                    object2 = RaptorClassLoader.findClassLoader((String)"net.sourceforge.jtds.jdbc.Driver");
                    object = Class.forName("net.sourceforge.jtds.jdbc.Driver", true, (ClassLoader)object2);
                    driver = (Driver)((Class)object).newInstance();
                    bl = true;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (Throwable throwable) {
                    SQLException sQLException = new SQLException(throwable.getLocalizedMessage());
                    sQLException.initCause(throwable);
                    throw sQLException;
                }
                if (!bl) {
                    try {
                        object2 = RaptorClassLoader.findClassLoader((String)"com.microsoft.jdbc.sqlserver.SQLServerDriver");
                        object = Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver", true, (ClassLoader)object2);
                        driver = (Driver)((Class)object).newInstance();
                        bl = true;
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (Throwable throwable) {
                        object = new SQLException(throwable.getLocalizedMessage());
                        ((Throwable)object).initCause(throwable);
                        throw object;
                    }
                }
                if (!bl) {
                    try {
                        object2 = RaptorClassLoader.findClassLoader((String)"com.microsoft.sqlserver.jdbc.SQLServerDriver");
                        object = Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver", true, (ClassLoader)object2);
                        driver = (Driver)((Class)object).newInstance();
                        bl = true;
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new SQLException(this.getBundle().getString("ERROR_DRIVER_CLASS_NOT_FOUND"));
                    }
                    catch (Throwable throwable) {
                        object = new SQLException(throwable.getLocalizedMessage());
                        ((Throwable)object).initCause(throwable);
                        throw object;
                    }
                }
                object2 = new Properties();
                object = properties.getProperty("role");
                if (this.hasLength((String)object)) {
                    ((Properties)object2).put("internal_logon", object);
                }
                if (this.hasLength(string)) {
                    ((Properties)object2).put("user", string);
                }
                if (this.hasLength(string2)) {
                    ((Properties)object2).put("password", string2);
                }
                this.setCustomProperties(properties, (Properties)object2);
                connection = null;
                try {
                    connection = driver.connect(string3, (Properties)object2);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new SQLException(unsatisfiedLinkError.getMessage());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    if (!(driver instanceof OracleDriver)) break block26;
                    throw new SQLException(this.getBundle().getString("ERROR_UNSUPPORTED_ORACLE_VERSION"));
                }
            }
            if (connection == null) {
                throw new SQLException(this.getBundle().getString("ERROR_INVALID_URL"));
            }
            return connection;
        }
        catch (SQLException sQLException) {
            if (sQLException.getCause() instanceof ConnectException) {
                throw new SQLException(ConnectionDialogArb.format((String)"SQL_SERVER_CONNECTION_ERROR", (Object[])new Object[]{properties.getProperty("hostname")}), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            throw sQLException;
        }
    }

    protected void setCustomProperties(Properties properties, Properties properties2) {
        super.setCustomProperties(properties, properties2);
        String string = properties.getProperty(SQLServerConnectionPanel.SQLSERVER_DEFAULT_PASSWORD);
        if (string != null && string.equals(Boolean.TRUE.toString())) {
            properties2.setProperty("password", "");
        }
    }
}

