/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.jdbc;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.thirdparty.jdbc.DMJDBCConnectionPanel;
import oracle.dbtools.thirdparty.jdbc.JDBCMessages;
import oracle.ide.natives.NativeHandler;

public class DMJDBCBasicPanel
extends JPanel
implements CDComponentView {
    public static final String DB_TYPE_CLASS_REFTYPE_STRING = "DB_TYPE";
    public static final String[] DB_TYPES = new String[]{null, "Oracle", "SQL Server", "DB2/390", "DB2/UDB"};
    private static final long serialVersionUID = -3381627083207173706L;
    private JRadioButton m_JdbcOdbcBridge;
    private JRadioButton m_ThirdPartyDriver;
    private ButtonGroup m_DrvTypeGroup;
    private JPanel m_DrvTypePanel;
    private JPanel m_ContainterPanel;
    private JPanel m_JdbcOdbcPanel;
    private JLabel m_lblDataSource;
    private JTextField m_cbxDSNs;
    private JLabel m_lblExtraParams;
    private JTextField m_txtExtraParams;
    private JPanel m_ThirdPartyDrvPanel;
    private JLabel m_lblJdbcUrl;
    private JTextField m_txtJdbcUrl;
    private CardLayout m_CardLayout = new CardLayout(0, 0);
    private boolean m_JdbcOdbcSelected = true;
    private final NativeHandler m_NativeHandler = new NativeHandler();
    private JLabel m_lblDrvClassName;
    private JTextField m_txtDrvClassName;
    private JPanel m_DBTypePanel;
    private JLabel m_lblDBType;
    private JComboBox m_cbDBType;
    private DMJDBCConnectionPanel m_connPanel;
    private static final String DRIVER_CLASSNAME = "sun.jdbc.odbc.JdbcOdbcDriver";

    public DMJDBCBasicPanel(DMJDBCConnectionPanel dMJDBCConnectionPanel) {
        this.m_connPanel = dMJDBCConnectionPanel;
        try {
            this.m_NativeHandler.initialize();
            this.setLayout(new BorderLayout());
            this.m_JdbcOdbcBridge = new JRadioButton(JDBCMessages.getString("ODBC_BRIDGE"), true);
            this.m_JdbcOdbcBridge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DMJDBCBasicPanel.this.m_CardLayout.show(DMJDBCBasicPanel.this.m_ContainterPanel, "Card1");
                    DMJDBCBasicPanel.this.m_JdbcOdbcSelected = true;
                }
            });
            this.m_ThirdPartyDriver = new JRadioButton(JDBCMessages.getString("THIRD_PARTY_DRIVER"));
            this.m_ThirdPartyDriver.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DMJDBCBasicPanel.this.m_CardLayout.show(DMJDBCBasicPanel.this.m_ContainterPanel, "Card2");
                    DMJDBCBasicPanel.this.m_JdbcOdbcSelected = false;
                }
            });
            this.m_DrvTypeGroup = new ButtonGroup();
            this.m_DrvTypeGroup.add(this.m_JdbcOdbcBridge);
            this.m_DrvTypeGroup.add(this.m_ThirdPartyDriver);
            this.m_DrvTypePanel = new JPanel();
            this.m_DrvTypePanel.setLayout(new GridBagLayout());
            this.m_DrvTypePanel.add((Component)this.m_JdbcOdbcBridge, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 5, 10, 5), 0, 0));
            this.m_DrvTypePanel.add((Component)this.m_ThirdPartyDriver, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 12, 2, new Insets(10, 5, 10, 5), 0, 0));
            this.m_JdbcOdbcPanel = new JPanel();
            this.m_ThirdPartyDrvPanel = new JPanel();
            this.m_ContainterPanel = new JPanel();
            this.m_ContainterPanel.setLayout(this.m_CardLayout);
            this.m_lblJdbcUrl = new JLabel(JDBCMessages.getString("JDBC_URL"));
            this.m_txtJdbcUrl = new JTextField();
            this.m_lblDrvClassName = new JLabel(JDBCMessages.getString("DRV_CLASS"));
            this.m_txtDrvClassName = new JTextField();
            this.m_lblDataSource = new JLabel(JDBCMessages.getString("DSN_LBL"));
            this.m_cbxDSNs = new JTextField();
            this.m_lblExtraParams = new JLabel(JDBCMessages.getString("EXTRA_PARAM"));
            this.m_txtExtraParams = new JTextField();
            this.m_DBTypePanel = new JPanel(new FlowLayout(0));
            this.m_lblDBType = new JLabel(JDBCMessages.getString(DB_TYPE_CLASS_REFTYPE_STRING));
            this.m_cbDBType = new JComboBox<String>(DB_TYPES);
            this.m_cbDBType.setSelectedIndex(0);
            this.m_DBTypePanel.add((Component)this.m_lblDBType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_DBTypePanel.add((Component)this.m_cbDBType, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_JdbcOdbcPanel.setLayout(new GridBagLayout());
            this.m_JdbcOdbcPanel.add((Component)this.m_lblDataSource, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_JdbcOdbcPanel.add((Component)this.m_cbxDSNs, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_JdbcOdbcPanel.add((Component)this.m_lblExtraParams, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_JdbcOdbcPanel.add((Component)this.m_txtExtraParams, new GridBagConstraints(1, 1, 0, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.setLayout(new GridBagLayout());
            this.m_ThirdPartyDrvPanel.add((Component)this.m_lblJdbcUrl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.add((Component)this.m_txtJdbcUrl, new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.add((Component)this.m_lblDrvClassName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ThirdPartyDrvPanel.add((Component)this.m_txtDrvClassName, new GridBagConstraints(1, 1, 0, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_ContainterPanel.add((Component)this.m_JdbcOdbcPanel, "Card1");
            this.m_ContainterPanel.add((Component)this.m_ThirdPartyDrvPanel, "Card2");
            this.m_CardLayout.show(this.m_ContainterPanel, "Card1");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.m_DrvTypePanel, "North");
            jPanel.add((Component)this.m_ContainterPanel, "Center");
            this.add((Component)jPanel, "North");
            this.add((Component)this.m_DBTypePanel, "Center");
        }
        catch (Exception exception) {
            Logger.getLogger(DMJDBCBasicPanel.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void clear() {
        this.m_connPanel.clear();
    }

    public void populateComponent(Properties properties) {
        String string;
        if (this.m_JdbcOdbcSelected) {
            properties.setProperty("driver", DRIVER_CLASSNAME);
            string = this.m_cbxDSNs.getText();
            String string2 = this.m_txtExtraParams.getText();
            if (string != null && string.trim().length() > 0) {
                properties.setProperty("dataSourceName", string);
                properties.setProperty("customUrl", "jdbc:odbc:" + string);
            } else {
                properties.remove("dataSourceName");
                properties.setProperty("customUrl", null);
            }
            if (string2 != null && string2.trim().length() > 0) {
                properties.setProperty("parameters", string2);
            }
        } else {
            string = this.m_txtDrvClassName.getText();
            String string3 = this.m_txtJdbcUrl.getText();
            if (string != null && string.trim().length() > 0) {
                properties.setProperty("driver", string);
            }
            if (string3 != null && string3.trim().length() > 0) {
                properties.setProperty("customUrl", string3);
            }
        }
        string = (String)this.m_cbDBType.getSelectedItem();
        if (string == null) {
            properties.remove(DB_TYPE_CLASS_REFTYPE_STRING);
        } else {
            properties.setProperty(DB_TYPE_CLASS_REFTYPE_STRING, string);
        }
    }

    public void setDefaultPrompts() {
    }

    public void setDBType(String string) {
        if (string == null) {
            this.m_cbDBType.setSelectedIndex(0);
        } else {
            for (int i = 0; i < DB_TYPES.length; ++i) {
                String string2 = DB_TYPES[i];
                if (!string.equalsIgnoreCase(string2)) continue;
                this.m_cbDBType.setSelectedIndex(i);
                return;
            }
        }
    }

    private String getDsn() {
        return this.m_JdbcOdbcSelected ? this.m_cbxDSNs.getText() : null;
    }

    public void setDsn(String string) {
        if (string != null && this.m_JdbcOdbcSelected) {
            this.m_cbxDSNs.setText(string);
        }
    }

    private String getExtraParams() {
        String string = this.m_txtExtraParams.getText();
        return string != null ? string.trim() : string;
    }

    public void setExtraParams(String string) {
        if (this.m_JdbcOdbcSelected) {
            this.m_txtExtraParams.setText(string != null ? string : "");
        }
    }

    public String getDriverClass() {
        String string = null;
        string = !this.m_JdbcOdbcSelected ? ((string = this.m_txtDrvClassName.getText()) != null ? string.trim() : string) : DRIVER_CLASSNAME;
        return string;
    }

    public void setDriverClass(String string) {
        if (!this.m_JdbcOdbcSelected) {
            this.m_txtDrvClassName.setText(string != null ? string : "");
        }
    }

    public String getThirdPartyJdbcUrl() {
        String string = null;
        if (!this.m_JdbcOdbcSelected) {
            string = this.m_txtJdbcUrl.getText();
            string = string != null ? string.trim() : string;
        } else {
            String string2 = this.getDsn();
            String string3 = this.getExtraParams();
            string = "jdbc:odbc:" + (string3 != null && string3.length() > 0 ? string2 + ";" + string3 : string2);
        }
        return string;
    }

    public void setThirdPartyJdbcUrl(String string) {
        if (!this.m_JdbcOdbcSelected) {
            this.m_txtJdbcUrl.setText(string != null ? string : "");
        }
    }

    public boolean isJdbcOdbc() {
        return this.m_JdbcOdbcSelected;
    }

    public void setDriverType(boolean bl) {
        if (bl) {
            this.m_JdbcOdbcBridge.setSelected(true);
            this.m_JdbcOdbcSelected = true;
            this.m_CardLayout.show(this.m_ContainterPanel, "Card1");
        } else {
            this.m_ThirdPartyDriver.setSelected(true);
            this.m_JdbcOdbcSelected = false;
            this.m_CardLayout.show(this.m_ContainterPanel, "Card2");
        }
    }
}

